package com.ejie.p06b;

import java.util.Hashtable;
import javax.naming.*;
import javax.jms.*;

public class JMSClient {
	private static InitialContext ctx = null;
	   private static QueueConnectionFactory qcf = null;
	   private static QueueConnection qc = null;
	   private static QueueSession qsess = null;
	   private static Queue q = null;
	   private static QueueSender qsndr = null;
	   private static TextMessage message = null;
	   // NOTE: The next two lines set the name of the Queue Connection Factory
	   //       and the Queue that we want to use.
	   private static final String QCF_NAME = "p06b.p06bJMSConnectionFactory";
	   private static final String QUEUE_NAME = "p06b.p06bJMSQueue";
	   public JMSClient() {
	       super();
	   }
	   public static void sendMessage(String messageText) {
	       // create InitialContext
	       Hashtable properties = new Hashtable();
	       properties.put(Context.INITIAL_CONTEXT_FACTORY,
	                      "weblogic.jndi.WLInitialContextFactory");
	       // NOTE: The port number of the server is provided in the next line,
	       //       followed by the userid and password on the next two lines.
	       properties.put(Context.PROVIDER_URL, "t3://localhost:7001");
	       properties.put(Context.SECURITY_PRINCIPAL, "weblogic11");
	       properties.put(Context.SECURITY_CREDENTIALS, "weblogic11");
	       try {
	           ctx = new InitialContext(properties);
	       } catch (Exception ne) {
	           ne.printStackTrace(System.err);
	           System.exit(0);
	       }
	       System.out.println("Got InitialContext " + ctx.toString());
	       // create QueueConnectionFactory
	       try {
	           qcf = (QueueConnectionFactory)ctx.lookup(QCF_NAME);
	       }
	       catch (NamingException ne) {
	           ne.printStackTrace(System.err);
	           System.exit(0);
	       }
	       System.out.println("Got QueueConnectionFactory " + qcf.toString());
	       // create QueueConnection
	       try {
	           qc = qcf.createQueueConnection();
	       }
	       catch (JMSException jmse) {
	           jmse.printStackTrace(System.err);
	           System.exit(0);
	       }
	       System.out.println("Got QueueConnection " + qc.toString());
	       // create QueueSession
	       try {
	           qsess = qc.createQueueSession(false, 0);
	       }
	       catch (JMSException jmse) {
	           jmse.printStackTrace(System.err);
	           System.exit(0);
	       }
	       System.out.println("Got QueueSession " + qsess.toString());
	       // lookup Queue
	       try {
	           q = (Queue) ctx.lookup(QUEUE_NAME);
	       }
	       catch (NamingException ne) {
	           ne.printStackTrace(System.err);
	           System.exit(0);
	       }
	       System.out.println("Got Queue " + q.toString());
	       // create QueueSender
	       try {
	           qsndr = qsess.createSender(q);
	       }
	       catch (JMSException jmse) {
	           jmse.printStackTrace(System.err);
	           System.exit(0);
	       }
	       System.out.println("Got QueueSender " + qsndr.toString());
	       // create TextMessage
	       try {
	           message = qsess.createTextMessage();
	       }
	       catch (JMSException jmse) {
	           jmse.printStackTrace(System.err);
	           System.exit(0);
	       }
	       System.out.println("Got TextMessage " + message.toString());
	       // set message text in TextMessage
	       try {
	           message.setText(messageText);
	       }
	       catch (JMSException jmse) {
	           jmse.printStackTrace(System.err);
	           System.exit(0);
	       }
	       System.out.println("Set text in TextMessage " + message.toString());
	       // send message
	       try {
	           qsndr.send(message);
	       }
	       catch (JMSException jmse) {
	           jmse.printStackTrace(System.err);
	           System.exit(0);
	       }
	       System.out.println("Sent message ");
	       // clean up
	       try {
	           message = null;
	           qsndr.close();
	           qsndr = null;
	           q = null;
	           qsess.close();
	           qsess = null;
	           qc.close();
	           qc = null;
	           qcf = null;
	           ctx = null;
	       }
	       catch (JMSException jmse) {
	           jmse.printStackTrace(System.err);
	       }
	       catch (Exception e) {
	           e.printStackTrace(System.err);
	       }
	       System.out.println("Cleaned up and done.");
	   }
	   public static void main(String args[]) {
	       
		   //Con Cert. ciudadano D:\DATOS\ABILBAOG\My Documents\Mi trabajo\Entorno UDA\p06b\WS\scripts\Vuelta vacaciones\Elim nomcargo e idrep
		   
		   //Alta J7102572J segn pgina cuaderno (Pag. 527)
//		   sendMessage("<NotificationBody xmlns=\"com/ejie/notification/xml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <Property>     <Name>EventWho</Name>     <Value>R02</Value>   </Property>   <Property>     <Name>EventTipology</Name>     <Value>R02_TRAMITATION</Value>   </Property>   <Property>     <Name>EventWhat</Name>     <Value>R02_REQUEST</Value>   </Property>   <Property>     <Name>ProcedureID</Name>     <Value>0009402</Value>   </Property>   <Property>     <Name>PlateaType</Name>     <Value>SOLTELEMATICA</Value>   </Property>   <Property>     <Name>PlateaSubType</Name>     <Value>1</Value>   </Property>   <Property>     <Name>Mailbox</Name>     <Value xsi:nil=\"true\"/>   </Property>   <Property>     <Name>Status</Name>     <Value xsi:nil=\"true\"/>   </Property>   <xmlValue><![CDATA[<contextSubmissionEvent xmlns=\"com/ejie/folderManagement/xml\">   <daDocumentalSeries>5744</daDocumentalSeries>   <departmentID>56</departmentID>   <departmentNameEs>HACIENDA Y ECONOMA</departmentNameEs>   <departmentNameEu>OGASUNA ETA EKONOMIA</departmentNameEu>   <entityID>04833001</entityID>   <entityNameEs>Administracin Pblica de la CAE</entityNameEs>   <entityNameEu>EAEko Administrazio Publikoa</entityNameEu>   <familyID>REGIST</familyID>   <folderID>R02TEF84481F2CBF04598F0CEFBF5C550AA35D5A9E44</folderID>   <creationTimestamp>08/09/2017 12:13:43</creationTimestamp>   <mailbox>R01I-Y52B-RMS02</mailbox>   <managingUnitID>2284</managingUnitID>   <managingUnitNameEs>DIRECCIN DE POLTICA FINANCIERA Y RECURSOS INSTITUCIONALES</managingUnitNameEs>   <managingUnitNameEu>FINANTZA POLITIKAKO ETA ERAKUNDEEN BALIABIDEETAKO ZUZENDARITZA</managingUnitNameEu>   <solicitudID>118605</solicitudID>   <procedureID>0009402</procedureID>   <procedureNameEs>Inscripcin en el registro de mediadores de seguros</procedureNameEs>   <procedureNameEu>Aseguru-artekarien erregistroan inskribatzea</procedureNameEu>   <procedureInboxID>R01I-Y52B-RMSRP01</procedureInboxID>   <procedureInboxName>Registro mediadores de seguros - Responsables</procedureInboxName>   <registryNumber>2017RTE00010687</registryNumber>   <registryTimestamp>08/09/2017 12:13:41</registryTimestamp>   <registrySenderID>99999990S</registrySenderID>   <registrySenderName>CIUDADANO FICTICIO ACTIVO</registrySenderName>   <registryAddresseeCode>2284</registryAddresseeCode>   <registryTopicCode>0009402</registryTopicCode>   <participantID>R02T0890516D4331BC6977E65B83C26B3741080FD70A</participantID>   <senderID>99999990S</senderID>   <senderName>CIUDADANO FICTICIO ACTIVO</senderName>   <senderType>2</senderType>   <submissionType>1</submissionType>   <submissionTypeNameEs>Solicitud</submissionTypeNameEs>   <submissionTypeNameEu>Eskaera</submissionTypeNameEu>   <managerCalendarType>cal-capv</managerCalendarType>   <resolutionCalendarType>cal-capv</resolutionCalendarType>   <applicationID>R02T1EEB7F2CA4B49C86898F6F04B5AEE6D7846DE4D2</applicationID>   <ApplicantsInfoEvent>     <ApplicantInfoEvent>       <notificationEvent>         <addresseeID>99999990S</addresseeID>         <addresseeName>CIUDADANO FICTICIO ACTIVO</addresseeName>         <channelType>1</channelType>       </notificationEvent>       <personsEvent>         <personEvent>           <id>J7102572J</id>           <name>ENTIDAD FICTICIO ACTIVO</name>           <personType>2</personType>           <holderShip>1</holderShip>         </personEvent>         <personEvent>           <id>99999990S</id>           <name>CIUDADANO</name>           <lastname1>FICTICIO</lastname1>           <lastname2>ACTIVO</lastname2>           <personType>1</personType>           <holderShip>2</holderShip>         </personEvent>       </personsEvent>       <language>es</language>     </ApplicantInfoEvent>   </ApplicantsInfoEvent>   <documentsEvent>     <documentEvent>       <oid>09f4240180876e15</oid>       <roleId>ejgv_d_solicitud.0.0</roleId>       <roleNameEs>Solicitud</roleNameEs>       <roleNameEu>Eskabide</roleNameEu>       <sourceName>Solicitud.html</sourceName>       <documentType>PRE</documentType>       <extension>html</extension>       <format>E</format>       <sourceBinary>3C3F786D6C2076657273696F6E3D22312E302220656E636F64696E673D225554462D38223F3E0A3C68746D6C3E0A2020200A3C212D2D20656A6776446F63756D656E743C3F786D6C2076657273696F6E3D27312E302720656E636F64696E673D2749534F2D383835392D31273F3E3C656A6776446F63756D656E743E3C6865616465723E3C747970653E4150504C49434154494F4E3C2F747970653E3C76657273696F6E3E312E303C2F76657273696F6E3E3C666C6167733E303C2F666C6167733E3C2F6865616465723E3C626F64793E3C6261736963496E666F3E3C70726F63656475726549443E303030393430323C2F70726F63656475726549443E3C70726F6365647572654E616D653E3C6465736372697074696F6E3E3C6C616E6775616765206C6F63616C653D276575273E3C215B43444154415B417365677572752D617274656B617269656E206572726567697374726F616E20696E736B72696261747A65615D5D3E3C2F6C616E67756167653E3C6C616E6775616765206C6F63616C653D276573273E3C215B43444154415B496E73637269706369C3B36E20656E20656C20726567697374726F206465206D65646961646F7265732064652073656775726F735D5D3E3C2F6C616E67756167653E3C2F6465736372697074696F6E3E3C2F70726F6365647572654E616D653E3C6465706172746D656E7449443E35363C2F6465706172746D656E7449443E3C6D616E6167696E67556E697449443E323238343C2F6D616E6167696E67556E697449443E3C656E7469747949443E30343833333030313C2F656E7469747949443E3C6465706172746D656E744E616D653E3C6465736372697074696F6E3E3C6C616E6775616765206C6F63616C653D276575273E3C215B43444154415B4F474153554E412045544120454B4F4E4F4D49415D5D3E3C2F6C616E67756167653E3C6C616E6775616765206C6F63616C653D276573273E3C215B43444154415B48414349454E444120592045434F4E4F4DC38D415D5D3E3C2F6C616E67756167653E3C2F6465736372697074696F6E3E3C2F6465706172746D656E744E616D653E3C6D616E6167696E67556E69744E616D653E3C6465736372697074696F6E3E3C6C616E6775616765206C6F63616C653D276575273E3C215B43444154415B46494E414E545A4120504F4C4954494B414B4F20455441204552414B554E4445454E2042414C4941424944454554414B4F205A555A454E44415249545A415D5D3E3C2F6C616E67756167653E3C6C616E6775616765206C6F63616C653D276573273E3C215B43444154415B44495245434349C3934E20444520504F4CC38D544943412046494E414E43494552412059205245435552534F5320494E535449545543494F4E414C45535D5D3E3C2F6C616E67756167653E3C2F6465736372697074696F6E3E3C2F6D616E6167696E67556E69744E616D653E3C656E746974794E616D653E3C6465736372697074696F6E3E3C6C616E6775616765206C6F63616C653D276575273E3C215B43444154415B4541456B6F2041646D696E69737472617A696F205075626C696B6F615D5D3E3C2F6C616E67756167653E3C6C616E6775616765206C6F63616C653D276573273E3C215B43444154415B41646D696E69737472616369C3B36E2050C3BA626C696361206465206C61204341455D5D3E3C2F6C616E67756167653E3C2F6465736372697074696F6E3E3C2F656E746974794E616D653E3C2F6261736963496E666F3E3C4170706C6963616E74496E666F3E3C706572736F6E733E3C706572736F6E3E3C686F6C646572536869703E484F4C4445523C2F686F6C646572536869703E3C706572736F6E547970653E323C2F706572736F6E547970653E3C69643E4A373130323537324A3C2F69643E3C6E616D653E454E544944414420464943544943494F2041435449564F3C2F6E616D653E3C617065313E3C2F617065313E3C617065323E3C2F617065323E3C636F6E74616374732F3E3C2F706572736F6E3E3C706572736F6E3E3C686F6C646572536869703E524550524553454E5441544956453C2F686F6C646572536869703E3C706572736F6E547970653E313C2F706572736F6E547970653E3C69643E3939393939393930533C2F69643E3C6E616D653E434955444144414E4F3C2F6E616D653E3C617065313E464943544943494F3C2F617065313E3C617065323E41435449564F3C2F617065323E3C636F6E74616374732F3E3C2F706572736F6E3E3C2F706572736F6E733E3C6E6F74696669636174696F6E3E3C6164647265737365653E3C61646472657373656549443E3939393939393930533C2F61646472657373656549443E3C6164647265737365654E616D653E434955444144414E4F20464943544943494F2041435449564F3C2F6164647265737365654E616D653E3C2F6164647265737365653E3C6368616E6E656C3E3C6368616E6E656C547970653E454C454354524F4E49433C2F6368616E6E656C547970653E3C6368616E6E656C496E666F3E3C656C656374726F6E6963416464726573733E3C2F656C656374726F6E6963416464726573733E3C2F6368616E6E656C496E666F3E3C2F6368616E6E656C3E3C2F6E6F74696669636174696F6E3E3C6C616E67756167653E65733C2F6C616E67756167653E3C2F4170706C6963616E74496E666F3E3C64657461696C496E666F3E3C6465636C61726163696F6E6573526573706F7361626C65733E3C677275706F5F6465636C61726163696F6E65733E3C6465636C61726163696F6E6573526573706F6E7361626C65733E3C677275706F4465636C61726163526573746F3E3C6465636C61726163696F6E5F6573706563696669636131313E3C656C656D656E746F6465636C61726163696F6E5F6573706563696669636131313E313C2F656C656D656E746F6465636C61726163696F6E5F6573706563696669636131313E3C2F6465636C61726163696F6E5F6573706563696669636131313E3C6465636C61726163696F6E5F6573706563696669636131303E3C656C656D656E746F6465636C61726163696F6E5F6573706563696669636131303E313C2F656C656D656E746F6465636C61726163696F6E5F6573706563696669636131303E3C2F6465636C61726163696F6E5F6573706563696669636131303E3C2F677275706F4465636C61726163526573746F3E3C677275706F4465636C61726163486F6E6F726162696C696461643E3C6465636C61726163696F6E5F65737065636966696361393E3C656C656D656E746F6465636C61726163696F6E5F65737065636966696361393E313C2F656C656D656E746F6465636C61726163696F6E5F65737065636966696361393E3C2F6465636C61726163696F6E5F65737065636966696361393E3C6465636C61726163696F6E5F65737065636966696361383E3C656C656D656E746F6465636C61726163696F6E5F65737065636966696361383E313C2F656C656D656E746F6465636C61726163696F6E5F65737065636966696361383E3C2F6465636C61726163696F6E5F65737065636966696361383E3C6465636C61726163696F6E5F65737065636966696361373E3C656C656D656E746F6465636C61726163696F6E5F65737065636966696361373E313C2F656C656D656E746F6465636C61726163696F6E5F65737065636966696361373E3C2F6465636C61726163696F6E5F65737065636966696361373E3C6465636C61726163696F6E5F65737065636966696361363E3C656C656D656E746F6465636C61726163696F6E5F65737065636966696361363E313C2F656C656D656E746F6465636C61726163696F6E5F65737065636966696361363E3C2F6465636C61726163696F6E5F65737065636966696361363E3C6465636C61726163696F6E5F65737065636966696361353E3C656C656D656E746F6465636C61726163696F6E5F65737065636966696361353E313C2F656C656D656E746F6465636C61726163696F6E5F65737065636966696361353E3C2F6465636C61726163696F6E5F65737065636966696361353E3C6465636C61726163696F6E5F65737065636966696361343E3C656C656D656E746F6465636C61726163696F6E5F65737065636966696361343E313C2F656C656D656E746F6465636C61726163696F6E5F65737065636966696361343E3C2F6465636C61726163696F6E5F65737065636966696361343E3C6465636C61726163696F6E5F65737065636966696361333E3C656C656D656E746F6465636C61726163696F6E5F65737065636966696361333E313C2F656C656D656E746F6465636C61726163696F6E5F65737065636966696361333E3C2F6465636C61726163696F6E5F65737065636966696361333E3C6465636C61726163696F6E5F65737065636966696361323E3C656C656D656E746F6465636C61726163696F6E5F65737065636966696361323E313C2F656C656D656E746F6465636C61726163696F6E5F65737065636966696361323E3C2F6465636C61726163696F6E5F65737065636966696361323E3C2F677275706F4465636C61726163486F6E6F726162696C696461643E3C62616E63614A7572696469636F3E3C2F62616E63614A7572696469636F3E3C6167656E746556696E63756C61646F4A7572696469636F3E3C2F6167656E746556696E63756C61646F4A7572696469636F3E3C636F727265646F7253656775726F734A7572696469636F3E3C656C656D656E746F636F727265646F7253656775726F734A7572696469636F3E313C2F656C656D656E746F636F727265646F7253656775726F734A7572696469636F3E3C2F636F727265646F7253656775726F734A7572696469636F3E3C2F6465636C61726163696F6E6573526573706F6E7361626C65733E3C2F677275706F5F6465636C61726163696F6E65733E3C2F6465636C61726163696F6E6573526573706F7361626C65733E3C70617274696369706163696F6E5369676E6966696361746976613E3C6F7267616E6F526573706F6E7361626C653E3C6F7267616E6F526573706F6E7361626C6547523E3C656C656D656E746F47523E3C6F7267616E6F526573706F6E7361626C654E6F6D6272616D69656E746F3E30382F30392F323031373C2F6F7267616E6F526573706F6E7361626C654E6F6D6272616D69656E746F3E3C6F7267616E6F526573706F6E7361626C65436172676F3E4469726563746F722047656E6572616C2041646A756E746F3C2F6F7267616E6F526573706F6E7361626C65436172676F3E3C6F7267616E6F526573706F6E7361626C65466F726D6163696F6E3E437572736F20646520666F726D616369C3B36E20477275706F20413C2F6F7267616E6F526573706F6E7361626C65466F726D6163696F6E3E3C6F7267616E6F526573706F6E7361626C6544656E6F6D696E6163696F6E4964656E74696669636163696F6E3E3330363138313834443C2F6F7267616E6F526573706F6E7361626C6544656E6F6D696E6163696F6E4964656E74696669636163696F6E3E3C6F7267616E6F526573706F6E7361626C655469706F4964656E74696669636163696F6E3E444E493C2F6F7267616E6F526573706F6E7361626C655469706F4964656E74696669636163696F6E3E3C6F7267616E6F526573706F6E7361626C6544656E6F6D696E6163696F6E3E3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930323233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393033333334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303C2F6F7267616E6F526573706F6E7361626C6544656E6F6D696E6163696F6E3E3C2F656C656D656E746F47523E3C656C656D656E746F47523E3C6F7267616E6F526573706F6E7361626C654E6F6D6272616D69656E746F3E30382F30392F323031373C2F6F7267616E6F526573706F6E7361626C654E6F6D6272616D69656E746F3E3C6F7267616E6F526573706F6E7361626C65436172676F3E4469726563746F722047656E6572616C2041646A756E746F3C2F6F7267616E6F526573706F6E7361626C65436172676F3E3C6F7267616E6F526573706F6E7361626C65466F726D6163696F6E3E437572736F20646520666F726D616369C3B36E20477275706F20413C2F6F7267616E6F526573706F6E7361626C65466F726D6163696F6E3E3C6F7267616E6F526573706F6E7361626C6544656E6F6D696E6163696F6E4964656E74696669636163696F6E3E4231323334353637343C2F6F7267616E6F526573706F6E7361626C6544656E6F6D696E6163696F6E4964656E74696669636163696F6E3E3C6F7267616E6F526573706F6E7361626C655469706F4964656E74696669636163696F6E3E4349463C2F6F7267616E6F526573706F6E7361626C655469706F4964656E74696669636163696F6E3E3C6F7267616E6F526573706F6E7361626C6544656E6F6D696E6163696F6E3E3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930323233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393033333334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303C2F6F7267616E6F526573706F6E7361626C6544656E6F6D696E6163696F6E3E3C2F656C656D656E746F47523E3C656C656D656E746F475256616C6F7265733E3C6F7267616E6F526573706F6E7361626C65436172676F3E30393C2F6F7267616E6F526573706F6E7361626C65436172676F3E3C6F7267616E6F526573706F6E7361626C65466F726D6163696F6E3E323C2F6F7267616E6F526573706F6E7361626C65466F726D6163696F6E3E3C6F7267616E6F526573706F6E7361626C655469706F4964656E74696669636163696F6E3E313C2F6F7267616E6F526573706F6E7361626C655469706F4964656E74696669636163696F6E3E3C2F656C656D656E746F475256616C6F7265733E3C656C656D656E746F475256616C6F7265733E3C6F7267616E6F526573706F6E7361626C65436172676F3E30393C2F6F7267616E6F526573706F6E7361626C65436172676F3E3C6F7267616E6F526573706F6E7361626C65466F726D6163696F6E3E323C2F6F7267616E6F526573706F6E7361626C65466F726D6163696F6E3E3C6F7267616E6F526573706F6E7361626C655469706F4964656E74696669636163696F6E3E323C2F6F7267616E6F526573706F6E7361626C655469706F4964656E74696669636163696F6E3E3C2F656C656D656E746F475256616C6F7265733E3C2F6F7267616E6F526573706F6E7361626C6547523E3C2F6F7267616E6F526573706F6E7361626C653E3C61646D696E6973747261646F7265733E3C61646D696E6973747261646F72657347523E3C656C656D656E746F47523E3C61646D696E6973747261646F7265734E6F6D6272616D69656E746F3E30382F30392F323031373C2F61646D696E6973747261646F7265734E6F6D6272616D69656E746F3E3C61646D696E6973747261646F726573436172676F3E41646D696E6973747261646F7220C39A6E69636F3C2F61646D696E6973747261646F726573436172676F3E3C61646D696E6973747261646F726573446E69526570726573656E74616E74653E3C2F61646D696E6973747261646F726573446E69526570726573656E74616E74653E3C61646D696E6973747261646F7265734E6F6D627265526570726573656E74616E74653E3C2F61646D696E6973747261646F7265734E6F6D627265526570726573656E74616E74653E3C61646D696E6973747261646F72657344656E6F6D696E6163696F6E4964656E74696669636163696F6E3E3330363138313834443C2F61646D696E6973747261646F72657344656E6F6D696E6163696F6E4964656E74696669636163696F6E3E3C61646D696E6973747261646F7265735469706F4964656E74696669636163696F6E3E444E493C2F61646D696E6973747261646F7265735469706F4964656E74696669636163696F6E3E3C61646D696E6973747261646F72657344656E6F6D696E6163696F6E3E3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930323233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393033333334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303C2F61646D696E6973747261646F72657344656E6F6D696E6163696F6E3E3C2F656C656D656E746F47523E3C656C656D656E746F47523E3C61646D696E6973747261646F7265734E6F6D6272616D69656E746F3E30382F30392F323031373C2F61646D696E6973747261646F7265734E6F6D6272616D69656E746F3E3C61646D696E6973747261646F726573436172676F3E41646D696E6973747261646F7220C39A6E69636F3C2F61646D696E6973747261646F726573436172676F3E3C61646D696E6973747261646F726573446E69526570726573656E74616E74653E3330363138313834443C2F61646D696E6973747261646F726573446E69526570726573656E74616E74653E3C61646D696E6973747261646F7265734E6F6D627265526570726573656E74616E74653E4142473C2F61646D696E6973747261646F7265734E6F6D627265526570726573656E74616E74653E3C61646D696E6973747261646F72657344656E6F6D696E6163696F6E4964656E74696669636163696F6E3E4231323334353637343C2F61646D696E6973747261646F72657344656E6F6D696E6163696F6E4964656E74696669636163696F6E3E3C61646D696E6973747261646F7265735469706F4964656E74696669636163696F6E3E4349463C2F61646D696E6973747261646F7265735469706F4964656E74696669636163696F6E3E3C61646D696E6973747261646F72657344656E6F6D696E6163696F6E3E3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930323233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393033333334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303C2F61646D696E6973747261646F72657344656E6F6D696E6163696F6E3E3C2F656C656D656E746F47523E3C656C656D656E746F475256616C6F7265733E3C61646D696E6973747261646F726573436172676F3E30323C2F61646D696E6973747261646F726573436172676F3E3C61646D696E6973747261646F7265735469706F4964656E74696669636163696F6E3E313C2F61646D696E6973747261646F7265735469706F4964656E74696669636163696F6E3E3C2F656C656D656E746F475256616C6F7265733E3C656C656D656E746F475256616C6F7265733E3C61646D696E6973747261646F726573436172676F3E30323C2F61646D696E6973747261646F726573436172676F3E3C61646D696E6973747261646F7265735469706F4964656E74696669636163696F6E3E323C2F61646D696E6973747261646F7265735469706F4964656E74696669636163696F6E3E3C2F656C656D656E746F475256616C6F7265733E3C2F61646D696E6973747261646F72657347523E3C2F61646D696E6973747261646F7265733E3C736F63696F735061727469636970616E7465733E3C736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E47523E3C656C656D656E746F47523E3C736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E4E6F6D627265526570726573656E74616E74653E3C2F736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E4E6F6D627265526570726573656E74616E74653E3C736F63696F7350617274696369706163696F6E416C74613E30382F30392F323031373C2F736F63696F7350617274696369706163696F6E416C74613E3C736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E3E3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930323233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393033333334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303C2F736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E3E3C736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E446E69526570726573656E74616E74653E3C2F736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E446E69526570726573656E74616E74653E3C736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E3E3330363138313834443C2F736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E3E3C736F63696F7350617274696369706163696F6E506F7263656E74616A653E36303C2F736F63696F7350617274696369706163696F6E506F7263656E74616A653E3C736F63696F7350617274696369706163696F6E5469706F4964656E74696669636163696F6E3E444E493C2F736F63696F7350617274696369706163696F6E5469706F4964656E74696669636163696F6E3E3C2F656C656D656E746F47523E3C656C656D656E746F47523E3C736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E4E6F6D627265526570726573656E74616E74653E4142473C2F736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E4E6F6D627265526570726573656E74616E74653E3C736F63696F7350617274696369706163696F6E416C74613E30382F30392F323031373C2F736F63696F7350617274696369706163696F6E416C74613E3C736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E3E3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930323233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393033333334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303C2F736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E3E3C736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E446E69526570726573656E74616E74653E3330363138313834443C2F736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E446E69526570726573656E74616E74653E3C736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E3E4231323334353637343C2F736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E3E3C736F63696F7350617274696369706163696F6E506F7263656E74616A653E34303C2F736F63696F7350617274696369706163696F6E506F7263656E74616A653E3C736F63696F7350617274696369706163696F6E5469706F4964656E74696669636163696F6E3E4349463C2F736F63696F7350617274696369706163696F6E5469706F4964656E74696669636163696F6E3E3C2F656C656D656E746F47523E3C656C656D656E746F475256616C6F7265733E3C736F63696F7350617274696369706163696F6E5469706F4964656E74696669636163696F6E3E313C2F736F63696F7350617274696369706163696F6E5469706F4964656E74696669636163696F6E3E3C2F656C656D656E746F475256616C6F7265733E3C656C656D656E746F475256616C6F7265733E3C736F63696F7350617274696369706163696F6E5469706F4964656E74696669636163696F6E3E323C2F736F63696F7350617274696369706163696F6E5469706F4964656E74696669636163696F6E3E3C2F656C656D656E746F475256616C6F7265733E3C2F736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E47523E3C6361706974616C536F6369616C416363696F6E657343616D706F3E32303C2F6361706974616C536F6369616C416363696F6E657343616D706F3E3C6361706974616C536F6369616C496D706F72746543616D706F3E323030303C2F6361706974616C536F6369616C496D706F72746543616D706F3E3C2F736F63696F735061727469636970616E7465733E3C2F70617274696369706163696F6E5369676E6966696361746976613E3C63617061636964616446696E616E63696572613E3C63616C63756C6F43617061636964616446696E616E63696572613E3C636F6E74726174614176616C3E3C636F6E747261746153656775726F3E3C2F636F6E747261746153656775726F3E3C73656775726F3E3C2F73656775726F3E3C6176616C43616D706F3E3C2F6176616C43616D706F3E3C6176616C3E3C2F6176616C3E3C2F636F6E74726174614176616C3E3C696D706F7274654361706163696461643E3C2F696D706F7274654361706163696461643E3C696D706F72746543756174726F506F726369656E746F3E3C2F696D706F72746543756174726F506F726369656E746F3E3C696D706F727465466F6E646F735065726469646F733E3C2F696D706F727465466F6E646F735065726469646F733E3C2F63616C63756C6F43617061636964616446696E616E63696572613E3C2F63617061636964616446696E616E63696572613E3C6461746F734D65646961646F723E3C6361706163696461643E3C6465636C61726F6361706163696461643E323C2F6465636C61726F6361706163696461643E3C2F6361706163696461643E3C656D70726573617376696E63756C616461733E3C2F656D70726573617376696E63756C616461733E3C616363696F6E6973746173506172746963697065733E3C2F616363696F6E6973746173506172746963697065733E3C4F7267616E6F446972656363696F6E3E3C2F4F7267616E6F446972656363696F6E3E3C617474636C69656E74653E3C6461746F73646566656E736F72436C69656E74653E3C446E69446566656E736F723E3C2F446E69446566656E736F723E3C5469706F446E69446566656E736F723E3C2F5469706F446E69446566656E736F723E3C41706532446566656E736F723E3C2F41706532446566656E736F723E3C41706531446566656E736F72723E3C2F41706531446566656E736F72723E3C4E6F6D627265446566656E736F723E3C2F4E6F6D627265446566656E736F723E3C2F6461746F73646566656E736F72436C69656E74653E3C6461746F73746974756C6172536572766963696F4174743E3C446E693E3C2F446E693E3C5469706F446E693E3C2F5469706F446E693E3C41706532546974756C61723E3C2F41706532546974756C61723E3C41706531546974756C61723E3C2F41706531546974756C61723E3C4E6F6D627265546974756C61723E3C2F4E6F6D627265546974756C61723E3C2F6461746F73746974756C6172536572766963696F4174743E3C6174656E63696F6E636C69656E74653E313C2F6174656E63696F6E636C69656E74653E3C2F617474636C69656E74653E3C7469706F4D65646961646F7256616C6F72323E313C2F7469706F4D65646961646F7256616C6F72323E3C7469706F4D65646961646F7256616C6F72313E313C2F7469706F4D65646961646F7256616C6F72313E3C646972656363696F6E4163746976696461643E3C43616D706F42617369636F7765623E3C2F43616D706F42617369636F7765623E3C43616D706F42617369636F656D61696C3E3C2F43616D706F42617369636F656D61696C3E3C43616D706F42617369636F54666E6F3E3C2F43616D706F42617369636F54666E6F3E3C43616D706F42617369636F43703E34383030393C2F43616D706F42617369636F43703E3C43616D706F42617369636F4C657472613E413C2F43616D706F42617369636F4C657472613E3C43616D706F42617369636F5069736F3E323C2F43616D706F42617369636F5069736F3E3C43616D706F42617369636F506F7274616C3E31383C2F43616D706F42617369636F506F7274616C3E3C43616D706F42617369636F43616C6C653E414D3C2F43616D706F42617369636F43616C6C653E3C6C697374614D756E69636970696F3E3032303C2F6C697374614D756E69636970696F3E3C6C6973746150726F76696E6369613E34383C2F6C6973746150726F76696E6369613E3C2F646972656363696F6E4163746976696461643E3C477275706F7469706F6D65646961646F723E3C7469706F444E4931324D65646961646F7231333E53493C2F7469706F444E4931324D65646961646F7231333E3C7469706F444E4931324D65646961646F723133343E53493C2F7469706F444E4931324D65646961646F723133343E3C7469706F444E4931324D65646961646F72313233343E53493C2F7469706F444E4931324D65646961646F72313233343E3C7469706F4D65646961646F7235363E4E4F3C2F7469706F4D65646961646F7235363E3C7469706F4D65646961646F7231333E53493C2F7469706F4D65646961646F7231333E3C7469706F4D65646961646F7233343E53493C2F7469706F4D65646961646F7233343E3C7469706F4D65646961646F723133343E53493C2F7469706F4D65646961646F723133343E3C7469706F4D65646961646F72313233343E53493C2F7469706F4D65646961646F72313233343E3C4C697374617469706F4D65646961646F723E333C2F4C697374617469706F4D65646961646F723E3C2F477275706F7469706F6D65646961646F723E3C6465636C61726163696F6E416D6269746F5465727269746F7269616C3E3C616D6269746F3E3C656C656D656E746F616D6269746F3E313C2F656C656D656E746F616D6269746F3E3C2F616D6269746F3E3C2F6465636C61726163696F6E416D6269746F5465727269746F7269616C3E3C2F6461746F734D65646961646F723E3C6461746F7342617369636F733E3C6461746F73417669736F3E3C726164696F456C656769724461746F73417669736F3E313C2F726164696F456C656769724461746F73417669736F3E3C2F6461746F73417669736F3E3C6461746F73506572736F6E616C65733E3C6461746F73726570726573656E746174697665313E3C726570726573656E746174697665315365786F3E3C2F726570726573656E746174697665315365786F3E3C2F6461746F73726570726573656E746174697665313E3C686F6C646572315365786F3E3C2F686F6C646572315365786F3E3C7469706F444E4931323E53493C2F7469706F444E4931323E3C2F6461746F73506572736F6E616C65733E3C6461746F734F7267616E6F476573746F723E3C6D616E6167696E67556E69744E616D653E44495245434349C3934E20444520504F4CC38D544943412046494E414E43494552412059205245435552534F5320494E535449545543494F4E414C45533C2F6D616E6167696E67556E69744E616D653E3C2F6461746F734F7267616E6F476573746F723E3C2F6461746F7342617369636F733E3C2F64657461696C496E666F3E3C73656E6465723E3C69643E3939393939393930533C2F69643E3C6E616D653E434955444144414E4F20464943544943494F2041435449564F3C2F6E616D653E3C2F73656E6465723E3C2F626F64793E3C6174746163686D656E74732F3E3C2F656A6776446F63756D656E743E656A6776446F63756D656E74202D2D3E0A3C686561643E3C6D65746120636F6E74656E743D22746578742F68746D6C3B636861727365743D49534F2D383835392D312220687474702D65717569763D22436F6E74656E742D74797065222F3E0A3C646976207374796C653D22646973706C61793A206E6F6E653B223E0A3C702069643D227369676E6174757265506C616365223E3C64733A5369676E61747572652049643D225369676E61747572652D313530343836353631333936342220786D6C6E733A64733D22687474703A2F2F7777772E77332E6F72672F323030302F30392F786D6C6473696723223E0A3C64733A5369676E6564496E666F2049643D225369676E6564496E666F2D31353034383635363133393634223E0A3C64733A43616E6F6E6963616C697A6174696F6E4D6574686F6420416C676F726974686D3D22687474703A2F2F7777772E77332E6F72672F54522F323030312F5245432D786D6C2D6331346E2D3230303130333135222F3E0A3C64733A5369676E61747572654D6574686F6420416C676F726974686D3D22687474703A2F2F7777772E77332E6F72672F323030302F30392F786D6C64736967237273612D73686131222F3E0A3C64733A5265666572656E6365205552493D22234B6579496E666F2D31353034383635363133393634223E0A3C64733A4469676573744D6574686F6420416C676F726974686D3D22687474703A2F2F7777772E77332E6F72672F323030302F30392F786D6C647369672373686131222F3E0A3C64733A44696765737456616C75653E73563936354855516E6F304A387969595633384A41346C672F4A513D3C2F64733A44696765737456616C75653E0A3C2F64733A5265666572656E63653E0A3C64733A5265666572656E63652049643D225369676E61747572652D313530343836353631333936342D5369676E656450726F706572746965732D5265662220547970653D22687474703A2F2F7572692E657473692E6F72672F3031393033235369676E656450726F7065727469657322205552493D22235369676E61747572652D313530343836353631333936342D5369676E656450726F70657274696573223E0A3C64733A5472616E73666F726D733E0A3C64733A5472616E73666F726D20416C676F726974686D3D22687474703A2F2F7777772E77332E6F72672F54522F323030312F5245432D786D6C2D6331346E2D3230303130333135222F3E0A3C2F64733A5472616E73666F726D733E0A3C64733A4469676573744D6574686F6420416C676F726974686D3D22687474703A2F2F7777772E77332E6F72672F323030302F30392F786D6C647369672373686131222F3E0A3C64733A44696765737456616C75653E3368496351645A526E3770416A68712F3068435456517874654D453D3C2F64733A44696765737456616C75653E0A3C2F64733A5265666572656E63653E0A3C64733A5265666572656E6365205552493D222378706F696E746572282F29223E0A3C64733A5472616E73666F726D733E0A3C64733A5472616E73666F726D20416C676F726974686D3D22687474703A2F2F7777772E77332E6F72672F323030302F30392F786D6C6473696723656E76656C6F7065642D7369676E6174757265222F3E0A3C64733A5472616E73666F726D20416C676F726974686D3D22687474703A2F2F7777772E77332E6F72672F54522F323030312F5245432D786D6C2D6331346E2D32303031303331352357697468436F6D6D656E7473222F3E0A3C2F64733A5472616E73666F726D733E0A3C64733A4469676573744D6574686F6420416C676F726974686D3D22687474703A2F2F7777772E77332E6F72672F323030302F30392F786D6C647369672373686131222F3E0A3C64733A44696765737456616C75653E44577033593272395A48726C394A7445397A754C65397074424B6B3D3C2F64733A44696765737456616C75653E0A3C2F64733A5265666572656E63653E0A3C2F64733A5369676E6564496E666F3E0A3C64733A5369676E617475726556616C75652049643D22446F63756D656E745369676E617475726556616C75652D31353034383635363133393634223E0A444F64422F6A7168432F657A6D4F4A716859527233506339714B4C4275482B686745734D4D4C627A37506974597561584A6C466644345561436E336C2F6C786E2F353770346F5366664163630A53512B743339694C30413368364A6B74665A5475736443687A522B4A4B47654C574A4A6364516D666E6D4B47466E46784A3976523061445564614B7258636C476A4D4B42424864777064526C0A74644E3466354437615262776246356E2F366E49314258667256375049674E51723770594761335171775776354643526C3659335934524E45386C5256467947454E47426D695065567A56630A734C662B4C66435275504C4A30416D4D464B5761522B7236555437384132435574356E5A3449556C6E4630306A6C645370753658307A645330397138533343712B73727765564A366E362B6F0A6F5179366A2B32706C7A75644971756F525646545630302F427364585376504F55784A4262673D3D0A3C2F64733A5369676E617475726556616C75653E0A3C64733A4B6579496E666F2049643D224B6579496E666F2D31353034383635363133393634223E0A3C64733A58353039446174613E0A3C64733A5835303943657274696669636174653E0A4D49494939444343427479674177494241674943455330774451594A4B6F5A496876634E4151454C42514177675A6378437A414A42674E5642415954416B56544D525177456759445651514B0A4441744A576B564F55455567557935424C6A45364D4467474131554543777778546C70614946707064584A3059576470636D6B676348566962476C72623245674C5342445A584A3061575A700A5932466B6279427764574A7361574E7649464E44535445324D4451474131554541777774513045675A47556751326C315A47466B59573576637942354945567564476C6B5957526C6379416F0A4E436B674C53424552564E42556C4A50544578504D423458445445334D444D784E4445314E5463314F466F58445449784D444D784E4445314E5463314F466F77676745364D517377435159440A5651514745774A46557A45304D4449474131554543777772576D6C31636E52685A326C7961534276626D467964485668494330675132567964476C6D61574E685A473867636D566A623235760A59326C6B627A45344D445947413155454377777653475679636D6C3059584967656D6C31636E52685A326C79615745674C5342445A584A3061575A705932466B6279426B5A53426A6158566B0A59575268626D3878517A424242674E564241734D4F6B4E76626D527059326C76626D567A4947526C4948567A6279426C62694233643363756158706C626E426C4C6D4E7662534275623278680A4947567959574A7062476B67616D46726158526C61323878467A415642674E56424334544469316B626D6B674F546B354F546B354F5442544D534977494159445651514444426C44535656450A51555242546B3867526B6C4456456C445355386751554E5553565A504D524977454159445651517144416C445356564551555242546B38784554415042674E564241514D43455A4A5131524A0A51306C504D524977454159445651514645776B354F546B354F546B354D464D77676745694D4130474353714753496233445145424151554141344942447741776767454B416F4942415143360A7371494E736872344A57544245474A4938345357664E43717735576E636D534C327044447A5A527A69395453575A4F524570584A61524F456D552B4F4C447362534B4233304B6463667065540A4A4833626467517A3762743872497231666F5869377A4F354738353230484A784359594E2F7537504133645A624437667743306C764A443948662B47783251553836747A6F354D4D7836576C0A6469624E32376F572B564A7848446A3334427765497A7764497A46617333315874764A3832497A4B592F456947376865516C45564A396339396C6F6945363458415A71317930716C4B7147460A2F76796C38734675594D64664B79534F57765A3673765259704539496D6249373669653443396536496A734A6A39305A6D4E454439534677633253764D7764344C42704A4A313479453935680A6357732F7235333437436841765A333172576B386947436C65366F647759315A3765444841674D424141476A67674F694D4949446E6A434278775944565230534249472F4D4947386868566F0A644852774F693876643364334C6D6C365A5735775A53356A6232324244326C755A6D39416158706C626E426C4C6D4E76626153426B5443426A6A46484D455547413155454367772B535670460A546C424649464D75515334674C53424453555967515441784D7A4D334D6A59774C564A4E5A584A6A4C6C5A7064473979615745745232467A64475670656942554D5441314E5342474E6A49670A557A6778517A424242674E5642416B4D4F6B46325A4745675A4756734945316C5A476C305A584A795957356C6279424664473979596D6C6B5A5745674D5451674C5341774D5441784D4342570A61585276636D6C684C5564686333526C61586F7744675944565230504151482F42415144416758674D423847413155644A5151594D425947434373474151554642774D4342676F72426745450A4159493343674D4D4D42304741315564446751574242537055694B30385242517865476439527057724D6C78693364673844416642674E5648534D4547444157674252762F2F304E3867786A0A44795A78585272676232566B5A6A68726B7A434341536B47413155644941534341534177676745634D4949424451594A4B7759424241487A4F5759474D49482F4D43554743437347415155460A4277494246686C6F644852774F693876643364334C6D6C365A5735775A53356A623230765933427A4D494856426767724267454642516343416A43427941794278554A6C636D316C5A5734670A6258566E595773675A5870685A335630656D567262794233643363756158706C626E426C4C6D4E7662534261615856796447466E61584A7059573467613239755A6D6C68626E5236595342700A656D467549474631636E4A6C64476C7249477476626E52795958523159534270636D467264584A796153346754476C746158526859326C76626D567A4947526C49476468636D467564476C680A6379426C62694233643363756158706C626E426C4C6D4E76625342446232357A645778305A53426C6243426A62323530636D463062794268626E526C6379426B5A53426A6232356D615746790A494756754947567349474E6C636E52705A6D6C6A595752764D416B4742775141692B7841415149774E5159494B77594242515548415145454B54416E4D4355474343734741515546427A41420A68686C6F644852774F69387662324E7A6347526C63793570656D567563475575593239744D49484542676772426745464251634241775342747A4342744441494267594541493547415145770A434159474241434F526745454D417347426751416A6B594241774942447A4238426759454149354741515577636A416B4668356F64485277637A6F764C33643364793570656D5675634755750A593239744C33426B6379396C62693854416B564F4D435157486D68306448427A4F693876643364334C6D6C365A5735775A53356A623230766347527A4C3256314C784D43525655774A4259650A6148523063484D364C793933643363756158706C626E426C4C6D4E76625339775A484D765A584D7645774A46557A4154426759454149354741515977435159484241434F52674547415441320A42674E56485238454C7A41744D4375674B61416E6869566F644852774F69387659334A735A47567A4C6D6C365A5735775A53356A62323076593264704C574A706269396A636D77794D4130470A435371475349623344514542437755414134494341514273776C584666316278395235316A4A7179476F3955496375586A6C34494F4B3759337041533266396147706D58324E4430554442540A4C72664B6336384F78736A5361376E7362337557643256356A5A556574474E30564950574B324167317A704366664D696B666E4263364C4C5A3967335A476369787764564235344A333750390A51624C68435A68734365416645646972736946366E385A465957574B43593666613436707441504157562F434751304D43374C7A5A36344E3948455251697463643432495545586D4B6944720A7641444A45657234526B416B496C4F534C6D37644E705656635163464B716B4D4857724673724D7A37622F765175473353696853394D507764347346557A7459634A58574D593566432B48430A4C52476A31712B4F6E4C637A52487262477A783032565531647549546278386977544F76655448536D6E444A78372B666E734B4A7971635674706130527947536571355951636A4A442F30690A536F7A39706A413541354B6E5A503338305743694B74574A35525338502B3972506358464B3751326266534156573450496159754B4F4E35595A2B37652B3776474F33326F45556A737A53480A6C412B6B68726C6744595254513864654D375146316A77563730445442496A63554F324A316E68342B543877315839386A577A4F3446445163784B4F45674C66645271446D656B792B6159330A61334D423150664252334D386D6633474B3277784F4C523032423234595069637868686E4B514B50385046425347322B3677485A6F664339753144423867647A504F454F67476575335670470A4E5A6D6E4E54366F6A5A2B414D6A666961734F55626C7846486838677239345775436639732B5A68322F322B377872306247703076526E686B6736644378514533505A6E543059426D7773590A446B674E58395A4357376131354955783959705939413D3D0A3C2F64733A5835303943657274696669636174653E0A3C2F64733A58353039446174613E0A3C64733A4B657956616C75653E0A3C64733A5253414B657956616C75653E0A3C64733A4D6F64756C75733E0A75724B69446249612B43566B7752426953504F456C6E7A5171734F5670334A6B693971517738325563347655306C6D546B524B5679576B54684A6C506A697737473069676439436E584836580A6B795239323359454D2B3237664B794B395836463475387A7552764F6474427963516D47446637757A774E335757772B333841744A6279512F52332F6873646B46504F7263364F54444D656C0A7058596D7A64753646766C5363527734392B416348694D3848534D7857724E3956376279664E694D796D507849687534586B4A524653665850665A6149684F75467747617463744B705371680A6866373870664C42626D44485879736B6A6C723265724C30574B5250534A6D794F2B6F6E754176587569493743592F64475A6A52412F556863484E6B727A4D4865437761535364654D6850650A5958467250362B642B4F776F514C32643961317050496867705875714863474E5765336778773D3D0A3C2F64733A4D6F64756C75733E0A3C64733A4578706F6E656E743E415141423C2F64733A4578706F6E656E743E0A3C2F64733A5253414B657956616C75653E0A3C2F64733A4B657956616C75653E0A3C2F64733A4B6579496E666F3E0A3C64733A4F626A6563743E3C78616465733A5175616C696679696E6750726F706572746965732049643D225369676E61747572652D313530343836353631333936342D5175616C696679696E6750726F7065727469657322205461726765743D22235369676E61747572652D313530343836353631333936342220786D6C6E733A64733D22687474703A2F2F7777772E77332E6F72672F323030302F30392F786D6C64736967232220786D6C6E733A78616465733D22687474703A2F2F7572692E657473692E6F72672F30313930332F76312E332E3223223E3C78616465733A556E7369676E656450726F706572746965732049643D225369676E61747572652D313530343836353631333936342D556E7369676E656450726F70657274696573223E3C78616465733A556E7369676E65645369676E617475726550726F706572746965733E3C78616465733A5369676E617475726554696D655374616D702049643D225369676E617475726554696D655374616D702D31353034383635363133393634223E3C78616465733A496E636C756465205552493D2223446F63756D656E745369676E617475726556616C75652D3135303438363536313339363422207265666572656E636564446174613D2266616C7365222F3E3C64733A43616E6F6E6963616C697A6174696F6E4D6574686F6420416C676F726974686D3D22687474703A2F2F7777772E77332E6F72672F54522F323030312F5245432D786D6C2D6331346E2D3230303130333135222F3E3C78616465733A456E63617073756C6174656454696D655374616D703E4D494147435371475349623344514548417143414D49494C75514942417A45504D413047435743475341466C41775143415155414D49475442677371686B69473977304243524142424B4342677753426744422B4167454242676B724267454541664D355A774D77487A41484267557244674D4347675155626278306B4E52666F556F6F42576F6D75596C53646F6B75466A384345424A2F71465632395A566957624A745458745430555159447A49774D5463774F5441344D5441784D7A4D7A576A4144416745424167674575394D4731527A42637145624D426B4743437347415155464277454442413077437A414A4267634541494758586745426F494948647A434342334D77676756626F414D4341514943454861754F576267756A366C5634696E49644B56423234774451594A4B6F5A496876634E4151454C425141775254454C4D416B474131554542684D4352564D784644415342674E5642416F4D43306C6152553551525342544C6B45754D53417748675944565151444442644A656D56756347557559323974494330675245565451564A535430784D547A4165467730784E6A41334D5455774F5441304D7A4E61467730794D5441334D5455774F5441304D7A4E614D475978437A414A42674E5642415954416B56544D525177456759445651514B4441744A576B564F55455567557935424C6A45594D4259474131554559517750566B465552564D74515441784D7A4D334D6A59774D5363774A51594456515144444235306332466B5A584D756158706C626E426C4C6D4E76625341744945524655304653556B394D54453877676749694D4130474353714753496233445145424151554141344943447741776767494B416F494341514336366A4F386431306A546E374A5041327348785A716374496941336176375A6E654E6D55434F654A31306637486557597735686C596D512B42655858427251577254776D4A48492B4178534B6B72546C7536537768686F6A73326A614366756764386557637771754248496246566F6C507243744E5549394C63564A56507144466B62694B5466765058666273366D4E6779445033794F4976634F4A64425058796B445A6E4E6274485A4446304A32776C7851313337306C3642497877796E6776506A64792F49423775744B395A7068706A5058643142356D754567646A6F6A2F623359545470716D4250436E58696D79513347475030616C4D71344C325330515838304775397632706C376D44576B47524C3344427671766E747365786C364F5A5A483965537A5A4D437177305855794D4E4E5755546263394F736B57353132626C61677655335079715A54347A48716454666D6D43316E32376475766E4A3068465A795A75582F3037414D6678323637506C794A336C4B36626569624E56702F5168334C74792F487762386B564E34494A2B773068354E50464C354944314366586E586A77757679317752576649347A3149736133536C445835737834684238642F4F6A36644A6F55594F615A30636A7672683258364D636461342B57394E70725557536F7755486C5341577A6142716D576D70514150354B4B4A654E4B314269696D345A454C484368343652643468597033467165324E585439335470765764364C4B6930344636494C5A656C357076694D73485277784D446F733256545A4E68312F797A324451623730744E50656F77656237504E79507241625966546D4C64736576733364756D527447635364455A4376655A6C39725A72746E753252344A7566624C73476B46612B7A314B6C53627946776150304B6B694C4D5057326E437A7577626851514944415141426F34494350444343416A677767624147413155644567534271444342705945506157356D62304270656D56756347557559323974704947524D49474F4D556377525159445651514B4444354A576B564F55455567557935424C69417449454E4A526942424D44457A4D7A63794E6A4174556B316C636D4D75566D6C3062334A705953314859584E305A576C36494651784D445531494559324D6942544F4446444D454547413155454351773651585A6B5953426B5A5777675457566B6158526C636E4A68626D56764945563062334A696157526C595341784E434174494441784D44457749465A7064473979615745745232467A64475670656A414F42674E56485138424166384542414D4342344177466759445652306C4151482F42417777436759494B7759424251554841776777485159445652304F4242594546466E754E4238555362576F4A70423978753034444D5553584A39484D42384741315564497751594D426141464C4F365A636639513858622F49665A39582F446E6A53622B32744E4D446F4743437347415155464277454C424334774C444171426767724267454642516377413459656148523063446F764C33527A5957526C63793570656D567563475575593239744F6A67774F544D764D49476D42674E5648534145675A3477675A7377675A67474353734741515142387A6C6E417A4342696A416C4267677242674546425163434152595A6148523063446F764C33643364793570656D567563475575593239744C324E77637A4268426767724267454642516343416A4256476C4E435A584A745A575675494731315A32467249475636595764316448706C61323867643364334C6D6C365A5735775A53356A6232306754476C746158526859326C76626D567A4947526C49476468636D467564476C686379426C62694233643363756158706C626E426C4C6D4E766254413242674E56485238454C7A41744D4375674B61416E6869566F644852774F69387659334A735A47567A4C6D6C365A5735775A53356A62323076593264704C574A7062693968636D77794D413047435371475349623344514542437755414134494341514143434C4C4964474B36767557426E386C6C5A612B314943766736704A64684B305374614E7832366135726B35774C5034693257752F304F43712B727852304B325434516C31547156524C507335336A475165446A7730497043316B524247754A734736734D464D753168447178327749502F4652564368666164385654572B3470306339725745455268507A7A67586D6D7A79685379714B734D6E5377444D70536A636C3263474653682F634D4D6B777A6B6174596E307556492B55696B774B362B4765654E5779795251457A4569366F516F587531306F672B4353556C356C5579503247475568435951696D6B7349755730306554563831376771497752656C76394D475A5843386D6261637932474D6E4E517133616F75354D544F4C507278357A49326A4A596D344B54554E6C6D7157436A317864432B376742306D67576B585A54616161494666705531596D4774466731473975426F616A38657A7A795A5351776D47365536764D5577424C306D4B35555A712F6E70726B4468514656377751556766654441634C442B53313178553858733233336244644A322B654C6C63393750577979756552797064477957552F714B5969586650554E64623646573935396D47323349634564753034334F51566364457479337842796647495676396F7961764E7A5845323269567777594E413738334A36456F31334B32733476486B6338564D326E6A4B6173634C327032324D5A3561656168496E33672B7368675668356E3568737559795633474D7854524945525770514B554632734A7069384F3750396D7A2B326137483159725247537055327A754534364B385844335A684C594E396334314B61575538787371724C4B5958656C3372503375335630623753503676646E63526F466F6838354C39477566367779634259415A68774A585341395756697266475447434135417767674F4D416745424D466B775254454C4D416B474131554542684D4352564D784644415342674E5642416F4D43306C6152553551525342544C6B45754D53417748675944565151444442644A656D56756347557559323974494330675245565451564A535430784D54774951647134355A75433650715658694B636830705548626A414E42676C67686B67425A514D4541674546414B4343415167774767594A4B6F5A496876634E41516B444D51304743797147534962334451454A454145454D42774743537147534962334451454A42544550467730784E7A41354D4467784D44457A4D7A4E614D43384743537147534962334451454A424445694243416D31546B7853556263466948506A5538616C7A3430315A317144484465626766326F654B3078373339485443426D67594C4B6F5A496876634E41516B514169387867596F7767596377675951776759454549466F35344F5837314F6C4C4A516968326979776E554A4474526763726A38396D4D2B47696C4F78696B6F464D463077536152484D455578437A414A42674E5642415954416B56544D525177456759445651514B4441744A576B564F55455567557935424C6A45674D42344741315545417777585358706C626E426C4C6D4E76625341744945524655304653556B394D54453843454861754F576267756A366C5634696E49644B56423234774451594A4B6F5A496876634E41514542425141456767494148745774526E3143722B2B45636A2B556F704453376D4856352F2B656D5272394B7A6D45524954786934346A55556F4A584464624448356F66665575487A315554737A53444661564F476A7A4D362B6470505659556D5933746D4B412B3541776A774B57436D7A3674686E6A33726139586749352B674F42484C6A4568364B6C666247312F7074437978764779673251652F6D4664483835774843436B657264707932526D7371654D683770506D3031487432736469677A7A4856745632562F682F65326C773162646E784331636F716744673163492F504766634F3048374E5A75583969415879656C6533654A2F356D4A4679503958494E6649752B4D5751326366684F514E39335844736A484F49724E4E52492B7454775961533938743948355649513954375A504C52787A466F3957333433527951517666494E42576A63625849366466786E4E6B552B58724A614E38524835446642305054353731714D68375456523762466978754F694E372F4A7157545875474730732B5A4E43416961766E50364A504C5270347645766A51354C4E36523045567466786B376F2B61316D466C7570494970543355697A6370424A574E6765694D2F4546735668453064456D4734695071584D76423443416D525670356A664C69384551714B723079464141326836476E593569516A7A4235433754386B5643676B336D57582B437964714C2B516D386D4743365339517A30506453597A344B454B37487A6F5935757541436C3449563969585752596C66674F5A735542663973427855432F336E59482F573373347572316B6363784375545957665A6747384A3176576C514A714B676E5736726266484D57724A70553136326C4A50674D4E386A5A6C6D7477707A5069746C516D72567A61674170545A48613276356C42773851387662676C6D3739696B4D73765530616F41414141413C2F78616465733A456E63617073756C6174656454696D655374616D703E3C2F78616465733A5369676E617475726554696D655374616D703E3C2F78616465733A556E7369676E65645369676E617475726550726F706572746965733E3C2F78616465733A556E7369676E656450726F706572746965733E3C78616465733A5369676E656450726F706572746965732049643D225369676E61747572652D313530343836353631333936342D5369676E656450726F70657274696573223E3C78616465733A5369676E65645369676E617475726550726F706572746965733E3C78616465733A5369676E696E6754696D653E323031372D30392D30385431303A31333A33332E3938315A3C2F78616465733A5369676E696E6754696D653E3C78616465733A5369676E696E6743657274696669636174653E3C78616465733A436572743E3C78616465733A436572744469676573743E3C64733A4469676573744D6574686F6420416C676F726974686D3D22687474703A2F2F7777772E77332E6F72672F323030302F30392F786D6C647369672373686131222F3E3C64733A44696765737456616C75653E62514F6A77735A3253623453554A6849357A4450793832555675513D3C2F64733A44696765737456616C75653E3C2F78616465733A436572744469676573743E3C78616465733A49737375657253657269616C3E3C64733A583530394973737565724E616D653E434E3D434120646520436975646164616E6F73207920456E7469646164657320283429202D204445534152524F4C4C4F2C4F553D4E5A5A205A697572746167697269207075626C696B6F61202D20436572746966696361646F207075626C69636F205343492C4F3D495A454E504520532E412E2C433D45533C2F64733A583530394973737565724E616D653E3C64733A5835303953657269616C4E756D6265723E343339373C2F64733A5835303953657269616C4E756D6265723E3C2F78616465733A49737375657253657269616C3E3C2F78616465733A436572743E3C2F78616465733A5369676E696E6743657274696669636174653E3C78616465733A5369676E6174757265506F6C6963794964656E7469666965723E3C78616465733A5369676E6174757265506F6C69637949643E3C78616465733A536967506F6C69637949643E3C78616465733A4964656E7469666965723E75726E3A656A67763A6473733A706F6C6963793A313C2F78616465733A4964656E7469666965723E3C78616465733A4465736372697074696F6E3E506F6C6974696361206465206669726D612064656C20476F626965726E6F20566173636F202D204575736B6F204A6175726C617269747A613C2F78616465733A4465736372697074696F6E3E3C2F78616465733A536967506F6C69637949643E3C78616465733A536967506F6C696379486173683E3C64733A4469676573744D6574686F6420416C676F726974686D3D22687474703A2F2F7777772E77332E6F72672F323030302F30392F786D6C647369672373686131222F3E3C64733A44696765737456616C75653E6A6F7249703162766D6749585342544D425969626A4842547342453D3C2F64733A44696765737456616C75653E3C2F78616465733A536967506F6C696379486173683E3C78616465733A536967506F6C6963795175616C6966696572733E3C78616465733A536967506F6C6963795175616C69666965723E3C78616465733A53505552493E68747470733A2F2F6575736B6164692E6575732F626F7076322F6461746F732F323031322F30372F31323033343734612E7064663C2F78616465733A53505552493E3C2F78616465733A536967506F6C6963795175616C69666965723E3C2F78616465733A536967506F6C6963795175616C6966696572733E3C2F78616465733A5369676E6174757265506F6C69637949643E3C2F78616465733A5369676E6174757265506F6C6963794964656E7469666965723E3C2F78616465733A5369676E65645369676E617475726550726F706572746965733E3C2F78616465733A5369676E656450726F706572746965733E3C2F78616465733A5175616C696679696E6750726F706572746965733E3C2F64733A4F626A6563743E0A3C2F64733A5369676E61747572653E3C2F703E0A3C2F6469763E0A3C646976207374796C653D22646973706C61793A206E6F6E653B223E0A3C69734964617A6B694465736B746F703E66616C73653C2F69734964617A6B694465736B746F703E0A3C2F6469763E0A2020202020203C7374796C6520747970653D22746578742F637373223E0A2F2A435353446F63756D656E742A2F6469762E7932325F686561646572526F77317B646973706C61793A6E6F6E653B7D0A0A2E6E7565766F7B636F6C6F723A233137373941453B7D0A2E6E7565766F31617B636F6C6F723A233939363633333B746578742D6465636F726174696F6E3A756E6465726C696E653B7D0A0A617B636F6C6F723A233137373941453B746578742D6465636F726174696F6E3A6E6F6E653B7D0A23746F6F6C6B6974446F632068317B70616464696E673A2031252031252031252031253B746578742D616C69676E3A63656E7465723B666F6E742D73697A653A203231707821696D706F7274616E743B6D617267696E3A30707821696D706F7274616E743B7D0A68317B636F6C6F723A233535353535353B7D0A23746F6F6C6B6974446F632068327B6D617267696E2D746F703A37707821696D706F7274616E743B206D617267696E2D626F74746F6D3A37707821696D706F7274616E743B6261636B67726F756E642D636F6C6F723A2365366536653621696D706F7274616E743B20636F6C6F723A2335353535353521696D706F7274616E743B666F6E742D7765696768743A20626F6C6421696D706F7274616E743B77696474683A696E68657269743B666F6E742D73697A653A203132707821696D706F7274616E743B70616464696E673A20302E332520302520302E332520302E33253B206D617267696E2D6C6566743A30707821696D706F7274616E743B20626F726465723A2031707820736F6C696420236433643364333B666F6E742D66616D696C793A2056657264616E612C417269616C2C73616E732D736572696621696D706F7274616E743B746578742D736861646F773A206E6F6E6521696D706F7274616E743B7D0A2E75692D7769646765742D636F6E74656E742023746F6F6C6B6974446F63206831207B646973706C61793A6E6F6E6521696D706F7274616E743B7D0A23746F6F6C6B6974446F637B666F6E742D66616D696C793A56657264616E612C20417269616C21696D706F7274616E743B6261636B67726F756E642D706F736974696F6E3A20626F74746F6D2072696768743B666F6E742D73697A653A203132707821696D706F7274616E743B646973706C61793A20626C6F636B3B626F726465722D6C6566743A31707820736F6C696420234343434343433B206D617267696E2D6C6566743A35253B6D617267696E2D72696768743A35253B626F726465722D72696768743A31707820736F6C696420234343434343433B2020626F726465722D626F74746F6D3A31707820736F6C696420234343434343433B626F726465722D746F703A31707820736F6C696420234343434343433B6261636B67726F756E642D636F6C6F723A234634463446343B7D0A2E75692D7769646765742D636F6E74656E742023746F6F6C6B6974446F637B6D617267696E2D6C6566743A30253B6D617267696E2D72696768743A30253B7D0A23746F6F6C6B6974446F63202E6574697175657461466F726D756C6172696F317B666F6E742D7765696768743A626F6C643B6D617267696E2D6C6566743A3070783B7D0A23746F6F6C6B6974446F63202E73616C746F4C696E6561526164696F7B766572746963616C2D616C69676E3A746F703B7D0A23746F6F6C6B6974446F63202E6574697175657461466F726D756C6172696F327B70616464696E673A30253425302530253B666F6E742D7765696768743A6E6F726D616C3B77686974652D73706163653A207072652D777261703B776F72642D777261703A20627265616B2D776F72643B776F72642D627265616B3A20627265616B2D616C6C3B7D0A23746F6F6C6B6974446F6320236465636C61726163696F6E6573526573706F6E7361626C6573202E6574697175657461466F726D756C6172696F327B70616464696E673A30253025302530252021696D706F7274616E743B666F6E742D7765696768743A6E6F726D616C3B77686974652D73706163653A207072652D777261703B776F72642D777261703A20627265616B2D776F72643B776F72642D627265616B3A20627265616B2D616C6C3B7D0A0A23746F6F6C6B6974446F63202E6C6162656C4465526164696F7B6D617267696E3A30707821696D706F7274616E743B70616464696E673A30707821696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E202E73696E53616C746F207370616E7B6D617267696E2D72696774683A3021696D706F7274616E743B7D0A0A2E66696C6156616369617B646973706C61793A6E6F6E653B7D0A2E66696C6156616369617B646973706C61793A6E6F6E653B7D0A23746F6F6C6B6974446F63207461626C657B666F6E742D66616D696C793A56657264616E612C20417269616C21696D706F7274616E743B77696474683A6175746F3B206D617267696E2D72696768743A312521696D706F7274616E743B746578742D616C69676E3A63656E7465723B666F6E742D73697A653A3132707821696D706F7274616E743B7D0A23746F6F6C6B6974446F63207461626C65207468656164202E6574697175657461466F726D756C6172696F317B6D617267696E2D6C6566743A696E68657269743B77696474683A6175746F3B2070616464696E672D626F74746F6D3A31253B6D617267696E2D72696768743A312521696D706F7274616E743B6261636B67726F756E642D636F6C6F723A234343433B70616464696E673A313070782031307078203130707820313070783B7D0A23746F6F6C6B6974446F6320236461746F73417669736F207461626C65207468656164202E6574697175657461466F726D756C6172696F317B77696474683A34302521696D706F7274616E743B77686974652D73706163653A6E6F777261703B7D0A23746F6F6C6B6974446F6320236461746F73417669736F207461626C65207464202E6574697175657461466F726D756C6172696F317B77696474683A34302521696D706F7274616E743B7D0A0A23746F6F6C6B6974446F6320696E7075747B6D617267696E2D6C6566743A696E68657269743B7D0A23746F6F6C6B6974446F63207370616E7B6D617267696E2D72696768743A31253B20646973706C61793A20696E6C696E652D626C6F636B3B7D0A23746F6F6C6B6974446F63207461626C652074647B6D617267696E2D6C6566743A696E68657269743B77696474683A6175746F21696D706F7274616E743B20206D617267696E2D72696768743A30253B7D0A23746F6F6C6B6974446F63207461626C652074722074642E7769647468313070657263656E74207B77696474683A203130257C696D706F7274616E743B7D0A23746F6F6C6B6974446F63207461626C652074722074642E7769647468393070657263656E74207B77696474683A203930257C696D706F7274616E743B7D0A0A23746F6F6C6B6974446F632074642E6D696E77696474683570657263656E74207B6D696E2D77696474683A35253B7D0A23746F6F6C6B6974446F6320707B666F6E742D73697A653A696E68657269743B646973706C61793A20626C6F636B21696D706F7274616E743B20666F6E742D7765696768743A6E6F726D616C3B206D617267696E2D6C6566743A3070783B6D617267696E2D626F74746F6D3A31253B6D617267696E2D746F703A30707821696D706F7274616E743B70616464696E673A2030707821696D706F7274616E743B7D0A23746F6F6C6B6974446F6320697B666F6E742D7765696768743A6E6F726D616C3B646973706C61793A20696E6C696E652D626C6F636B3B6D617267696E2D6C6566743A30707821696D706F7274616E743B7D0A2E666C656368617B636F6C6F723A233137373941453B7D0A2E4572726F727B666F6E742D73697A653A313230253B636F6C6F723A7265643B7D0A2E4572726F72317B666F6E742D73697A653A3635253B766572746963616C2D616C69676E3A746F703B666F6E742D66616D696C793A56657264616E612C20417269616C21696D706F7274616E743B636F6C6F723A7265643B666F6E742D7765696768743A626F6C643B7D0A62727B626F726465722D626F74746F6D3A317078736F6C6964234343434343433B626F726465722D72696768743A307078736F6C6964233030303030303B626F726465722D6C6566743A307078736F6C6964233030303030303B626F726465722D746F703A307078736F6C6964233030303030303B7D0A23746F6F6C6B6974446F63756D656E746F737B746578742D616C69676E3A6C6566743B666F6E742D66616D696C793A56657264616E612C20417269616C21696D706F7274616E743B626F726465722D6C6566743A317078736F6C6964233030303030303B626F726465722D72696768743A317078736F6C6964233030303030303B626F726465722D626F74746F6D3A317078736F6C6964233030303030303B7D0A23746F6F6C6B6974446F63756D656E746F73206C697B6D617267696E2D746F703A2D31253B6D617267696E2D626F74746F6D3A302E38253B70616464696E673A302E33253025302E332531253B7D0A0A2E746578746F4C6567616C7B666F6E743A38302556657264616E612C417269616C2C73616E732D73657269663B77696474683A696E68657269743B7D0A236461746F7363686F6963654E6F74696669636163696F6E7B6D617267696E2D6C6566743A696E68657269743B7D0A202E7834336B477275706F43686F696365537562456C656D656E74737B70616464696E672D746F703A313070783B7D0A202E7834336B477275706F43686F6963654F7074696F6E737B70616464696E672D746F703A313070783B20666F6E743A56657264616E612C417269616C2C73616E732D73657269667D0A0A23646F63756D656E746F7341706F727461646F732E746F6F6C6B6974446F63756D656E746F732074687B746578742D616C69676E3A63656E7465723B6D617267696E2D6C6566743A696E68657269743B77696474683A6175746F3B2070616464696E672D626F74746F6D3A31253B6D617267696E2D72696768743A312521696D706F7274616E743B6261636B67726F756E642D636F6C6F723A234343433B70616464696E673A313070782031307078203130707820313070783B7D0A23646F63756D656E746F7341706F727461646F732E746F6F6C6B6974446F63756D656E746F732074647B6D617267696E2D6C6566743A696E68657269743B77696474683A6175746F3B70616464696E672D626F74746F6D3A2030707821696D706F7274616E743B6D617267696E2D72696768743A312521696D706F7274616E743B70616464696E673A35707820313070782035707820313070783B776F72642D627265616B3A627265616B2D616C6C3B7D0A23646F63756D656E746F73456E7472656761646F732E746F6F6C6B6974446F63756D656E746F732074687B746578742D616C69676E3A63656E7465723B6D617267696E2D6C6566743A696E68657269743B77696474683A6175746F3B2070616464696E672D626F74746F6D3A31253B6D617267696E2D72696768743A312521696D706F7274616E743B6261636B67726F756E642D636F6C6F723A234343433B70616464696E673A313070782031307078203130707820313070783B7D0A23646F63756D656E746F73456E7472656761646F732E746F6F6C6B6974446F63756D656E746F732074647B6D617267696E2D6C6566743A696E68657269743B77696474683A6175746F3B70616464696E672D626F74746F6D3A2030707821696D706F7274616E743B6D617267696E2D72696768743A312521696D706F7274616E743B70616464696E673A35707820313070782035707820313070783B776F72642D627265616B3A627265616B2D616C6C3B7D0A23746F6F6C6B6974446F63202E73616C746F207B6865696768743A2033707821696D706F7274616E743B6C696E652D6865696768743A20303B666F6E742D73697A653A20303B7D0A23746F6F6C6B6974446F63202E7834336B536570617261746F727B646973706C61793A6E6F6E653B7D0A23746F6F6C6B6974446F63202E7834336B456E756D65726163696F6E202E6574697175657461466F726D756C6172696F317B6D617267696E2D626F74746F6D3A30707821696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E7834336B456E756D65726163696F6E202E6574697175657461466F726D756C6172696F327B6D617267696E2D626F74746F6D3A30707821696D706F7274616E743B77686974652D73706163653A207072652D777261703B776F72642D777261703A20627265616B2D776F72643B776F72642D627265616B3A20627265616B2D616C6C3B7D0A23746F6F6C6B6974446F63202E7834336B456E756D65726163696F6E7B6D617267696E2D6C6566743A3021696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E7834336B456E756D65726163696F6E20756C207B6D617267696E2D6C6566743A203021696D706F7274616E743B2070616464696E672D6C6566743A20322521696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E7834336B456E756D65726163696F6E20707B6D617267696E2D746F703A312521696D706F7274616E743B7D0A23746F6F6C6B6974446F6320236461746F73417669736F207461626C65207B77696474683A3235253B7D0A2E746F6F6C6B6974436F6E73656E74696D69656E746F73207461626C65207B746578742D616C69676E3A6C65667421696D706F7274616E743B7D0A2E746F6F6C6B6974446F63756D656E746F73207461626C65207B746578742D616C69676E3A6C65667421696D706F7274616E743B77696474683A6175746F3B7D0A2E746F6F6C6B6974436F6E73656E74696D69656E746F732074647B6D617267696E2D6C6566743A31253B776F72642D627265616B3A627265616B2D616C6C3B7D0A0A236465636C61726163696F6E6573526573706F6E7361626C6573202E6574697175657461466F726D756C6172696F317B666F6E742D7765696768743A6E6F726D616C21696D706F7274616E743B7D0A23746F6F6C6B6974446F6320236465636C61726163696F6E6573526573706F6E7361626C6573206469767B6D617267696E3A30707821696D706F7274616E743B7D0A23746F6F6C6B6974446F6320236465636C61726163696F6E496E736372697063696F6E206469767B646973706C61793A20696E6C696E652D626C6F636B21696D706F7274616E743B202A646973706C61793A696E6C696E6521696D706F7274616E743B2077686974652D73706163653A6E6F777261703B202A77696474683A3330253B7D0A237834336B5F6C697374615F4465636C61726163696F6E526567697374726F50616973566173636F207370616E207B6D617267696E2D626F74746F6D3A3570783B7D0A237834336B5F6C6162656C5F4465636C61726163696F6E4C69737461526567697374726F207370616E7B6D617267696E2D626F74746F6D3A3570783B206D617267696E2D6C6566743A3570787D0A23746F6F6C6B6974446F6320236465636C61726163696F6E496E736372697063696F6E202E6574697175657461466F726D756C6172696F327B2A70616464696E672D626F74746F6D3A35707821696D706F7274616E743B2A70616464696E672D72696768743A35707821696D706F7274616E743B2A70616464696E672D6C6566743A3021696D706F7274616E743B77686974652D73706163653A207072652D777261703B776F72642D777261703A20627265616B2D776F72643B776F72642D627265616B3A20627265616B2D616C6C3B7D0A23746F6F6C6B6974446F6320236465636C61726163696F6E496E736372697063696F6E202E6574697175657461466F726D756C6172696F317B2A70616464696E672D626F74746F6D3A35707821696D706F7274616E743B7D0A0A237834336B5F636865636B5F6465636C61726163696F6E5F696E736372697063696F6E207370616E207B77696474683A3130302521696D706F7274616E747D0A237834336B5F6C6162656C5F4465636C61726163696F6E4C69737461526567697374726F207370616E207B6D617267696E2D72696768743A302521696D706F7274616E743B7D0A0A23746F6F6C6B6974446F63202E746F6F6C6B69744E31207072696D6572456C656D656E746F206469767B70616464696E673A3070783B666F6E742D73697A653A20696E68657269743B6D617267696E2D6C6566743A31253B646973706C61793A626C6F636B3B6D617267696E2D746F703A30707821696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E31202E746F6F6C6B69744E207B6D617267696E2D6C6566743A30707821696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E31202E746F6F6C6B69744E3220646976207B70616464696E673A3070783B666F6E742D73697A653A20696E68657269743B6D617267696E2D6C6566743A322521696D706F7274616E743B646973706C61793A626C6F636B3B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E31202E746F6F6C6B69744E32202E746F6F6C6B69744E207B6D617267696E2D6C6566743A30707821696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E31202E746F6F6C6B69744E32202E746F6F6C6B69744E206469767B6D617267696E2D6C6566743A203070783B7D0A0A23746F6F6C6B6974446F63202E746F6F6C6B69744E31202E746F6F6C6B69744E32202E746F6F6C6B69744E202E7834336B456E756D65726163696F6E207B6D617267696E2D6C6566743A30707821696D706F7274616E743B206D617267696E2D626F74746F6D3A31253B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E32206469767B70616464696E673A3070783B666F6E742D73697A653A20696E68657269743B6D617267696E2D6C6566743A322521696D706F7274616E743B646973706C61793A626C6F636B3B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E32202E746F6F6C6B69744E207B6D617267696E2D6C6566743A30707821696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E32202E746F6F6C6B69744E206C69206469767B6D617267696E2D6C6566743A30707821696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E32202E746F6F6C6B69744E2020756C206469767B6D617267696E2D6C6566743A30707821696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E32202E746F6F6C6B69744E202E646976456E4C696E65617B6D617267696E2D6C6566743A30707821696D706F7274616E743B646973706C61793A696E6C696E653B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E31202E746F6F6C6B69744E32202E746F6F6C6B69744E202E646976456E4C696E656120646976207B6D617267696E2D6C6566743A2030707821696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E32202E746F6F6C6B69744E202E646976456E4C696E6561426F7264654465726563686F7B6D617267696E2D6C6566743A30707821696D706F7274616E743B646973706C61793A696E6C696E653B626F726465722D72696768743A317078736F6C6964234343434343433B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E33207B666F6E742D73697A653A20696E68657269743B6D617267696E2D6C6566743A332521696D706F7274616E743B646973706C61793A626C6F636B3B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E33202E746F6F6C6B69744E207B6D617267696E2D6C6566743A30707821696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E33202E746F6F6C6B69744E206469767B70616464696E673A3070783B666F6E742D73697A653A20696E68657269743B6D617267696E2D6C6566743A332521696D706F7274616E743B646973706C61793A626C6F636B3B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E33206469767B666F6E742D73697A653A20696E68657269743B6D617267696E2D6C6566743A332521696D706F7274616E743B646973706C61793A626C6F636B3B7D0A23746F6F6C6B6974446F63202E746F6F6C6B6974446F63756D656E746F737B6D617267696E2D6C6566743A312521696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E746F6F6C6B6974436F6E73656E74696D69656E746F737B6D617267696E2D6C6566743A312521696D706F7274616E743B776F72642D627265616B3A627265616B2D616C6C3B7D0A23746F6F6C6B6974446F6320236669726D61646F506F727B6D617267696E2D6C6566743A312521696D706F7274616E743B7D20200A0A23746F6F6C6B6974446F63202E746F6F6C6B69744E31202E746F6F6C6B69744E32202E746F6F6C6B69744E202E6669656C647365747B6D617267696E2D6C6566743A30707821696D706F7274616E743B7D0A23746F6F6C6B6974446F6320646976207B70616464696E672D6C6566743A31253B2070616464696E672D72696768743A31253B7D0A23746F6F6C6B6974446F63206669656C6473657420207B6D617267696E2D6C6566743A30707821696D706F7274616E743B626F726465723A303B7D0A2E7834336B4E6F426F726465727B626F726465723A3070783B7D0A23746F6F6C6B6974446F63202E746F6F6C6B69744E32202E746F6F6C6B69744E202E7834336B477275706F43686F6963652020646976207B6D617267696E2D6C6566743A30707821696D706F7274616E743B7D0A23636F6C6D756E56693A6166746572207B636F6E74656E743A275C3237313420273B20636F6C6F723A233466623065377D0A23636F6C6D756E56694E6F744175743A6166746572207B636F6E74656E743A275C3237313620273B20636F6C6F723A233466623065377D0A0A23636F6C6D756E4172726F7752696768743A6166746572207B636F6E74656E743A275C3235423820273B20636F6C6F723A233466623065377D0A0A23746F6F6C6B6974446F63207370616E202E73696E53616C746F207B6D617267696E2D72696768743A203130707821696D706F7274616E743B7D0A0A23746F6F6C6B6974446F63202E746578746F56616C6F7246696A6F526164696F7B77696474683A20313030253B626F726465723A3170783B6D617267696E2D6C6566743A3232707821696D706F7274616E743B6D617267696E2D72696774683A3570783B6D617267696E2D626F74746F6D3A3570783B6D617267696E2D746F703A3570783B646973706C61793A696E6C696E652D626C6F636B3B666C6F61743A6E6F6E6521696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E696E70757456616C6F7246696A6F526164696F207B706F736974696F6E3A6162736F6C7574653B7D0A0A0A23746F6F6C6B6974446F63202E746578746F56616C6F7246696A6F436865636B7B77696474683A20313030253B626F726465723A3170783B6D617267696E2D6C6566743A3232707821696D706F7274616E743B6D617267696E2D72696774683A3570783B6D617267696E2D626F74746F6D3A3570783B6D617267696E2D746F703A3570783B646973706C61793A696E6C696E652D626C6F636B3B666C6F61743A6E6F6E6521696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E7834336B5F636865636B5F6465636C61726163696F6E5F696E736372697063696F6E7B77696474683A20313030253B626F726465723A3170783B6D617267696E2D6C6566743A3232707821696D706F7274616E743B6D617267696E2D72696774683A3570783B6D617267696E2D626F74746F6D3A3570783B6D617267696E2D746F703A3570783B646973706C61793A696E6C696E652D626C6F636B3B666C6F61743A6E6F6E6521696D706F7274616E743B7D0A23746F6F6C6B6974446F63202E696E70757456616C6F7246696A6F436865636B207B706F736974696F6E3A6162736F6C7574653B7D0A23746F6F6C6B6974446F63202E6574697175657461436865636B207B646973706C61793A626C6F636B3B7D0A23746F6F6C6B6974446F63202E7834336B5F636865636B5F6465636C61726163696F6E5F696E736372697063696F6E5F696E707574207B646973706C61793A626C6F636B3B7D0A0A23746F6F6C6B6974446F63202E73616C746F456C656D656E746F207B646973706C61793A626C6F636B3B7D0A0A23746F6F6C6B6974446F63202E73616C746F4C696E6561526164696F207B646973706C61793A696E6C696E652D626C6F636B3B77696474683A6175746F3B6D617267696E2D6C6566743A3070783B7D0A0A7D0A2020202020203C2F7374796C653E0A2020203C2F686561643E0A2020203C626F64793E0A2020203C6469762069643D22746F6F6C6B6974446F63223E0A2020202020203C68313E496E73637269706369C3B36E20656E20656C20726567697374726F206465206D65646961646F7265732064652073656775726F733C2F68313E0A202020202020202020093C64697620636C6173733D22746F6F6C6B69744E31207072696D6572456C656D656E746F223E0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D226461746F734F7267616E6F476573746F72223E0A0A093C68323E412028C3B37267616E6F20676573746F72293A3C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D226D616E6167696E67556E69744E616D65223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223EC2A03C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E44495245434349C3934E20444520504F4CC38D544943412046494E414E43494552412059205245435552534F5320494E535449545543494F4E414C45533C2F7370616E3E0A093C2F6C6162656C3E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D226461746F73506572736F6E616C6573223E0A0A093C68323E4461746F7320706572736F6E616C65733C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A3C64697620636C6173733D22646976456E4C696E6561222069643D22686F6C646572314E616D65223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E4E6F6D627265206465206C6120656E74696461643A3C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E454E544944414420464943544943494F2041435449564F3C2F7370616E3E0A093C2F6C6162656C3E0A093C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561222069643D22617669736F444E495F746974756C6172223E0A093C6C6162656C3E0A09093C693E456C206E6F6D627265206465206C6120656E7469646164206465626520636F696E6369646972206578616374616D656E746520636F6E206C612064656E6F6D696E616369C3B36E20717565206170617265636520656E206C61207461726A657461204349463C2F693E0A093C2F6C6162656C3E0A093C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D22686F6C646572315469706F446E69223E0A093C6C6162656C3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E446F63756D656E746F206465206964656E7469666963616369C3B36E3A203C2F7370616E3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E4349463C2F7370616E3E09090A093C2F6C6162656C3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D22686F6C64657231446E69223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E4EC3BA6D65726F3A3C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E4A373130323537324A3C2F7370616E3E0A093C2F6C6162656C3E0A3C2F6469763E0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3320636F6E4C6162656C222069643D226461746F73726570726573656E74617469766531223E0A0A093C68323E526570726573656E74616E74653C2F68323E093C64697620636C6173733D22746F6F6C6B69744E223E0A0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D22726570726573656E746174697665315469706F446E69223E0A093C6C6162656C3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E446F63756D656E746F206465206964656E7469666963616369C3B36E3A3C2F7370616E3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E444E493C2F7370616E3E09090A093C2F6C6162656C3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561222069643D22726570726573656E74617469766531446E69223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E4EC3BA6D65726F3A3C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E3939393939393930533C2F7370616E3E0A093C2F6C6162656C3E0A093C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561222069643D22726570726573656E746174697665314E616D65223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E4E6F6D6272653A3C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E434955444144414E4F3C2F7370616E3E0A093C2F6C6162656C3E0A093C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D22726570726573656E7461746976653141706531223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E5072696D6572206170656C6C69646F3A3C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E464943544943494F3C2F7370616E3E0A093C2F6C6162656C3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561222069643D22726570726573656E7461746976653141706532223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E536567756E646F206170656C6C69646F3A3C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E41435449564F3C2F7370616E3E0A093C2F6C6162656C3E0A093C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D226461746F734E6F74696669636163696F6E223E0A0A093C68323E43616E616C206465206E6F7469666963616369C3B36E207920636F6D756E6963616369C3B36E3C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A3C703E456C65637472C3B36E69636F3A20536520656E76C3AD616E2061206C612062616E64656A61206465206E6F74696669636163696F6E6573207920636F6D756E69636163696F6E6573206465203C6120687265663D2268747470733A2F2F6575736B6164692E6575732F6D697367657374696F6E657322207461726765743D225F626C616E6B223E4D69732067657374696F6E65733C2F613E2E205061726120616363656465722C206573206E656365736172696F20756E203C6120687265663D2268747470733A2F2F6575736B6164692E6575732F7932322D6564756B692F65732F636F6E74656E69646F732F696E666F726D6163696F6E2F65676F69747A615F6E6972655F67657374696F616B5F6C6167756E747A612F65735F65676F69747A612F723031685265646972656374436F6E742F636F6E74656E69646F732F696E666F726D6163696F6E2F636572746966696361646F735F61646D697469646F732F65735F636572745F656C652F636572746966696361646F735F656C656374726F6E69636F732E68746D6C22207461726765743D225F626C616E6B223E6D6564696F206465206964656E7469666963616369C3B36E20656C65637472C3B36E69636F3C2F613E2E203C62722F3E203C7370616E207374796C653D22666F6E742D73697A653A20302E3835656D3B636F6C6F723A20234230423042303B223E20204E6F74613A20536920656E2031302064C3AD6173206E61747572616C6573207573746564206E6F20616363656465206120756E61206E6F7469666963616369C3B36E20656C65637472C3B36E6963612C20736520656E74656E646572C3A120717565206C612068612072656368617A61646F3B20656C207472C3A16D69746520736520646172C3A120706F72207265616C697A61646F2079206C612061646D696E69737472616369C3B36E20736567756972C3A1206164656C616E746520636F6E20656C2070726F636564696D69656E746F2E3C2F7370616E3E3C62722F3E3C62722F3E3C2F703E0A3C2F6469763E0A3C2F6469763E0A0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D226461746F73417669736F223E0A0A093C68323E4461746F732070617261207265636962697220617669736F733C2F68323E093C64697620636C6173733D22746F6F6C6B69744E223E0A0A3C64697620636C6173733D22222069643D22726164696F456C656769724461746F73417669736F223E0A0A093C6C6162656C20636C6173733D226C6162656C4465526164696F223E0A090A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E282A2920C2BF4465736561207574696C697A617220656C2073697374656D6120646520617669736F732070726576696F7320706F7220636F7272656F20656C65637472C3B36E69636F206F20534D533F3C62722F3E3C62722F3E3C2F7370616E3E0A0909093C7370616E20636C6173733D2273616C746F4C696E6561526164696F223E0A09090A0909090909093C7370616E20636C6173733D2273616C746F456C656D656E746F223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F526164696F222064697361626C65643D2264697361626C65642220747970653D22726164696F222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F526164696F223E3C623E4E6F3C2F623E3A204E6F2072656369626972C3A1206E696E67C3BA6E20617669736F206375616E646F207365206C6520656E76C3AD6520756E61206E6F7469666963616369C3B36E206F20636F6D756E6963616369C3B36E2028656C65637472C3B36E696361206F20706F7374616C293C2F7370616E3E3C2F7370616E3E3C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A0909090909093C2F7370616E3E0A0909093C2F6C6162656C3E0A090A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D226461746F734964696F6D61223E0A0A093C68323E4964696F6D61206465206C6173206E6F74696669636163696F6E65732C20636F6D756E69636163696F6E6573207920617669736F733C2F68323E093C64697620636C6173733D22746F6F6C6B69744E223E0A0A3C64697620636C6173733D22646976456E4C696E6561222069643D226461746F7363686F6963654964696F6D61223E0A09093C7370616E20636C6173733D2273616C746F4C696E6561526164696F223E0A09090A090909090909093C7370616E20636C6173733D2273696E53616C746F223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F526164696F222064697361626C65643D2264697361626C65642220747970653D22726164696F222076616C75653D224553222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F526164696F223E43617374656C6C616E6F3C2F7370616E3E3C2F7370616E3E0A09090909093C2F7370616E3E0A09090A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A0A093C2F6469763E0A093C64697620636C6173733D22746F6F6C6B69744E31223E0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D226465636C61726163696F6E416D6269746F5465727269746F7269616C223E0A0A093C68323EC3816D6269746F207465727269746F7269616C2064652061637475616369C3B36E3C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A3C703E456E20766972747564206465206C612064697374726962756369C3B36E20646520636F6D706574656E6369617320656E747265206C612041646D696E69737472616369C3B36E2047656E6572616C2064656C2045737461646F2079206C617320436F6D756E69646164657320417574C3B36E6F6D61732065737461626C656369646120656E20656C20617274C3AD63756C6F203437206465206C61204C65792032362F323030362C206465203137206465206A756C696F2C206465206D656469616369C3B36E2064652073656775726F7320792072656173656775726F73207072697661646F733A3C2F703E0A0A2020202020202020202020202020202020202020203C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D22616D6269746F223E0A2020202020202020202020202020202020200A2020202020202020202020203C6469763E0A202020202020202020202020202020202020202020202020202020202020092020202020202020202020202020200920203C7370616E20636C6173733D226574697175657461436865636B223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F436865636B222064697361626C65643D2264697361626C65642220747970653D22636865636B626F78222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F436865636B223E2A204465636C6172612071756520656C20C3A16D6269746F206465206F7065726163696F6E657320656E20656C20717565207661206120656A65726365722073752061637469766964616420636F6D6F206D65646961646F722064652073656775726F73203C623E205345204C494D49544120616C20C3A16D6269746F207465727269746F7269616C206465206C6120436F6D756E6964616420417574C3B36E6F6D612064656C205061C3AD7320566173636F3C2F623E2E3C2F7370616E3E3C2F7370616E3E0A20202020202020202020202020202009202020202020202020202020202020202020202020202020093C2F6469763E0A2020202020202020202020202020203C2F6469763E0A2020200A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D22617669736F76696E63756C6F7332223E0A093C6C6162656C3E0A09093C693E4E4F54413A20457820617274C3AD63756C6F2034372E2033206465206C61204C65792032362F323030362C206C6120636F6D706574656E636961206465206C612041646D696E69737472616369C3B36E206465206C6120436F6D756E6964616420417574C3B36E6F6D612064656C205061C3AD7320566173636F20657374C3A12064656C696D697461646120706F72206C6120636F6E63757272656E636961206465206C6F732070756E746F7320646520636F6E657869C3B36E20646F6D6963696C696F20736F6369616C207920C3A16D6269746F206465206F7065726163696F6E657320656E20656C207465727269746F72696F206465206C6120436F6D756E6964616420417574C3B36E6F6D612E204375616E646F206573746F73206E6F2073652064616E2C20706F727175652073652065787469656E646520656C20C3A16D6269746F206465206F7065726163696F6E65732061206DC3A17320646520756E6120436F6D756E6964616420417574C3B36E6F6D612C20656C206D65646961646F72206465626520696E73637269626972736520656E20656C20526567697374726F206465204D65646961646F7265732064652053656775726F73206465206C612044697265636369C3B36E2047656E6572616C2064652053656775726F732E20506F72206661766F722C204E4F20434F4E54494EC39A4520636F6E206C6120736F6C6963697475642E3C2F693E0A093C2F6C6162656C3E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D22477275706F7469706F6D65646961646F72223E0A0A093C68323E5469706F206465206D65646961646F723A3C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A3C64697620636C6173733D22646976456E4C696E6561222069643D224C697374617469706F4D65646961646F72223E0A093C6C6162656C3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E5469706F206465206D65646961646F723C2F7370616E3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E436F727265646F722064652073656775726F733C2F7370616E3E09090A093C2F6C6162656C3E0A093C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D22646972656363696F6E416374697669646164223E0A0A093C68323E446F6D6963696C696F206163746976696461643C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D226C6973746150726F76696E636961223E0A093C6C6162656C3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E5465727269746F72696F2048697374C3B37269636F3A3C2F7370616E3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E42697A6B6169613C2F7370616E3E09090A093C2F6C6162656C3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561222069643D226C697374614D756E69636970696F223E0A093C6C6162656C3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E4D756E69636970696F3A3C2F7370616E3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E42696C62616F3C2F7370616E3E09090A093C2F6C6162656C3E0A093C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D2243616D706F42617369636F43616C6C65223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E44697265636369C3B36E3A3C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E414D3C2F7370616E3E0A093C2F6C6162656C3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D2243616D706F42617369636F506F7274616C223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E4EC2BA3A3C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E31383C2F7370616E3E0A093C2F6C6162656C3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D2243616D706F42617369636F5069736F223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E5069736F3A3C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E323C2F7370616E3E0A093C2F6C6162656C3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D2243616D706F42617369636F4C65747261223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E4C657472613A3C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E413C2F7370616E3E0A093C2F6C6162656C3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561222069643D2243616D706F42617369636F4370223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E43C3B36469676F20706F7374616C3A3C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E34383030393C2F7370616E3E0A093C2F6C6162656C3E0A093C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D22617474636C69656E7465223E0A0A093C68323E536572766963696F206465206174656E6369C3B36E20616C20636C69656E74653C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D226174656E63696F6E636C69656E7465223E0A0A093C6C6162656C20636C6173733D226C6162656C4465526164696F223E0A090A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223EC2BF536520656E6375656E74726120616468657269646F20616C20736572766963696F206465206174656E6369C3B36E20616C20636C69656E74652064656C20636F6C6567696F206465206D65646961646F7265732064652073656775726F733F3C2F7370616E3E0A0909093C7370616E20636C6173733D2273616C746F4C696E6561526164696F223E0A09090A0909090909093C7370616E20636C6173733D2273616C746F456C656D656E746F223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F526164696F222064697361626C65643D2264697361626C65642220747970653D22726164696F222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F526164696F223E53C3AD2C206D6520656E6375656E74726F20616468657269646F20616C20736572766963696F206465206174656E6369C3B36E20616C20636C69656E74652064656C203C623E436F6E73656A6F20566173636F3C2F623E206465204D65646961646F7265732064652053656775726F733C2F7370616E3E3C2F7370616E3E3C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A090909090909093C2F7370616E3E0A0909093C2F6C6162656C3E0A090A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A0A0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D22636170616369646164223E0A0A093C68323E4361706163696461642066696E616E63696572613C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D22617669736F6465636C61726F32223E0A093C6C6162656C3E0A09093C693E446562652061706F7274617220656E20656C207061736F2032206465206573746120736F6C6963697475642074616E74617320636F7069617320646520636F6E747261746F20636F6D6F20656E7469646164657320636F6E206C6173207175652074726162616A652E3C2F693E0A093C2F6C6162656C3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D226465636C61726F636170616369646164223E0A09093C7370616E20636C6173733D2273616C746F4C696E6561526164696F223E0A09090A090909090909093C7370616E20636C6173733D2273616C746F456C656D656E746F223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F526164696F222064697361626C65643D2264697361626C65642220747970653D22726164696F222076616C75653D2232222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F526164696F223E4861207061637461646F20636F6E747261637475616C6D656E746520636F6E206C617320656E746964616465732061736567757261646F72617320717565206C6F7320696D706F727465732061626F6E61646F7320706F72206C6120636C69656E74656C61207365207265616C697A6172C3A16E20646972656374616D656E746520612074726176C3A97320646520646F6D6963696C69616369C3B36E2062616E636172696120656E206375656E7461732061626965727461732061206E6F6D62726520646520617175656C6C6173207920717565206C61732063616E746964616465732061626F6E6164617320656E20636F6E636570746F20646520696E64656D6E697A6163696F6E657320736520656E747265676172C3A16E20646972656374616D656E746520706F72206C617320656E746964616465732061736567757261646F7261732061206C6F7320746F6D61646F726573206465206C6F732073656775726F732C2061736567757261646F73206F2062656E65666963696172696F732E3C2F7370616E3E3C2F7370616E3E3C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A0909090909093C2F7370616E3E0A09090A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A093C2F6469763E0A093C64697620636C6173733D22746F6F6C6B69744E31223E0A0A093C2F6469763E0A093C64697620636C6173733D22746F6F6C6B69744E31223E0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D22736F63696F735061727469636970616E746573223E0A0A093C68323E536F63696F7320636F6E207061727469636970616369C3B36E207369676E6966696361746976612028313025206F206DC3A173293C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A3C64697620636C6173733D22646976456E4C696E6561222069643D226361706974616C536F6369616C223E0A093C6C6162656C3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E456C206361706974616C20736F6369616C20657374C3A120646973747269627569646F206465206C61207369677569656E7465206D616E6572613A203C2F7370616E3E0A093C2F6C6162656C3E0A093C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D226361706974616C536F6369616C496D706F727465223E0A093C6C6162656C3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E496D706F7274653A203C2F7370616E3E0A093C2F6C6162656C3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D226361706974616C536F6369616C496D706F72746543616D706F223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223EC2A03C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E323030303C2F7370616E3E0A093C2F6C6162656C3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561222069643D226361706974616C536F6369616C457572223E0A093C6C6162656C3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E6575722E203C2F7370616E3E0A093C2F6C6162656C3E0A093C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561426F7264654465726563686F222069643D226361706974616C536F6369616C416363696F6E6573223E0A093C6C6162656C3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E4EC3BA6D65726F20646520616363696F6E65732F70617274696369706163696F6E65733A203C2F7370616E3E0A093C2F6C6162656C3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561222069643D226361706974616C536F6369616C416363696F6E657343616D706F223E0A093C6C6162656C3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223EC2A03C2F7370616E3E0A09093C7370616E20636C6173733D226574697175657461466F726D756C6172696F32223E32303C2F7370616E3E0A093C2F6C6162656C3E0A093C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A3C2F6469763E0A3C64697620636C6173733D22646976456E4C696E6561222069643D226361706974616C536F6369616C33223E0A093C6C6162656C3E0A093C7370616E20636C6173733D226574697175657461466F726D756C6172696F31223E2041637475616C6D656E746520737573637269746F20706F72206C6F73207369677569656E74657320736F63696F7320636F6E207061727469636970616369C3B36E207369676E6966696361746976612E3C2F7370616E3E0A093C2F6C6162656C3E0A093C7370616E20636C6173733D2273616C746F223EC2A03C2F7370616E3E0A3C2F6469763E0A3C64697620636C6173733D22746F6F6C6B69744E222069643D22736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E4E6F6D627265526570726573656E74616E7465223E0A093C7461626C65207374796C653D2220223E0A09093C74686561643E0A0909093C74723E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E4964656E7469666963616369C3B36E3C2F74683E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E4E6F6D6272652F52617AC3B36E20536F6369616C3C2F74683E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E506F7263656E74616A6520616363696F6E657320253C2F74683E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E466563686120646520616C7461203C2F74683E0A0909093C2F74723E0A09093C2F74686561643E0A09093C74626F64793E0A0909093C74722069643D22736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E4E6F6D627265526570726573656E74616E746530223E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E3330363138313834443C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930323233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393033333334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E36303C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E30382F30392F323031373C2F74643E0A0909093C2F74723E0A0909093C74722069643D22736F63696F7350617274696369706163696F6E44656E6F6D696E6163696F6E4964656E74696669636163696F6E4E6F6D627265526570726573656E74616E746531223E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E4231323334353637343C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930323233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393033333334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E34303C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E30382F30392F323031373C2F74643E0A0909093C2F74723E0A09093C2F74626F64793E0A093C2F7461626C653E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D2261646D696E6973747261646F726573223E0A0A093C68323E41646D696E6973747261646F7265733C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A3C64697620636C6173733D22746F6F6C6B69744E222069643D2261646D696E6973747261646F7265734E6F6D627265526570726573656E74616E7465223E0A093C7461626C65207374796C653D2220223E0A09093C74686561643E0A0909093C74723E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E4964656E7469666963616369C3B36E3C2F74683E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E4E6F6D6272652F52617AC3B36E20536F6369616C3C2F74683E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E436172676F3A3C2F74683E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E4665636861206465206E6F6D6272616D69656E746F203C2F74683E0A0909093C2F74723E0A09093C2F74686561643E0A09093C74626F64793E0A0909093C74722069643D2261646D696E6973747261646F7265734E6F6D627265526570726573656E74616E746530223E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E3330363138313834443C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930323233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393033333334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E41646D696E6973747261646F7220C39A6E69636F3C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E30382F30392F323031373C2F74643E0A0909093C2F74723E0A0909093C74722069643D2261646D696E6973747261646F7265734E6F6D627265526570726573656E74616E746531223E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E4231323334353637343C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930323233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393033333334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E41646D696E6973747261646F7220C39A6E69636F3C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E30382F30392F323031373C2F74643E0A0909093C2F74723E0A09093C2F74626F64793E0A093C2F7461626C653E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D226F7267616E6F526573706F6E7361626C65223E0A0A093C68323EC3937267616E6F2064652064697265636369C3B36E20726573706F6E7361626C653C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A3C703E4C617320706572736F6E61732071756520696E74656772616E20656C20C3B37267616E6F2064652064697265636369C3B36E20726573706F6E7361626C65206465206C61206D656469616369C3B36E2064652073656775726F732C2079206C612064697265636369C3B36E206F2070756573746F206173696D696C61646F7320736F6E3A3C2F703E0A3C703E3C693E20496E6469636172203C623E746F646173206C617320706572736F6E617320696E74656772616E7465733C2F623E2064656C20C3937267616E6F2064652064697265636369C3B36E20726573706F6E7361626C652E3C2F693E3C2F703E0A3C64697620636C6173733D22746F6F6C6B69744E222069643D226F7267616E6F526573706F6E7361626C65466F726D6163696F6E223E0A093C7461626C65207374796C653D2220223E0A09093C74686561643E0A0909093C74723E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E4964656E7469666963616369C3B36E3C2F74683E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E4E6F6D6272652F52617AC3B36E20536F6369616C3C2F74683E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E436172676F3A3C2F74683E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E4665636861206465206E6F6D6272616D69656E746F203C2F74683E0A090909093C746820636C6173733D226574697175657461466F726D756C6172696F31223E466F726D616369C3B36E3C2F74683E0A0909093C2F74723E0A09093C2F74686561643E0A09093C74626F64793E0A0909093C74722069643D226F7267616E6F526573706F6E7361626C65466F726D6163696F6E30223E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E3330363138313834443C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930323233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393033333334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E4469726563746F722047656E6572616C2041646A756E746F3C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E30382F30392F323031373C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E437572736F20646520666F726D616369C3B36E20477275706F20413C2F74643E0A0909093C2F74723E0A0909093C74722069643D226F7267616E6F526573706F6E7361626C65466F726D6163696F6E31223E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E4231323334353637343C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930323233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393033333334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E4469726563746F722047656E6572616C2041646A756E746F3C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E30382F30392F323031373C2F74643E0A090909093C7464207374796C653D22776F72642D627265616B3A20627265616B2D616C6C223E437572736F20646520666F726D616369C3B36E20477275706F20413C2F74643E0A0909093C2F74723E0A09093C2F74626F64793E0A093C2F7461626C653E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A093C2F6469763E0A093C64697620636C6173733D22746F6F6C6B69744E31223E0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3220636F6E4C6162656C222069643D22677275706F5F6465636C61726163696F6E6573223E0A0A093C68323E4465636C61726163696F6E657320726573706F6E7361626C65733C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A3C703E3C623E506572736F6E6120746974756C61723A3C2F623E20203C62722F3E5573746564206465636C6172612C2062616A6F20737520726573706F6E736162696C696461642C206C61207665726163696461642064656C20636F6E74656E69646F206465206573746173206465636C61726163696F6E65732E204C612041646D696E69737472616369C3B36E2070756564652064656369646972206E6F20636F6E74696E75617220636F6E20656C2070726F636564696D69656E746F20656E206361736F206465206375616C717569657220696E6578616374697475642C2066616C73656461642075206F6D697369C3B36E202D646520636172C3A163746572206573656E6369616C2D20656E206C6F73206461746F73206465206C6173206465636C61726163696F6E657320726573706F6E7361626C65732C2073696E207065726A756963696F206465206F7472617320726573706F6E736162696C6964616465732070656E616C65732C20636976696C6573206F2061646D696E697374726174697661732E3C2F703E0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E33222069643D226465636C61726163696F6E6573526573706F6E7361626C6573223E0A0A093C64697620636C6173733D22746F6F6C6B69744E223E0A0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E34222069643D226465636C61726163696F6E45737065636966696361223E0A0A093C64697620636C6173733D22746F6F6C6B69744E223E0A0A0A2020202020202020202020202020202020202020203C64697620636C6173733D22646976456E4C696E6561222069643D22636F727265646F7253656775726F734A7572696469636F223E0A2020202020202020202020202020202020200A2020202020202020202020203C6469763E0A202020202020202020202020202020202020202020202020202020202020092020202020202020202020202020200920203C7370616E20636C6173733D226574697175657461436865636B223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F436865636B222064697361626C65643D2264697361626C65642220747970653D22636865636B626F78222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F436865636B223E2A204C6F7320657374617475746F73206465206C6120656E74696461642070726576C3A96E2C2064656E74726F2064656C20617061727461646F20636F72726573706F6E6469656E746520616C206F626A65746F20736F6369616C2C206C61207265616C697A616369C3B36E20646520616374697669646164657320646520636F727265647572C3AD612064652073656775726F732E3C2F7370616E3E3C2F7370616E3E0A20202020202020202020202020202009202020202020202020202020202020202020202020202020093C2F6469763E0A2020202020202020202020202020203C2F6469763E0A2020200A0A0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E3420636F6E4C6162656C222069643D22677275706F4465636C61726163486F6E6F726162696C69646164223E0A0A093C68323E486F6E6F726162696C6964616420636F6D65726369616C20792070726F666573696F6E616C3C2F68323E093C64697620636C6173733D22746F6F6C6B69744E20626F726465223E0A0A0A2020202020202020202020202020202020202020203C64697620636C6173733D22646976456E4C696E6561222069643D226465636C61726163696F6E5F6573706563696669636132223E0A2020202020202020202020202020202020200A2020202020202020202020203C6469763E0A202020202020202020202020202020202020202020202020202020202020092020202020202020202020202020200920203C7370616E20636C6173733D226574697175657461436865636B223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F436865636B222064697361626C65643D2264697361626C65642220747970653D22636865636B626F78222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F436865636B223E2A204861206F627365727661646F20756E6120747261796563746F72696120706572736F6E616C206465207265737065746F2061206C6173206C65796573206D657263616E74696C65732079206F747261732071756520726567756C616E206C61206163746976696461642065636F6EC3B36D6963612079206C612076696461206465206C6F73206E65676F63696F732C206173C3AD20636F6D6F2061206C6173206275656E6173207072C3A163746963617320636F6D65726369616C65732C2066696E616E63696572617320792064652073656775726F732E3C2F7370616E3E3C2F7370616E3E0A20202020202020202020202020202009202020202020202020202020202020202020202020202020093C2F6469763E0A2020202020202020202020202020203C2F6469763E0A2020200A0A2020202020202020202020202020202020202020203C64697620636C6173733D22646976456E4C696E6561222069643D226465636C61726163696F6E5F6573706563696669636133223E0A2020202020202020202020202020202020200A2020202020202020202020203C6469763E0A202020202020202020202020202020202020202020202020202020202020092020202020202020202020202020200920203C7370616E20636C6173733D226574697175657461436865636B223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F436865636B222064697361626C65643D2264697361626C65642220747970653D22636865636B626F78222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F436865636B223E2A204E6F20657374C3A120696E686162696C6974616461207061726120656A657263657220636172676F732070C3BA626C69636F73206F2064652061646D696E69737472616369C3B36E206F2064697265636369C3B36E20656E20656E746964616465732066696E616E6369657261732C2061736567757261646F726173206F206465206D656469616369C3B36E2064652073656775726F73206F2064652072656173656775726F732E3C2F7370616E3E3C2F7370616E3E0A20202020202020202020202020202009202020202020202020202020202020202020202020202020093C2F6469763E0A2020202020202020202020202020203C2F6469763E0A2020200A0A2020202020202020202020202020202020202020203C64697620636C6173733D22646976456E4C696E6561222069643D226465636C61726163696F6E5F6573706563696669636134223E0A2020202020202020202020202020202020200A2020202020202020202020203C6469763E0A202020202020202020202020202020202020202020202020202020202020092020202020202020202020202020200920203C7370616E20636C6173733D226574697175657461436865636B223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F436865636B222064697361626C65643D2264697361626C65642220747970653D22636865636B626F78222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F436865636B223E2A204E6F206861207369646F20696E686162696C697461646120636F6E666F726D652061206C6F2064697370756573746F20656E206C61204C657920436F6E63757273616C2032322F323030332C2064652039206465206A756C696F2E3C2F7370616E3E3C2F7370616E3E0A20202020202020202020202020202009202020202020202020202020202020202020202020202020093C2F6469763E0A2020202020202020202020202020203C2F6469763E0A2020200A0A2020202020202020202020202020202020202020203C64697620636C6173733D22646976456E4C696E6561222069643D226465636C61726163696F6E5F6573706563696669636135223E0A2020202020202020202020202020202020200A2020202020202020202020203C6469763E0A202020202020202020202020202020202020202020202020202020202020092020202020202020202020202020200920203C7370616E20636C6173733D226574697175657461436865636B223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F436865636B222064697361626C65643D2264697361626C65642220747970653D22636865636B626F78222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F436865636B223E2A204E6F20657374C3A120696E637572736120656E20696E636170616369646164206F2070726F686962696369C3B36E20636F6E666F726D652061206C61206C656769736C616369C3B36E20766967656E74652E3C2F7370616E3E3C2F7370616E3E0A20202020202020202020202020202009202020202020202020202020202020202020202020202020093C2F6469763E0A2020202020202020202020202020203C2F6469763E0A2020200A0A2020202020202020202020202020202020202020203C64697620636C6173733D22646976456E4C696E6561222069643D226465636C61726163696F6E5F6573706563696669636136223E0A2020202020202020202020202020202020200A2020202020202020202020203C6469763E0A202020202020202020202020202020202020202020202020202020202020092020202020202020202020202020200920203C7370616E20636C6173733D226574697175657461436865636B223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F436865636B222064697361626C65643D2264697361626C65642220747970653D22636865636B626F78222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F436865636B223E2A204E6F206861207369646F2073757370656E6469646120706F722073616E6369C3B36E206669726D65207061726120656C20656A6572636963696F206465206C6120616374697669646164206465206D656469616369C3B36E20636F6E666F726D652061206C6F2064697370756573746F20656E20656C20617274C3AD63756C6F203536206465206C61204C65792032362F323030362C206465203137206465206A756C696F2C206465206D656469616369C3B36E2064652073656775726F7320792072656173656775726F73207072697661646F732E3C2F7370616E3E3C2F7370616E3E0A20202020202020202020202020202009202020202020202020202020202020202020202020202020093C2F6469763E0A2020202020202020202020202020203C2F6469763E0A2020200A0A2020202020202020202020202020202020202020203C64697620636C6173733D22646976456E4C696E6561222069643D226465636C61726163696F6E5F6573706563696669636137223E0A2020202020202020202020202020202020200A2020202020202020202020203C6469763E0A202020202020202020202020202020202020202020202020202020202020092020202020202020202020202020200920203C7370616E20636C6173733D226574697175657461436865636B223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F436865636B222064697361626C65643D2264697361626C65642220747970653D22636865636B626F78222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F436865636B223E2A2043617265636520646520616E7465636564656E7465732070656E616C657320706F722064656C69746F732064652066616C73656461642C2076696F6C616369C3B36E206465207365637265746F732C2064657363756272696D69656E746F207920726576656C616369C3B36E206465207365637265746F7320636F6E747261206C612068616369656E64612070C3BA626C696361207920636F6E747261206C612073656775726964616420736F6369616C2C206D616C76657273616369C3B36E2064652063617564616C65732070C3BA626C69636F732079206375616C6573717569657261206F74726F732064656C69746F7320636F6E747261206C612070726F7069656461642E3C2F7370616E3E3C2F7370616E3E0A20202020202020202020202020202009202020202020202020202020202020202020202020202020093C2F6469763E0A2020202020202020202020202020203C2F6469763E0A2020200A0A2020202020202020202020202020202020202020203C64697620636C6173733D22646976456E4C696E6561222069643D226465636C61726163696F6E5F6573706563696669636138223E0A2020202020202020202020202020202020200A2020202020202020202020203C6469763E0A202020202020202020202020202020202020202020202020202020202020092020202020202020202020202020200920203C7370616E20636C6173733D226574697175657461436865636B223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F436865636B222064697361626C65643D2264697361626C65642220747970653D22636865636B626F78222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F436865636B223E2A204E6F206F7374656E746120636172676F206E69206465736172726F6C6C612066756E6369C3B36E20616C67756E612071756520707565646120696E63757272697220656E206C6F7320737570756573746F7320646520696E636F6D7061746962696C6964616420636F6E74656D706C61646F7320656E206C6F7320617274C3AD63756C6F73202033312079203332206465206C61204C65792032362F323030362E3C2F7370616E3E3C2F7370616E3E0A20202020202020202020202020202009202020202020202020202020202020202020202020202020093C2F6469763E0A2020202020202020202020202020203C2F6469763E0A2020200A0A2020202020202020202020202020202020202020203C64697620636C6173733D22646976456E4C696E6561222069643D226465636C61726163696F6E5F6573706563696669636139223E0A2020202020202020202020202020202020200A2020202020202020202020203C6469763E0A202020202020202020202020202020202020202020202020202020202020092020202020202020202020202020200920203C7370616E20636C6173733D226574697175657461436865636B223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F436865636B222064697361626C65643D2264697361626C65642220747970653D22636865636B626F78222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F436865636B223E2A204173696D69736D6F206465636C6172612071756520746F646F20656C20706572736F6E616C207175652070617274696369706120646972656374616D656E746520656E206C61206D656469616369C3B36E2064652073656775726F732063756D706C6520636F6E206C6F732072657175697369746F7320646520686F6E6F726162696C6964616420616E746572696F7265732E3C2F7370616E3E3C2F7370616E3E0A20202020202020202020202020202009202020202020202020202020202020202020202020202020093C2F6469763E0A2020202020202020202020202020203C2F6469763E0A2020200A3C2F6469763E0A3C2F6469763E0A0A0A0A0A093C64697620636C6173733D22746F6F6C6B69744E34222069643D22677275706F4465636C61726163526573746F223E0A0A093C64697620636C6173733D22746F6F6C6B69744E223E0A0A0A2020202020202020202020202020202020202020203C64697620636C6173733D22646976456E4C696E6561222069643D226465636C61726163696F6E5F657370656369666963613130223E0A2020202020202020202020202020202020200A2020202020202020202020203C6469763E0A202020202020202020202020202020202020202020202020202020202020092020202020202020202020202020200920203C7370616E20636C6173733D226574697175657461436865636B223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F436865636B222064697361626C65643D2264697361626C65642220747970653D22636865636B626F78222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F436865636B223E2A2043756D706C6520636F6E206C6F732072657175697369746F732065737461626C656369646F7320656E206C61206E6F726D617469766120766967656E74652E3C2F7370616E3E3C2F7370616E3E0A20202020202020202020202020202009202020202020202020202020202020202020202020202020093C2F6469763E0A2020202020202020202020202020203C2F6469763E0A2020200A0A2020202020202020202020202020202020202020203C64697620636C6173733D22646976456E4C696E6561222069643D226465636C61726163696F6E5F657370656369666963613131223E0A2020202020202020202020202020202020200A2020202020202020202020203C6469763E0A202020202020202020202020202020202020202020202020202020202020092020202020202020202020202020200920203C7370616E20636C6173733D226574697175657461436865636B223E3C696E70757420636865636B65643D22636865636B65642220636C6173733D22696E70757456616C6F7246696A6F436865636B222064697361626C65643D2264697361626C65642220747970653D22636865636B626F78222076616C75653D2231222F3E3C7370616E20636C6173733D22746578746F56616C6F7246696A6F436865636B223E2A20536F6E2063696572746F73207920636F6D706C65746F7320746F646F73206C6F73206461746F73206465206C612070726573656E746520736F6C6963697475642C206173C3AD20636F6D6F20746F6461206C6120646F63756D656E74616369C3B36E207175652070726573656E746F2079206173756D6F206C6120636F72726573706F6E6469656E746520726573706F6E736162696C696461642028417274C3AD63756C6F2032382E372C206465206C61204C65792033392F323031352C2064652031206465206F6374756272652C2064656C2050726F636564696D69656E746F2041646D696E69737472617469766F20436F6DC3BA6E206465206C61732041646D696E697374726163696F6E65732050C3BA626C69636173292E3C62722F3E3C62722F3E4C6120696E6578616374697475642C2066616C73656461642075206F6D697369C3B36E2C20646520636172C3A163746572206573656E6369616C2C206465206375616C7175696572206461746F206F20696E666F726D616369C3B36E2071756520736520696E636F72706F7265206120756E61206465636C6172616369C3B36E20726573706F6E7361626C65206F206120756E6120636F6D756E6963616369C3B36E2C206F206C61206E6F2070726573656E74616369C3B36E20616E7465206C612041646D696E69737472616369C3B36E20636F6D706574656E7465206465206C61206465636C6172616369C3B36E20726573706F6E7361626C652C206C6120646F63756D656E74616369C3B36E207175652073656120656E207375206361736F2072657175657269646120706172612061637265646974617220656C2063756D706C696D69656E746F206465206C6F206465636C617261646F2C206F206C6120636F6D756E6963616369C3B36E2C2064657465726D696E6172C3A1206C6120696D706F736962696C6964616420646520636F6E74696E75617220636F6E20656C20656A6572636963696F2064656C206465726563686F206F2061637469766964616420616665637461646120646573646520656C206D6F6D656E746F20656E207175652073652074656E676120636F6E7374616E6369612064652074616C657320686563686F732C2073696E207065726A756963696F206465206C617320726573706F6E736162696C6964616465732070656E616C65732C20636976696C6573206F2061646D696E697374726174697661732061207175652068756269657261206C756761722028417274C3AD63756C6F2036392E342C206465206C61204C65792033392F323031352C2064652031206465206F6374756272652C2064656C2050726F636564696D69656E746F2041646D696E69737472617469766F20436F6DC3BA6E206465206C61732041646D696E697374726163696F6E65732050C3BA626C69636173292E3C2F7370616E3E3C2F7370616E3E0A20202020202020202020202020202009202020202020202020202020202020202020202020202020093C2F6469763E0A2020202020202020202020202020203C2F6469763E0A2020200A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A3C2F6469763E0A0A0A093C2F6469763E0A093C64697620636C6173733D22746F6F6C6B69744E31223E0A093C2F6469763E0A0A202020202020202020202020200A2020202020200A2020202020200A2020202020203C6469762069643D226669726D61646F506F72223E3C68322069643D22706965223E4669726D61646F20656C65637472C3B36E6963616D656E746520706F723A3C2F68323E3C703E434955444144414E4F20464943544943494F2041435449564F2028393939393939393053293C2F703E3C2F6469763E0A2020203C2F6469763E2020200A2020203C2F626F64793E0A3C2F68746D6C3E</sourceBinary>       <signaturesEvent>         <signatureEvent>           <signEvent>             <ejgvDocumentEvent>               <headerEvent>                 <type>xades</type>                 <version>2.0</version>                 <placement>enveloped</placement>                 <flags>0</flags>                 <format>ES-T</format>               </headerEvent>               <bodyEvent>                 <sign>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</sign>               </bodyEvent>             </ejgvDocumentEvent>           </signEvent>           <signerID>99999990S</signerID>           <signerName>CIUDADANO FICTICIO ACTIVO</signerName>           <departmentID>56</departmentID>           <entityID>04833001</entityID>           <format>html</format>         </signatureEvent>       </signaturesEvent>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Solicitud</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>TRUE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_poliza.0.ejgv_reg_0003</roleId>       <roleNameEs>Pliza de responsabilidad civil</roleNameEs>       <roleNameEu>Erantzukizun zibileko poliza</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Pliza de responsabilidad civil</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_escritura.0.r02d8515A2ECC1D7F2376582B45FC3E3326B8F22D30E</roleId>       <roleNameEs>Memoria de Actividades</roleNameEs>       <roleNameEu>Jardueren memoria</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Memoria de Actividades</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_escritura.0.ejgv_reg_0062</roleId>       <roleNameEs>Copia de escritura de los estatutos de la entidad mercantil</roleNameEs>       <roleNameEu>Merkataritza- erakundearen estatutuen kopia</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Copia de escritura de los estatutos de la entidad mercantil</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_programa.0.ejgv_reg_0002</roleId>       <roleNameEs>Programa de actividades y formacin</roleNameEs>       <roleNameEu>Prestakuntza- eta ekintza-programa</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Programa de actividades y formacin</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_titacademico.0.ejgv_reg_0004</roleId>       <roleNameEs>Diploma de mediador de seguros</roleNameEs>       <roleNameEu>Aseguru Bitartekariaren Diploma</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Diploma de mediador de seguros</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_contraadmin.0.ejgv_reg_0060</roleId>       <roleNameEs>Contrato con entidades aseguradoras</roleNameEs>       <roleNameEu>Aseguru- erakundeekin kontratua</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Contrato con entidades aseguradoras</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_certificado.0.ejgv_reg_0061</roleId>       <roleNameEs>Certificado de curso formativo Grupo A</roleNameEs>       <roleNameEu>Prestakuntza-ikastaroaren ziurtagiria. A taldea</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Certificado de curso formativo Grupo A</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_declararesponsable.0.ejgv_ayu_sub_0595</roleId>       <roleNameEs>Identificacin y declaracin de honorabilidad por cada socio</roleNameEs>       <roleNameEu>Eu_Identificacin y declaracin de honorabilidad por cada socio</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Identificacin y declaracin de honorabilidad por cada socio</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_acuerdo.0.ejgv_ayu_sub_0599</roleId>       <roleNameEs>Compromiso de domiciliacin bancaria con las aseguradoras</roleNameEs>       <roleNameEu>Eu_Compromiso de domiciliacin bancaria con las aseguradoras</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Compromiso de domiciliacin bancaria con las aseguradoras</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>   </documentsEvent>   <dataControlEvent>     <type>MESSAGECONTROL</type>     <value>S</value>   </dataControlEvent>   <dataControlEvent>     <type>CERTIFIEDVALIDATIONMODE</type>     <value>ASYNC</value>   </dataControlEvent> </contextSubmissionEvent>]]></xmlValue> </NotificationBody>");
		   //Modificacion J7102572J segn pgina cuaderno (Pag. 527)
//		   sendMessage("<NotificationBody xmlns=\"com/ejie/notification/xml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <Property>     <Name>EventWho</Name>     <Value>R02</Value>   </Property>   <Property>     <Name>EventTipology</Name>     <Value>R02_TRAMITATION</Value>   </Property>   <Property>     <Name>EventWhat</Name>     <Value>R02_REQUEST</Value>   </Property>   <Property>     <Name>ProcedureID</Name>     <Value>0009403</Value>   </Property>   <Property>     <Name>PlateaType</Name>     <Value>SOLTELEMATICA</Value>   </Property>   <Property>     <Name>PlateaSubType</Name>     <Value>1</Value>   </Property>   <Property>     <Name>Mailbox</Name>     <Value xsi:nil=\"true\"/>   </Property>   <Property>     <Name>Status</Name>     <Value xsi:nil=\"true\"/>   </Property>   <xmlValue><![CDATA[<contextSubmissionEvent xmlns=\"com/ejie/folderManagement/xml\">   <daDocumentalSeries>5744</daDocumentalSeries>   <departmentID>56</departmentID>   <departmentNameEs>HACIENDA Y ECONOMA</departmentNameEs>   <departmentNameEu>OGASUNA ETA EKONOMIA</departmentNameEu>   <entityID>04833001</entityID>   <entityNameEs>Administracin Pblica de la CAE</entityNameEs>   <entityNameEu>EAEko Administrazio Publikoa</entityNameEu>   <familyID>REGIST</familyID>   <folderID>R02T5F099D957A08BCEDDB3276A9123C0162791D9F15</folderID>   <creationTimestamp>08/09/2017 12:11:17</creationTimestamp>   <mailbox>R01I-Y52B-RMS02</mailbox>   <managingUnitID>2284</managingUnitID>   <managingUnitNameEs>DIRECCIN DE POLTICA FINANCIERA Y RECURSOS INSTITUCIONALES</managingUnitNameEs>   <managingUnitNameEu>FINANTZA POLITIKAKO ETA ERAKUNDEEN BALIABIDEETAKO ZUZENDARITZA</managingUnitNameEu>   <solicitudID>118597</solicitudID>   <procedureID>0009403</procedureID>   <procedureNameEs>Modificacin de datos en el Registro de Mediadores de Seguros</procedureNameEs>   <procedureNameEu>eu_Modificacin de datos en el Registro de Mediadores de Seguros</procedureNameEu>   <procedureInboxID>R01I-Y52B-RMSRP01</procedureInboxID>   <procedureInboxName>Registro mediadores de seguros - Responsables</procedureInboxName>   <registryNumber>2017RTE00010686</registryNumber>   <registryTimestamp>08/09/2017 12:11:16</registryTimestamp>   <registrySenderID>99999990S</registrySenderID>   <registrySenderName>CIUDADANO FICTICIO ACTIVO</registrySenderName>   <registryAddresseeCode>2284</registryAddresseeCode>   <registryTopicCode>0009403</registryTopicCode>   <participantID>R02TB99138A78F7B678A345028D884036AE751EAD1D0</participantID>   <senderID>99999990S</senderID>   <senderName>CIUDADANO FICTICIO ACTIVO</senderName>   <senderType>2</senderType>   <submissionType>1</submissionType>   <submissionTypeNameEs>Solicitud</submissionTypeNameEs>   <submissionTypeNameEu>Eskaera</submissionTypeNameEu>   <managerCalendarType>cal-capv</managerCalendarType>   <resolutionCalendarType>cal-capv</resolutionCalendarType>   <applicationID>R02T597AA5017A4B68CCEB2A8C27205B1D7331B4A2C0</applicationID>   <ApplicantsInfoEvent>     <ApplicantInfoEvent>       <notificationEvent>         <addresseeID>99999990S</addresseeID>         <addresseeName>CIUDADANO FICTICIO ACTIVO</addresseeName>         <channelType>1</channelType>       </notificationEvent>       <personsEvent>         <personEvent>           <id>J7102572J</id>           <name>ENTIDAD FICTICIO ACTIVO</name>           <personType>2</personType>           <holderShip>1</holderShip>         </personEvent>         <personEvent>           <id>99999990S</id>           <name>CIUDADANO</name>           <lastname1>FICTICIO</lastname1>           <lastname2>ACTIVO</lastname2>           <personType>1</personType>           <holderShip>2</holderShip>         </personEvent>       </personsEvent>       <language>es</language>     </ApplicantInfoEvent>   </ApplicantsInfoEvent>   <documentsEvent>     <documentEvent>       <oid>09f4240180876e1e</oid>       <roleId>ejgv_d_solicitud.0.0</roleId>       <roleNameEs>Solicitud</roleNameEs>       <roleNameEu>Eskabide</roleNameEu>       <sourceName>Solicitud.html</sourceName>       <documentType>PRE</documentType>       <extension>html</extension>       <format>E</format>       <sourceBinary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sourceBinary>       <signaturesEvent>         <signatureEvent>           <signEvent>             <ejgvDocumentEvent>               <headerEvent>                 <type>xades</type>                 <version>2.0</version>                 <placement>enveloped</placement>                 <flags>0</flags>                 <format>ES-T</format>               </headerEvent>               <bodyEvent>                 <sign>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</sign>               </bodyEvent>             </ejgvDocumentEvent>           </signEvent>           <signerID>99999990S</signerID>           <signerName>CIUDADANO FICTICIO ACTIVO</signerName>           <departmentID>56</departmentID>           <entityID>04833001</entityID>           <format>html</format>         </signatureEvent>       </signaturesEvent>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Solicitud</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>TRUE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_escritura.0.egjv_escritura_publica</roleId>       <roleNameEs>Escritura pblica en el que se recoge la modificacin realizada</roleNameEs>       <roleNameEu>eu_Escritura pblica en el que se recoge la modificacin realizada</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Escritura pblica en el que se recoge la modificacin realizada</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_titacademico.0.ejgv_reg_0078</roleId>       <roleNameEs>Ttulo formativo suficiente</roleNameEs>       <roleNameEu>Eu_Ttulo formativo suficiente</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Ttulo formativo suficiente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_declararesponsable.0.ejgv_reg_0079</roleId>       <roleNameEs>Identificacin y declaracin de idoneidad de cada nuevo cargo</roleNameEs>       <roleNameEu>Eu_Identificacin y declaracin de idoneidad de cada nuevo cargo</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Identificacin y declaracin de idoneidad de cada nuevo cargo</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_justificante.0.ejgv_justificacion_inscripcion_registro</roleId>       <roleNameEs>Justificacin de inscripcin en el Registro Mercantil</roleNameEs>       <roleNameEu>eu_Justificacin de inscripcin en el Registro Mercantil</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Justificacin de inscripcin en el Registro Mercantil</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_escritura.0.ejgv_escritura_publica</roleId>       <roleNameEs>Escritura pblica en la que se recoja la transmisin de acciones/participaciones</roleNameEs>       <roleNameEu>eu_Escritura pblica en la que se recoja la transmisin de acciones/participaciones</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Escritura pblica en la que se recoja la transmisin de acciones/participaciones</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_declararesponsable.0.ejgv_ayu_sub_0595</roleId>       <roleNameEs>Identificacin y declaracin de honorabilidad por cada socio</roleNameEs>       <roleNameEu>Eu_Identificacin y declaracin de honorabilidad por cada socio</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Identificacin y declaracin de honorabilidad por cada socio</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_informe.0.ejgv_copia_legalizada</roleId>       <roleNameEs>Copia legalizada en que se recoja el cese y nombramiento de los administradores, consejeros, directores generales, gerentes o apoderados, con la inscripcin en el registro mercantil.</roleNameEs>       <roleNameEu>eu_Copia legalizada en que se recoja el cese y nombramiento de los administradores, consejeros, directores generales, gerentes o apoderados, con la inscripcin en el registro mercantil.</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Copia legalizada en que se recoja el cese y nombramiento de los administradores, consejeros, directores generales, gerentes o apoderados, con la inscripcin en el registro mercantil.</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_acuerdo.0.ejgv_acuerdo_organo_administracion</roleId>       <roleNameEs>Acuerdo del rgano de administracin en el que se designe a las personas que integran el rgano de direccin responsable de la mediacin de los seguros y al Director o directores tcnicos.</roleNameEs>       <roleNameEu>eu_Acuerdo del rgano de administracin en el que se designe a las personas que integran el rgano de direccin responsable de la mediacin de los seguros y al Director o directores tcnicos.</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Acuerdo del rgano de administracin en el que se designe a las personas que integran el rgano de direccin responsable de la mediacin de los seguros y al Director o directores tcnicos.</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>   </documentsEvent>   <dataControlEvent>     <type>MESSAGECONTROL</type>     <value>S</value>   </dataControlEvent>   <dataControlEvent>     <type>CERTIFIEDVALIDATIONMODE</type>     <value>ASYNC</value>   </dataControlEvent> </contextSubmissionEvent>]]></xmlValue> </NotificationBody>");
		   //Modificacion J7102572J segn pgina cuaderno (Pag. 527) Otros apartados
//		   sendMessage("<NotificationBody xmlns=\"com/ejie/notification/xml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <Property>     <Name>EventWho</Name>     <Value>R02</Value>   </Property>   <Property>     <Name>EventTipology</Name>     <Value>R02_TRAMITATION</Value>   </Property>   <Property>     <Name>EventWhat</Name>     <Value>R02_REQUEST</Value>   </Property>   <Property>     <Name>ProcedureID</Name>     <Value>0009403</Value>   </Property>   <Property>     <Name>PlateaType</Name>     <Value>SOLTELEMATICA</Value>   </Property>   <Property>     <Name>PlateaSubType</Name>     <Value>1</Value>   </Property>   <Property>     <Name>Mailbox</Name>     <Value xsi:nil=\"true\"/>   </Property>   <Property>     <Name>Status</Name>     <Value xsi:nil=\"true\"/>   </Property>   <xmlValue><![CDATA[<contextSubmissionEvent xmlns=\"com/ejie/folderManagement/xml\">   <daDocumentalSeries>5744</daDocumentalSeries>   <departmentID>56</departmentID>   <departmentNameEs>HACIENDA Y ECONOMA</departmentNameEs>   <departmentNameEu>OGASUNA ETA EKONOMIA</departmentNameEu>   <entityID>04833001</entityID>   <entityNameEs>Administracin Pblica de la CAE</entityNameEs>   <entityNameEu>EAEko Administrazio Publikoa</entityNameEu>   <familyID>REGIST</familyID>   <folderID>R02T616ABD0AD6D0C9434E349782CF8B0009620B020F</folderID>   <creationTimestamp>12/09/2017 13:43:31</creationTimestamp>   <mailbox>R01I-Y52B-RMS02</mailbox>   <managingUnitID>2284</managingUnitID>   <managingUnitNameEs>DIRECCIN DE POLTICA FINANCIERA Y RECURSOS INSTITUCIONALES</managingUnitNameEs>   <managingUnitNameEu>FINANTZA POLITIKAKO ETA ERAKUNDEEN BALIABIDEETAKO ZUZENDARITZA</managingUnitNameEu>   <solicitudID>118715</solicitudID>   <procedureID>0009403</procedureID>   <procedureNameEs>Modificacin de datos en el Registro de Mediadores de Seguros</procedureNameEs>   <procedureNameEu>eu_Modificacin de datos en el Registro de Mediadores de Seguros</procedureNameEu>   <procedureInboxID>R01I-Y52B-RMSRP01</procedureInboxID>   <procedureInboxName>Registro mediadores de seguros - Responsables</procedureInboxName>   <registryNumber>2017RTE00010832</registryNumber>   <registryTimestamp>12/09/2017 13:43:28</registryTimestamp>   <registrySenderID>99999990S</registrySenderID>   <registrySenderName>CIUDADANO FICTICIO ACTIVO</registrySenderName>   <registryAddresseeCode>2284</registryAddresseeCode>   <registryTopicCode>0009403</registryTopicCode>   <participantID>R02T45259242A73D2BBC02FA33B6F27B1DF7A21D2A84</participantID>   <senderID>99999990S</senderID>   <senderName>CIUDADANO FICTICIO ACTIVO</senderName>   <senderType>2</senderType>   <submissionType>1</submissionType>   <submissionTypeNameEs>Solicitud</submissionTypeNameEs>   <submissionTypeNameEu>Eskaera</submissionTypeNameEu>   <managerCalendarType>cal-capv</managerCalendarType>   <resolutionCalendarType>cal-capv</resolutionCalendarType>   <applicationID>R02T504406EBE2C76D641474E61C39C209640696DD9C</applicationID>   <ApplicantsInfoEvent>     <ApplicantInfoEvent>       <notificationEvent>         <addresseeID>99999990S</addresseeID>         <addresseeName>CIUDADANO FICTICIO ACTIVO</addresseeName>         <channelType>1</channelType>       </notificationEvent>       <personsEvent>         <personEvent>           <id>J7102572J</id>           <name>ENTIDAD FICTICIO ACTIVO</name>           <personType>2</personType>           <holderShip>1</holderShip>         </personEvent>         <personEvent>           <id>99999990S</id>           <name>CIUDADANO</name>           <lastname1>FICTICIO</lastname1>           <lastname2>ACTIVO</lastname2>           <personType>1</personType>           <holderShip>2</holderShip>         </personEvent>       </personsEvent>       <language>es</language>     </ApplicantInfoEvent>   </ApplicantsInfoEvent>   <documentsEvent>     <documentEvent>       <oid>09f42401808793b0</oid>       <roleId>ejgv_d_solicitud.0.0</roleId>       <roleNameEs>Solicitud</roleNameEs>       <roleNameEu>Eskabide</roleNameEu>       <sourceName>Solicitud.html</sourceName>       <documentType>PRE</documentType>       <extension>html</extension>       <format>E</format>       <sourceBinary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sourceBinary>       <signaturesEvent>         <signatureEvent>           <signEvent>             <ejgvDocumentEvent>               <headerEvent>                 <type>xades</type>                 <version>2.0</version>                 <placement>enveloped</placement>                 <flags>0</flags>                 <format>ES-T</format>               </headerEvent>               <bodyEvent>                 <sign>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</sign>               </bodyEvent>             </ejgvDocumentEvent>           </signEvent>           <signerID>99999990S</signerID>           <signerName>CIUDADANO FICTICIO ACTIVO</signerName>           <departmentID>56</departmentID>           <entityID>04833001</entityID>           <format>html</format>         </signatureEvent>       </signaturesEvent>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Solicitud</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>TRUE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_escritura.0.egjv_escritura_publica</roleId>       <roleNameEs>Escritura pblica en el que se recoge la modificacin realizada</roleNameEs>       <roleNameEu>eu_Escritura pblica en el que se recoge la modificacin realizada</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Escritura pblica en el que se recoge la modificacin realizada</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_poliza.0.0</roleId>       <roleNameEs>Pliza</roleNameEs>       <roleNameEu>Poliza</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Pliza</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_justificante.0.ejgv_justificacion_inscripcion_registro</roleId>       <roleNameEs>Justificacin de inscripcin en el Registro Mercantil</roleNameEs>       <roleNameEu>eu_Justificacin de inscripcin en el Registro Mercantil</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Justificacin de inscripcin en el Registro Mercantil</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_curriculum.0.ejgv_reg_0008</roleId>       <roleNameEs>Documentacin referente al titular del servicio</roleNameEs>       <roleNameEu>Eu_Documentacin referente al titular del servicio</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Documentacin referente al titular del servicio</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_informe.0.egjv_desginacion_servicio_att_cliente</roleId>       <roleNameEs>Designacin del servicio de atencin al cliente / defensor del cliente</roleNameEs>       <roleNameEu>EU_Designacin  del servicio de atencin al cliente / defensor del cliente</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Designacin del servicio de atencin al cliente / defensor del cliente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_informe.0.ejgv_reglamento_funcionamiento_defensa</roleId>       <roleNameEs>Reglamento de funcionamiento para la defensa del cliente</roleNameEs>       <roleNameEu>eu_Reglamento de funcionamiento para la defensa del cliente</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Reglamento de funcionamiento para la defensa del cliente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_aval.0.ejgv_reg_0005</roleId>       <roleNameEs>Acreditacin de capacidad financiera (Aval o seguro de caucin)</roleNameEs>       <roleNameEu>Finantza-gaitasunaren egiaztagiria</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Acreditacin de capacidad financiera (Aval o seguro de caucin)</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>   </documentsEvent>   <dataControlEvent>     <type>MESSAGECONTROL</type>     <value>S</value>   </dataControlEvent>   <dataControlEvent>     <type>CERTIFIEDVALIDATIONMODE</type>     <value>ASYNC</value>   </dataControlEvent> </contextSubmissionEvent>]]></xmlValue> </NotificationBody>");
		   //Error Conchi EV Espacios antes de CIF/Aprovechar para ver rollback y commit;
//		   sendMessage("<NotificationBody xmlns=\"com/ejie/notification/xml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <Property>     <Name>EventWho</Name>     <Value>R02</Value>   </Property>   <Property>     <Name>EventTipology</Name>     <Value>R02_TRAMITATION</Value>   </Property>   <Property>     <Name>EventWhat</Name>     <Value>R02_REQUEST</Value>   </Property>   <Property>     <Name>ProcedureID</Name>     <Value>0009402</Value>   </Property>   <Property>     <Name>PlateaType</Name>     <Value>SOLTELEMATICA</Value>   </Property>   <Property>     <Name>PlateaSubType</Name>     <Value>1</Value>   </Property>   <Property>     <Name>Mailbox</Name>     <Value xsi:nil=\"true\"/>   </Property>   <Property>     <Name>Status</Name>     <Value xsi:nil=\"true\"/>   </Property>   <xmlValue><![CDATA[<contextSubmissionEvent xmlns=\"com/ejie/folderManagement/xml\">   <daDocumentalSeries>5744</daDocumentalSeries>   <departmentID>56</departmentID>   <departmentNameEs>HACIENDA Y ECONOMA</departmentNameEs>   <departmentNameEu>OGASUNA ETA EKONOMIA</departmentNameEu>   <entityID>04833001</entityID>   <entityNameEs>Administracin Pblica de la CAE</entityNameEs>   <entityNameEu>EAEko Administrazio Publikoa</entityNameEu>   <familyID>REGIST</familyID>   <folderID>R02T12BB03D2AC5920ADA586B57999B76AA406EE8BAF</folderID>   <creationTimestamp>20/09/2017 08:49:02</creationTimestamp>   <mailbox>R01I-Y52B-RMS02</mailbox>   <managingUnitID>2284</managingUnitID>   <managingUnitNameEs>DIRECCIN DE POLTICA FINANCIERA Y RECURSOS INSTITUCIONALES</managingUnitNameEs>   <managingUnitNameEu>FINANTZA POLITIKAKO ETA ERAKUNDEEN BALIABIDEETAKO ZUZENDARITZA</managingUnitNameEu>   <solicitudID>119018</solicitudID>   <procedureID>0009402</procedureID>   <procedureNameEs>Inscripcin en el registro de mediadores de seguros</procedureNameEs>   <procedureNameEu>Aseguru-artekarien erregistroan inskribatzea</procedureNameEu>   <procedureInboxID>R01I-Y52B-RMSRP01</procedureInboxID>   <procedureInboxName>Registro mediadores de seguros - Responsables</procedureInboxName>   <registryNumber>2017RTE00011179</registryNumber>   <registryTimestamp>20/09/2017 08:49:00</registryTimestamp>   <registrySenderID>99999990S</registrySenderID>   <registrySenderName>CIUDADANO FICTICIO ACTIVO</registrySenderName>   <registryAddresseeCode>2284</registryAddresseeCode>   <registryTopicCode>0009402</registryTopicCode>   <participantID>R02TCDD0593EAA88A0FA3DD7B5C41ED487C880D3AAC9</participantID>   <senderID>99999990S</senderID>   <senderName>CIUDADANO FICTICIO ACTIVO</senderName>   <senderType>1</senderType>   <submissionType>1</submissionType>   <submissionTypeNameEs>Solicitud</submissionTypeNameEs>   <submissionTypeNameEu>Eskaera</submissionTypeNameEu>   <managerCalendarType>cal-capv</managerCalendarType>   <resolutionCalendarType>cal-capv</resolutionCalendarType>   <applicationID>R02T78147DDD7AB5C15301F6AADEAE902AE386AB8008</applicationID>   <ApplicantsInfoEvent>     <ApplicantInfoEvent>       <notificationEvent>         <addresseeID>99999990S</addresseeID>         <addresseeName>CIUDADANO FICTICIO ACTIVO</addresseeName>         <channelType>1</channelType>       </notificationEvent>       <personsEvent>         <personEvent>           <id>99999990S</id>           <name>CIUDADANO</name>           <lastname1>FICTICIO</lastname1>           <lastname2>ACTIVO</lastname2>           <personType>1</personType>           <holderShip>1</holderShip>         </personEvent>       </personsEvent>       <language>es</language>     </ApplicantInfoEvent>   </ApplicantsInfoEvent>   <documentsEvent>     <documentEvent>       <oid>09f424018087eb4e</oid>       <roleId>ejgv_d_aval.0.ejgv_reg_0005</roleId>       <roleNameEs>Acreditacin de capacidad financiera (Aval o seguro de caucin)</roleNameEs>       <roleNameEu>Finantza-gaitasunaren egiaztagiria</roleNameEu>       <sourceName>report.pdf</sourceName>       <documentType>DAD</documentType>       <extension>pdf</extension>       <format>E</format>       <location>09f424018087eb4e</location>       <signaturesEvent/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Acreditacin de capacidad financiera (Aval o seguro de caucin)</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>CIUDADANO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>99999990S</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap1_titularoaport</name>           <value>FICTICIO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap2_titularoaport</name>           <value>ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>DNI</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid>09f424018087eb4f</oid>       <roleId>ejgv_d_contratopriv.0.ejgv_reg_0009</roleId>       <roleNameEs>Copia contrato entidades aseguradoras vinculadas</roleNameEs>       <roleNameEu>Lotutako aseguru-erakundeen kontratua</roleNameEu>       <sourceName>11.pdf</sourceName>       <documentType>DAD</documentType>       <extension>pdf</extension>       <format>E</format>       <location>09f424018087eb4f</location>       <signaturesEvent/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Copia contrato entidades aseguradoras vinculadas</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>CIUDADANO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>99999990S</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap1_titularoaport</name>           <value>FICTICIO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap2_titularoaport</name>           <value>ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>DNI</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid>09f424018087eb50</oid>       <roleId>ejgv_d_escritura.0.r02d8515A2ECC1D7F2376582B45FC3E3326B8F22D30E</roleId>       <roleNameEs>Memoria de Actividades</roleNameEs>       <roleNameEu>Jardueren memoria</roleNameEu>       <sourceName>report (1).pdf</sourceName>       <documentType>DAD</documentType>       <extension>pdf</extension>       <format>E</format>       <location>09f424018087eb50</location>       <signaturesEvent/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Memoria de Actividades</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>CIUDADANO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>99999990S</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap1_titularoaport</name>           <value>FICTICIO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap2_titularoaport</name>           <value>ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>DNI</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid>09f424018087eb80</oid>       <roleId>ejgv_d_contratopriv.0.ejgv_reg_0009</roleId>       <roleNameEs>Copia contrato entidades aseguradoras vinculadas</roleNameEs>       <roleNameEu>Lotutako aseguru-erakundeen kontratua</roleNameEu>       <sourceName>Usuarios por grupo.pdf</sourceName>       <documentType>DAD</documentType>       <extension>pdf</extension>       <format>E</format>       <location>09f424018087eb80</location>       <signaturesEvent/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Copia contrato entidades aseguradoras vinculadas</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>CIUDADANO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>99999990S</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap1_titularoaport</name>           <value>FICTICIO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap2_titularoaport</name>           <value>ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>DNI</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid>09f424018087eb51</oid>       <roleId>ejgv_d_solicitud.0.0</roleId>       <roleNameEs>Solicitud</roleNameEs>       <roleNameEu>Eskabide</roleNameEu>       <sourceName>Solicitud.html</sourceName>       <documentType>PRE</documentType>       <extension>html</extension>       <format>E</format>       <sourceBinary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sourceBinary>       <signaturesEvent>         <signatureEvent>           <signEvent>             <ejgvDocumentEvent>               <headerEvent>                 <type>xades</type>                 <version>2.0</version>                 <placement>enveloped</placement>                 <flags>0</flags>                 <format>ES-T</format>               </headerEvent>               <bodyEvent>                 <sign>PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPGh0bWw+CiAgIAo8IS0tIGVqZ3ZEb2N1bWVudDw/eG1sIHZlcnNpb249JzEuMCcgZW5jb2Rpbmc9J0lTTy04ODU5LTEnPz48ZWpndkRvY3VtZW50PjxoZWFkZXI+PHR5cGU+QVBQTElDQVRJT048L3R5cGU+PHZlcnNpb24+MS4wPC92ZXJzaW9uPjxmbGFncz4wPC9mbGFncz48L2hlYWRlcj48Ym9keT48YmFzaWNJbmZvPjxwcm9jZWR1cmVJRD4wMDA5NDAyPC9wcm9jZWR1cmVJRD48cHJvY2VkdXJlTmFtZT48ZGVzY3JpcHRpb24+PGxhbmd1YWdlIGxvY2FsZT0nZXUnPjwhW0NEQVRBW0FzZWd1cnUtYXJ0ZWthcmllbiBlcnJlZ2lzdHJvYW4gaW5za3JpYmF0emVhXV0+PC9sYW5ndWFnZT48bGFuZ3VhZ2UgbG9jYWxlPSdlcyc+PCFbQ0RBVEFbSW5zY3JpcGNpw7NuIGVuIGVsIHJlZ2lzdHJvIGRlIG1lZGlhZG9yZXMgZGUgc2VndXJvc11dPjwvbGFuZ3VhZ2U+PC9kZXNjcmlwdGlvbj48L3Byb2NlZHVyZU5hbWU+PGRlcGFydG1lbnRJRD41NjwvZGVwYXJ0bWVudElEPjxtYW5hZ2luZ1VuaXRJRD4yMjg0PC9tYW5hZ2luZ1VuaXRJRD48ZW50aXR5SUQ+MDQ4MzMwMDE8L2VudGl0eUlEPjxkZXBhcnRtZW50TmFtZT48ZGVzY3JpcHRpb24+PGxhbmd1YWdlIGxvY2FsZT0nZXUnPjwhW0NEQVRBW09HQVNVTkEgRVRBIEVLT05PTUlBXV0+PC9sYW5ndWFnZT48bGFuZ3VhZ2UgbG9jYWxlPSdlcyc+PCFbQ0RBVEFbSEFDSUVOREEgWSBFQ09OT03DjUFdXT48L2xhbmd1YWdlPjwvZGVzY3JpcHRpb24+PC9kZXBhcnRtZW50TmFtZT48bWFuYWdpbmdVbml0TmFtZT48ZGVzY3JpcHRpb24+PGxhbmd1YWdlIGxvY2FsZT0nZXUnPjwhW0NEQVRBW0ZJTkFOVFpBIFBPTElUSUtBS08gRVRBIEVSQUtVTkRFRU4gQkFMSUFCSURFRVRBS08gWlVaRU5EQVJJVFpBXV0+PC9sYW5ndWFnZT48bGFuZ3VhZ2UgbG9jYWxlPSdlcyc+PCFbQ0RBVEFbRElSRUNDScOTTiBERSBQT0zDjVRJQ0EgRklOQU5DSUVSQSBZIFJFQ1VSU09TIElOU1RJVFVDSU9OQUxFU11dPjwvbGFuZ3VhZ2U+PC9kZXNjcmlwdGlvbj48L21hbmFnaW5nVW5pdE5hbWU+PGVudGl0eU5hbWU+PGRlc2NyaXB0aW9uPjxsYW5ndWFnZSBsb2NhbGU9J2V1Jz48IVtDREFUQVtFQUVrbyBBZG1pbmlzdHJhemlvIFB1Ymxpa29hXV0+PC9sYW5ndWFnZT48bGFuZ3VhZ2UgbG9jYWxlPSdlcyc+PCFbQ0RBVEFbQWRtaW5pc3RyYWNpw7NuIFDDumJsaWNhIGRlIGxhIENBRV1dPjwvbGFuZ3VhZ2U+PC9kZXNjcmlwdGlvbj48L2VudGl0eU5hbWU+PC9iYXNpY0luZm8+PEFwcGxpY2FudEluZm8+PHBlcnNvbnM+PHBlcnNvbj48aG9sZGVyU2hpcD5IT0xERVI8L2hvbGRlclNoaXA+PHBlcnNvblR5cGU+MTwvcGVyc29uVHlwZT48aWQ+OTk5OTk5OTBTPC9pZD48bmFtZT5DSVVEQURBTk88L25hbWU+PGFwZTE+RklDVElDSU88L2FwZTE+PGFwZTI+QUNUSVZPPC9hcGUyPjxjb250YWN0cy8+PC9wZXJzb24+PC9wZXJzb25zPjxub3RpZmljYXRpb24+PGFkZHJlc3NlZT48YWRkcmVzc2VlSUQ+OTk5OTk5OTBTPC9hZGRyZXNzZWVJRD48YWRkcmVzc2VlTmFtZT5DSVVEQURBTk8gRklDVElDSU8gQUNUSVZPPC9hZGRyZXNzZWVOYW1lPjwvYWRkcmVzc2VlPjxjaGFubmVsPjxjaGFubmVsVHlwZT5FTEVDVFJPTklDPC9jaGFubmVsVHlwZT48Y2hhbm5lbEluZm8+PGVsZWN0cm9uaWNBZGRyZXNzPjwvZWxlY3Ryb25pY0FkZHJlc3M+PC9jaGFubmVsSW5mbz48L2NoYW5uZWw+PC9ub3RpZmljYXRpb24+PGxhbmd1YWdlPmVzPC9sYW5ndWFnZT48L0FwcGxpY2FudEluZm8+PGRldGFpbEluZm8+PGRlY2xhcmFjaW9uZXNSZXNwb3NhYmxlcz48Z3J1cG9fZGVjbGFyYWNpb25lcz48ZGVjbGFyYWNpb25lc1Jlc3BvbnNhYmxlcz48Z3J1cG9EZWNsYXJhY1Jlc3RvPjxkZWNsYXJhY2lvbl9lc3BlY2lmaWNhMTE+PGVsZW1lbnRvZGVjbGFyYWNpb25fZXNwZWNpZmljYTExPjE8L2VsZW1lbnRvZGVjbGFyYWNpb25fZXNwZWNpZmljYTExPjwvZGVjbGFyYWNpb25fZXNwZWNpZmljYTExPjxkZWNsYXJhY2lvbl9lc3BlY2lmaWNhMTA+PGVsZW1lbnRvZGVjbGFyYWNpb25fZXNwZWNpZmljYTEwPjE8L2VsZW1lbnRvZGVjbGFyYWNpb25fZXNwZWNpZmljYTEwPjwvZGVjbGFyYWNpb25fZXNwZWNpZmljYTEwPjwvZ3J1cG9EZWNsYXJhY1Jlc3RvPjxncnVwb0RlY2xhcmFjSG9ub3JhYmlsaWRhZD48ZGVjbGFyYWNpb25fZXNwZWNpZmljYTk+PGVsZW1lbnRvZGVjbGFyYWNpb25fZXNwZWNpZmljYTk+MTwvZWxlbWVudG9kZWNsYXJhY2lvbl9lc3BlY2lmaWNhOT48L2RlY2xhcmFjaW9uX2VzcGVjaWZpY2E5PjxkZWNsYXJhY2lvbl9lc3BlY2lmaWNhOD48ZWxlbWVudG9kZWNsYXJhY2lvbl9lc3BlY2lmaWNhOD4xPC9lbGVtZW50b2RlY2xhcmFjaW9uX2VzcGVjaWZpY2E4PjwvZGVjbGFyYWNpb25fZXNwZWNpZmljYTg+PGRlY2xhcmFjaW9uX2VzcGVjaWZpY2E3PjxlbGVtZW50b2RlY2xhcmFjaW9uX2VzcGVjaWZpY2E3PjE8L2VsZW1lbnRvZGVjbGFyYWNpb25fZXNwZWNpZmljYTc+PC9kZWNsYXJhY2lvbl9lc3BlY2lmaWNhNz48ZGVjbGFyYWNpb25fZXNwZWNpZmljYTY+PGVsZW1lbnRvZGVjbGFyYWNpb25fZXNwZWNpZmljYTY+MTwvZWxlbWVudG9kZWNsYXJhY2lvbl9lc3BlY2lmaWNhNj48L2RlY2xhcmFjaW9uX2VzcGVjaWZpY2E2PjxkZWNsYXJhY2lvbl9lc3BlY2lmaWNhNT48ZWxlbWVudG9kZWNsYXJhY2lvbl9lc3BlY2lmaWNhNT4xPC9lbGVtZW50b2RlY2xhcmFjaW9uX2VzcGVjaWZpY2E1PjwvZGVjbGFyYWNpb25fZXNwZWNpZmljYTU+PGRlY2xhcmFjaW9uX2VzcGVjaWZpY2E0PjxlbGVtZW50b2RlY2xhcmFjaW9uX2VzcGVjaWZpY2E0PjE8L2VsZW1lbnRvZGVjbGFyYWNpb25fZXNwZWNpZmljYTQ+PC9kZWNsYXJhY2lvbl9lc3BlY2lmaWNhND48ZGVjbGFyYWNpb25fZXNwZWNpZmljYTM+PGVsZW1lbnRvZGVjbGFyYWNpb25fZXNwZWNpZmljYTM+MTwvZWxlbWVudG9kZWNsYXJhY2lvbl9lc3BlY2lmaWNhMz48L2RlY2xhcmFjaW9uX2VzcGVjaWZpY2EzPjxkZWNsYXJhY2lvbl9lc3BlY2lmaWNhMj48ZWxlbWVudG9kZWNsYXJhY2lvbl9lc3BlY2lmaWNhMj4xPC9lbGVtZW50b2RlY2xhcmFjaW9uX2VzcGVjaWZpY2EyPjwvZGVjbGFyYWNpb25fZXNwZWNpZmljYTI+PC9ncnVwb0RlY2xhcmFjSG9ub3JhYmlsaWRhZD48YmFuY2FKdXJpZGljbz48L2JhbmNhSnVyaWRpY28+PGFnZW50ZVZpbmN1bGFkb0p1cmlkaWNvPjwvYWdlbnRlVmluY3VsYWRvSnVyaWRpY28+PGNvcnJlZG9yU2VndXJvc0p1cmlkaWNvPjwvY29ycmVkb3JTZWd1cm9zSnVyaWRpY28+PC9kZWNsYXJhY2lvbmVzUmVzcG9uc2FibGVzPjwvZ3J1cG9fZGVjbGFyYWNpb25lcz48L2RlY2xhcmFjaW9uZXNSZXNwb3NhYmxlcz48cGFydGljaXBhY2lvblNpZ25pZmljYXRpdmE+PG9yZ2Fub1Jlc3BvbnNhYmxlPjwvb3JnYW5vUmVzcG9uc2FibGU+PGFkbWluaXN0cmFkb3Jlcz48L2FkbWluaXN0cmFkb3Jlcz48c29jaW9zUGFydGljaXBhbnRlcz48Y2FwaXRhbFNvY2lhbEFjY2lvbmVzQ2FtcG8+PC9jYXBpdGFsU29jaWFsQWNjaW9uZXNDYW1wbz48Y2FwaXRhbFNvY2lhbEltcG9ydGVDYW1wbz48L2NhcGl0YWxTb2NpYWxJbXBvcnRlQ2FtcG8+PC9zb2Npb3NQYXJ0aWNpcGFudGVzPjwvcGFydGljaXBhY2lvblNpZ25pZmljYXRpdmE+PGNhcGFjaWRhZEZpbmFuY2llcmE+PGNhbGN1bG9DYXBhY2lkYWRGaW5hbmNpZXJhPjxjb250cmF0YUF2YWw+PGNvbnRyYXRhU2VndXJvPmNhdWNpw7NuPC9jb250cmF0YVNlZ3Vybz48c2VndXJvPjxlbGVtZW50b3NlZ3Vybz4yPC9lbGVtZW50b3NlZ3Vybz48L3NlZ3Vybz48YXZhbENhbXBvPjwvYXZhbENhbXBvPjxhdmFsPjwvYXZhbD48L2NvbnRyYXRhQXZhbD48aW1wb3J0ZUNhcGFjaWRhZD4xODc2MDwvaW1wb3J0ZUNhcGFjaWRhZD48aW1wb3J0ZUN1YXRyb1BvcmNpZW50bz4xMjAwMDwvaW1wb3J0ZUN1YXRyb1BvcmNpZW50bz48aW1wb3J0ZUZvbmRvc1BlcmRpZG9zPjMwMDAwMDwvaW1wb3J0ZUZvbmRvc1BlcmRpZG9zPjwvY2FsY3Vsb0NhcGFjaWRhZEZpbmFuY2llcmE+PC9jYXBhY2lkYWRGaW5hbmNpZXJhPjxkYXRvc01lZGlhZG9yPjxjYXBhY2lkYWQ+PGRlY2xhcm9jYXBhY2lkYWQ+MTwvZGVjbGFyb2NhcGFjaWRhZD48L2NhcGFjaWRhZD48ZW1wcmVzYXN2aW5jdWxhZGFzPjxlbXByZXNhc1ZpbmN1bGFkYXNHUj48ZWxlbWVudG9HUj48ZGVub21pbmFjaW9uRW1wcmVzYT5iaWxiYW88L2Rlbm9taW5hY2lvbkVtcHJlc2E+PGRncz5DMDAyNjwvZGdzPjxjaWY+ICBBNDgwMDE2NDg8L2NpZj48L2VsZW1lbnRvR1I+PGVsZW1lbnRvR1I+PGRlbm9taW5hY2lvbkVtcHJlc2E+c2FudGFuZGVyPC9kZW5vbWluYWNpb25FbXByZXNhPjxkZ3M+QzAwMzc8L2Rncz48Y2lmPkE0NjAwMzI3MzwvY2lmPjwvZWxlbWVudG9HUj48L2VtcHJlc2FzVmluY3VsYWRhc0dSPjwvZW1wcmVzYXN2aW5jdWxhZGFzPjxhY2Npb25pc3Rhc1BhcnRpY2lwZXM+PC9hY2Npb25pc3Rhc1BhcnRpY2lwZXM+PE9yZ2Fub0RpcmVjY2lvbj48L09yZ2Fub0RpcmVjY2lvbj48YXR0Y2xpZW50ZT48ZGF0b3NkZWZlbnNvckNsaWVudGU+PERuaURlZmVuc29yPjwvRG5pRGVmZW5zb3I+PFRpcG9EbmlEZWZlbnNvcj48L1RpcG9EbmlEZWZlbnNvcj48QXBlMkRlZmVuc29yPjwvQXBlMkRlZmVuc29yPjxBcGUxRGVmZW5zb3JyPjwvQXBlMURlZmVuc29ycj48Tm9tYnJlRGVmZW5zb3I+PC9Ob21icmVEZWZlbnNvcj48L2RhdG9zZGVmZW5zb3JDbGllbnRlPjxkYXRvc3RpdHVsYXJTZXJ2aWNpb0F0dD48RG5pPjwvRG5pPjxUaXBvRG5pPjwvVGlwb0RuaT48QXBlMlRpdHVsYXI+PC9BcGUyVGl0dWxhcj48QXBlMVRpdHVsYXI+PC9BcGUxVGl0dWxhcj48Tm9tYnJlVGl0dWxhcj48L05vbWJyZVRpdHVsYXI+PC9kYXRvc3RpdHVsYXJTZXJ2aWNpb0F0dD48YXRlbmNpb25jbGllbnRlPjwvYXRlbmNpb25jbGllbnRlPjwvYXR0Y2xpZW50ZT48dGlwb01lZGlhZG9yVmFsb3IyPjE8L3RpcG9NZWRpYWRvclZhbG9yMj48dGlwb01lZGlhZG9yVmFsb3IxPjA8L3RpcG9NZWRpYWRvclZhbG9yMT48ZGlyZWNjaW9uQWN0aXZpZGFkPjxDYW1wb0Jhc2ljb3dlYj53d3cucHJ1ZWJhLmNvbTwvQ2FtcG9CYXNpY293ZWI+PENhbXBvQmFzaWNvZW1haWw+cHJ1QGdtYWlsLmNvbTwvQ2FtcG9CYXNpY29lbWFpbD48Q2FtcG9CYXNpY29UZm5vPjk0NTQ0NTU2NjwvQ2FtcG9CYXNpY29UZm5vPjxDYW1wb0Jhc2ljb0NwPjAxMTIzPC9DYW1wb0Jhc2ljb0NwPjxDYW1wb0Jhc2ljb0xldHJhPjwvQ2FtcG9CYXNpY29MZXRyYT48Q2FtcG9CYXNpY29QaXNvPmJham88L0NhbXBvQmFzaWNvUGlzbz48Q2FtcG9CYXNpY29Qb3J0YWw+MzwvQ2FtcG9CYXNpY29Qb3J0YWw+PENhbXBvQmFzaWNvQ2FsbGU+QVFBQUEga2FsZWE8L0NhbXBvQmFzaWNvQ2FsbGU+PGxpc3RhTXVuaWNpcGlvPjAwMjwvbGlzdGFNdW5pY2lwaW8+PGxpc3RhUHJvdmluY2lhPjAxPC9saXN0YVByb3ZpbmNpYT48L2RpcmVjY2lvbkFjdGl2aWRhZD48R3J1cG90aXBvbWVkaWFkb3I+PHRpcG9ETkkxMk1lZGlhZG9yMTM+U0k8L3RpcG9ETkkxMk1lZGlhZG9yMTM+PHRpcG9ETkkxMk1lZGlhZG9yMTM0PlNJPC90aXBvRE5JMTJNZWRpYWRvcjEzND48dGlwb0ROSTEyTWVkaWFkb3IxMjM0PlNJPC90aXBvRE5JMTJNZWRpYWRvcjEyMzQ+PHRpcG9NZWRpYWRvcjU2Pk5PPC90aXBvTWVkaWFkb3I1Nj48dGlwb01lZGlhZG9yMTM+U0k8L3RpcG9NZWRpYWRvcjEzPjx0aXBvTWVkaWFkb3IzND5OTzwvdGlwb01lZGlhZG9yMzQ+PHRpcG9NZWRpYWRvcjEzND5TSTwvdGlwb01lZGlhZG9yMTM0Pjx0aXBvTWVkaWFkb3IxMjM0PlNJPC90aXBvTWVkaWFkb3IxMjM0PjxMaXN0YXRpcG9NZWRpYWRvcj4xPC9MaXN0YXRpcG9NZWRpYWRvcj48L0dydXBvdGlwb21lZGlhZG9yPjxkZWNsYXJhY2lvbkFtYml0b1RlcnJpdG9yaWFsPjxhbWJpdG8+PGVsZW1lbnRvYW1iaXRvPjE8L2VsZW1lbnRvYW1iaXRvPjwvYW1iaXRvPjwvZGVjbGFyYWNpb25BbWJpdG9UZXJyaXRvcmlhbD48L2RhdG9zTWVkaWFkb3I+PGRhdG9zQmFzaWNvcz48ZGF0b3NBdmlzbz48cmFkaW9FbGVnaXJEYXRvc0F2aXNvPjE8L3JhZGlvRWxlZ2lyRGF0b3NBdmlzbz48L2RhdG9zQXZpc28+PGRhdG9zUGVyc29uYWxlcz48ZGF0b3NyZXByZXNlbnRhdGl2ZTE+PHJlcHJlc2VudGF0aXZlMVNleG8+PC9yZXByZXNlbnRhdGl2ZTFTZXhvPjwvZGF0b3NyZXByZXNlbnRhdGl2ZTE+PGhvbGRlcjFTZXhvPjwvaG9sZGVyMVNleG8+PHRpcG9ETkkxMj5TSTwvdGlwb0ROSTEyPjwvZGF0b3NQZXJzb25hbGVzPjxkYXRvc09yZ2Fub0dlc3Rvcj48bWFuYWdpbmdVbml0TmFtZT5ESVJFQ0NJw5NOIERFIFBPTMONVElDQSBGSU5BTkNJRVJBIFkgUkVDVVJTT1MgSU5TVElUVUNJT05BTEVTPC9tYW5hZ2luZ1VuaXROYW1lPjwvZGF0b3NPcmdhbm9HZXN0b3I+PC9kYXRvc0Jhc2ljb3M+PC9kZXRhaWxJbmZvPjxzZW5kZXI+PGlkPjk5OTk5OTkwUzwvaWQ+PG5hbWU+Q0lVREFEQU5PIEZJQ1RJQ0lPIEFDVElWTzwvbmFtZT48L3NlbmRlcj48L2JvZHk+PGF0dGFjaG1lbnRzPjxhdHRhY2htZW50PjxJRD4wOWY0MjQwMTgwODdlYjRlPC9JRD48aGFzaD50cEhuaWhlMVpqM0lSb1QzUUhFcW9PcmFZZFU9PC9oYXNoPjxjb2RlPmVsZWN0cm9uaWNEb2N1bWVudDwvY29kZT48cm9sZUlkPmVqZ3ZfZF9hdmFsLjAuZWpndl9yZWdfMDAwNTwvcm9sZUlkPjxyb2xlTmFtZT48ZGVzY3JpcHRpb24+PGxhbmd1YWdlIGxvY2FsZT0nZXUnPjwhW0NEQVRBW0ZpbmFudHphLWdhaXRhc3VuYXJlbiBlZ2lhenRhZ2lyaWFdXT48L2xhbmd1YWdlPjxsYW5ndWFnZSBsb2NhbGU9J2VzJz48IVtDREFUQVtBY3JlZGl0YWNpw7NuIGRlIGNhcGFjaWRhZCBmaW5hbmNpZXJhIChBdmFsIG8gc2VndXJvIGRlIGNhdWNpw7NuKV1dPjwvbGFuZ3VhZ2U+PC9kZXNjcmlwdGlvbj48L3JvbGVOYW1lPjxzb3VyY2VOYW1lPnJlcG9ydC5wZGY8L3NvdXJjZU5hbWU+PC9hdHRhY2htZW50PjxhdHRhY2htZW50PjxJRD4wOWY0MjQwMTgwODdlYjRmPC9JRD48aGFzaD5EZDhTZGJuK2lyMEpYRmVoTnlqWUJkT0ZPM2s9PC9oYXNoPjxjb2RlPmVsZWN0cm9uaWNEb2N1bWVudDwvY29kZT48cm9sZUlkPmVqZ3ZfZF9jb250cmF0b3ByaXYuMC5lamd2X3JlZ18wMDA5PC9yb2xlSWQ+PHJvbGVOYW1lPjxkZXNjcmlwdGlvbj48bGFuZ3VhZ2UgbG9jYWxlPSdldSc+PCFbQ0RBVEFbTG90dXRha28gYXNlZ3VydS1lcmFrdW5kZWVuIGtvbnRyYXR1YV1dPjwvbGFuZ3VhZ2U+PGxhbmd1YWdlIGxvY2FsZT0nZXMnPjwhW0NEQVRBW0NvcGlhIGNvbnRyYXRvIGVudGlkYWRlcyBhc2VndXJhZG9yYXMgdmluY3VsYWRhc11dPjwvbGFuZ3VhZ2U+PC9kZXNjcmlwdGlvbj48L3JvbGVOYW1lPjxzb3VyY2VOYW1lPjExLnBkZjwvc291cmNlTmFtZT48L2F0dGFjaG1lbnQ+PGF0dGFjaG1lbnQ+PElEPjA5ZjQyNDAxODA4N2ViNTA8L0lEPjxoYXNoPjdUN0MvajYvRjNGUTdsTEE2M2J3WEJjUlI2az08L2hhc2g+PGNvZGU+ZWxlY3Ryb25pY0RvY3VtZW50PC9jb2RlPjxyb2xlSWQ+ZWpndl9kX2VzY3JpdHVyYS4wLnIwMmQ4NTE1QTJFQ0MxRDdGMjM3NjU4MkI0NUZDM0UzMzI2QjhGMjJEMzBFPC9yb2xlSWQ+PHJvbGVOYW1lPjxkZXNjcmlwdGlvbj48bGFuZ3VhZ2UgbG9jYWxlPSdldSc+PCFbQ0RBVEFbSmFyZHVlcmVuIG1lbW9yaWFdXT48L2xhbmd1YWdlPjxsYW5ndWFnZSBsb2NhbGU9J2VzJz48IVtDREFUQVtNZW1vcmlhIGRlIEFjdGl2aWRhZGVzXV0+PC9sYW5ndWFnZT48L2Rlc2NyaXB0aW9uPjwvcm9sZU5hbWU+PHNvdXJjZU5hbWU+cmVwb3J0ICgxKS5wZGY8L3NvdXJjZU5hbWU+PC9hdHRhY2htZW50PjxhdHRhY2htZW50PjxJRD4wOWY0MjQwMTgwODdlYjgwPC9JRD48aGFzaD4vUzYxUG9qcW85enNaTFd5UTRBaWJJR3RmQXM9PC9oYXNoPjxjb2RlPmVsZWN0cm9uaWNEb2N1bWVudDwvY29kZT48cm9sZUlkPmVqZ3ZfZF9jb250cmF0b3ByaXYuMC5lamd2X3JlZ18wMDA5PC9yb2xlSWQ+PHJvbGVOYW1lPjxkZXNjcmlwdGlvbj48bGFuZ3VhZ2UgbG9jYWxlPSdldSc+PCFbQ0RBVEFbTG90dXRha28gYXNlZ3VydS1lcmFrdW5kZWVuIGtvbnRyYXR1YV1dPjwvbGFuZ3VhZ2U+PGxhbmd1YWdlIGxvY2FsZT0nZXMnPjwhW0NEQVRBW0NvcGlhIGNvbnRyYXRvIGVudGlkYWRlcyBhc2VndXJhZG9yYXMgdmluY3VsYWRhc11dPjwvbGFuZ3VhZ2U+PC9kZXNjcmlwdGlvbj48L3JvbGVOYW1lPjxzb3VyY2VOYW1lPlVzdWFyaW9zIHBvciBncnVwby5wZGY8L3NvdXJjZU5hbWU+PC9hdHRhY2htZW50PjwvYXR0YWNobWVudHM+PC9lamd2RG9jdW1lbnQ+ZWpndkRvY3VtZW50IC0tPgo8aGVhZD48bWV0YSBjb250ZW50PSJ0ZXh0L2h0bWw7Y2hhcnNldD1JU08tODg1OS0xIiBodHRwLWVxdWl2PSJDb250ZW50LXR5cGUiLz4KPGRpdiBzdHlsZT0iZGlzcGxheTogbm9uZTsiPgo8cCBpZD0ic2lnbmF0dXJlUGxhY2UiPjxkczpTaWduYXR1cmUgSWQ9IlNpZ25hdHVyZS0xNTA1ODkwMTMyMzg1IiB4bWxuczpkcz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC8wOS94bWxkc2lnIyI+CjxkczpTaWduZWRJbmZvIElkPSJTaWduZWRJbmZvLTE1MDU4OTAxMzIzODUiPgo8ZHM6Q2Fub25pY2FsaXphdGlvbk1ldGhvZCBBbGdvcml0aG09Imh0dHA6Ly93d3cudzMub3JnL1RSLzIwMDEvUkVDLXhtbC1jMTRuLTIwMDEwMzE1Ii8+CjxkczpTaWduYXR1cmVNZXRob2QgQWxnb3JpdGhtPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwLzA5L3htbGRzaWcjcnNhLXNoYTEiLz4KPGRzOlJlZmVyZW5jZSBVUkk9IiNLZXlJbmZvLTE1MDU4OTAxMzIzODUiPgo8ZHM6RGlnZXN0TWV0aG9kIEFsZ29yaXRobT0iaHR0cDovL3d3dy53My5vcmcvMjAwMC8wOS94bWxkc2lnI3NoYTEiLz4KPGRzOkRpZ2VzdFZhbHVlPlNWRGh4VFFrNkVHNHFxVUdEaVRxQlg2QzNLUT08L2RzOkRpZ2VzdFZhbHVlPgo8L2RzOlJlZmVyZW5jZT4KPGRzOlJlZmVyZW5jZSBJZD0iU2lnbmF0dXJlLTE1MDU4OTAxMzIzODUtU2lnbmVkUHJvcGVydGllcy1SZWYiIFR5cGU9Imh0dHA6Ly91cmkuZXRzaS5vcmcvMDE5MDMjU2lnbmVkUHJvcGVydGllcyIgVVJJPSIjU2lnbmF0dXJlLTE1MDU4OTAxMzIzODUtU2lnbmVkUHJvcGVydGllcyI+CjxkczpUcmFuc2Zvcm1zPgo8ZHM6VHJhbnNmb3JtIEFsZ29yaXRobT0iaHR0cDovL3d3dy53My5vcmcvVFIvMjAwMS9SRUMteG1sLWMxNG4tMjAwMTAzMTUiLz4KPC9kczpUcmFuc2Zvcm1zPgo8ZHM6RGlnZXN0TWV0aG9kIEFsZ29yaXRobT0iaHR0cDovL3d3dy53My5vcmcvMjAwMC8wOS94bWxkc2lnI3NoYTEiLz4KPGRzOkRpZ2VzdFZhbHVlPisyQkRwQWY5QUkxYi9rVjIvNFByNG5lZHVsMD08L2RzOkRpZ2VzdFZhbHVlPgo8L2RzOlJlZmVyZW5jZT4KPGRzOlJlZmVyZW5jZSBVUkk9IiN4cG9pbnRlcigvKSI+CjxkczpUcmFuc2Zvcm1zPgo8ZHM6VHJhbnNmb3JtIEFsZ29yaXRobT0iaHR0cDovL3d3dy53My5vcmcvMjAwMC8wOS94bWxkc2lnI2VudmVsb3BlZC1zaWduYXR1cmUiLz4KPGRzOlRyYW5zZm9ybSBBbGdvcml0aG09Imh0dHA6Ly93d3cudzMub3JnL1RSLzIwMDEvUkVDLXhtbC1jMTRuLTIwMDEwMzE1I1dpdGhDb21tZW50cyIvPgo8L2RzOlRyYW5zZm9ybXM+CjxkczpEaWdlc3RNZXRob2QgQWxnb3JpdGhtPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwLzA5L3htbGRzaWcjc2hhMSIvPgo8ZHM6RGlnZXN0VmFsdWU+QVZ5cU96bWpjbnNsbEd5eG9sOEJhN2lOZ3M0PTwvZHM6RGlnZXN0VmFsdWU+CjwvZHM6UmVmZXJlbmNlPgo8L2RzOlNpZ25lZEluZm8+CjxkczpTaWduYXR1cmVWYWx1ZSBJZD0iRG9jdW1lbnRTaWduYXR1cmVWYWx1ZS0xNTA1ODkwMTMyMzg1Ij4KcVA0MU9BUldGOFIrb0NxblhpRG9UM2txbVhML3h4V280T1gzSWVxSFdxSU9nYkVjNFRkWng3WCtsWS9LNjZyUTJwSE9WREQ1RGFBMwozR2NOS0VUb1ZneXJGbWpLb0ZTQWpoRWhPYm1NOW1CR2RjTGszenVMVndtUlZFdmlXRWVmZXQwWkxFV3FUWUFvN0NQeEJObzlqSUtOCnBVRTJOcUEyUEpmRlpialRSeTRlTStOeWgraXBUYU41TnhUWW40d2JsV1R3QTYyNU9RNFJPRnROY2V6TDdqei90VXJGQ3F3aTd0ZVgKNFY5ZFVCTzkrd241MTVuZUt1SC9Ja3dwU2djTHZWNFhzYks5WGFpZmsrT3YwZzlTVk9iU2N2S3F3UGNYN28vNDV3cmJ2NmgyczJDWgpkcUxSbGxrWVI3Z3licm9odHU0MFRLclQ1a1RJMHNQWWRrd1hYUT09CjwvZHM6U2lnbmF0dXJlVmFsdWU+CjxkczpLZXlJbmZvIElkPSJLZXlJbmZvLTE1MDU4OTAxMzIzODUiPgo8ZHM6WDUwOURhdGE+CjxkczpYNTA5Q2VydGlmaWNhdGU+Ck1JSUk5RENDQnR5Z0F3SUJBZ0lDRVMwd0RRWUpLb1pJaHZjTkFRRUxCUUF3Z1pjeEN6QUpCZ05WQkFZVEFrVlRNUlF3RWdZRFZRUUsKREF0SldrVk9VRVVnVXk1QkxqRTZNRGdHQTFVRUN3d3hUbHBhSUZwcGRYSjBZV2RwY21rZ2NIVmliR2xyYjJFZ0xTQkRaWEowYVdacApZMkZrYnlCd2RXSnNhV052SUZORFNURTJNRFFHQTFVRUF3d3RRMEVnWkdVZ1EybDFaR0ZrWVc1dmN5QjVJRVZ1ZEdsa1lXUmxjeUFvCk5Da2dMU0JFUlZOQlVsSlBURXhQTUI0WERURTNNRE14TkRFMU5UYzFPRm9YRFRJeE1ETXhOREUxTlRjMU9Gb3dnZ0U2TVFzd0NRWUQKVlFRR0V3SkZVekUwTURJR0ExVUVDd3dyV21sMWNuUmhaMmx5YVNCdmJtRnlkSFZoSUMwZ1EyVnlkR2xtYVdOaFpHOGdjbVZqYjI1dgpZMmxrYnpFNE1EWUdBMVVFQ3d3dlNHVnljbWwwWVhJZ2VtbDFjblJoWjJseWFXRWdMU0JEWlhKMGFXWnBZMkZrYnlCa1pTQmphWFZrCllXUmhibTh4UXpCQkJnTlZCQXNNT2tOdmJtUnBZMmx2Ym1WeklHUmxJSFZ6YnlCbGJpQjNkM2N1YVhwbGJuQmxMbU52YlNCdWIyeGgKSUdWeVlXSnBiR2tnYW1GcmFYUmxhMjh4RnpBVkJnTlZCQzRURGkxa2Jta2dPVGs1T1RrNU9UQlRNU0l3SUFZRFZRUUREQmxEU1ZWRQpRVVJCVGs4Z1JrbERWRWxEU1U4Z1FVTlVTVlpQTVJJd0VBWURWUVFxREFsRFNWVkVRVVJCVGs4eEVUQVBCZ05WQkFRTUNFWkpRMVJKClEwbFBNUkl3RUFZRFZRUUZFd2s1T1RrNU9UazVNRk13Z2dFaU1BMEdDU3FHU0liM0RRRUJBUVVBQTRJQkR3QXdnZ0VLQW9JQkFRQzYKc3FJTnNocjRKV1RCRUdKSTg0U1dmTkNxdzVXbmNtU0wycEREelpSemk5VFNXWk9SRXBYSmFST0VtVStPTERzYlNLQjMwS2RjZnBlVApKSDNiZGdRejdidDhySXIxZm9YaTd6TzVHODUyMEhKeENZWU4vdTdQQTNkWmJEN2Z3QzBsdkpEOUhmK0d4MlFVODZ0em81TU14NldsCmRpYk4yN29XK1ZKeEhEajM0QndlSXp3ZEl6RmFzMzFYdHZKODJJektZL0VpRzdoZVFsRVZKOWM5OWxvaUU2NFhBWnExeTBxbEtxR0YKL3Z5bDhzRnVZTWRmS3lTT1d2WjZzdlJZcEU5SW1iSTc2aWU0QzllNklqc0pqOTBabU5FRDlTRndjMlN2TXdkNExCcEpKMTR5RTk1aApjV3MvcjUzNDdDaEF2WjMxcldrOGlHQ2xlNm9kd1kxWjdlREhBZ01CQUFHamdnT2lNSUlEbmpDQnh3WURWUjBTQklHL01JRzhoaFZvCmRIUndPaTh2ZDNkM0xtbDZaVzV3WlM1amIyMkJEMmx1Wm05QWFYcGxibkJsTG1OdmJhU0JrVENCampGSE1FVUdBMVVFQ2d3K1NWcEYKVGxCRklGTXVRUzRnTFNCRFNVWWdRVEF4TXpNM01qWXdMVkpOWlhKakxsWnBkRzl5YVdFdFIyRnpkR1ZwZWlCVU1UQTFOU0JHTmpJZwpVemd4UXpCQkJnTlZCQWtNT2tGMlpHRWdaR1ZzSUUxbFpHbDBaWEp5WVc1bGJ5QkZkRzl5WW1sa1pXRWdNVFFnTFNBd01UQXhNQ0JXCmFYUnZjbWxoTFVkaGMzUmxhWG93RGdZRFZSMFBBUUgvQkFRREFnWGdNQjhHQTFVZEpRUVlNQllHQ0NzR0FRVUZCd01DQmdvckJnRUUKQVlJM0NnTU1NQjBHQTFVZERnUVdCQlNwVWlLMDhSQlF4ZUdkOVJwV3JNbHhpM2RnOERBZkJnTlZIU01FR0RBV2dCUnYvLzBOOGd4agpEeVp4WFJyZ2IyVmtaamhya3pDQ0FTa0dBMVVkSUFTQ0FTQXdnZ0VjTUlJQkRRWUpLd1lCQkFIek9XWUdNSUgvTUNVR0NDc0dBUVVGCkJ3SUJGaGxvZEhSd09pOHZkM2QzTG1sNlpXNXdaUzVqYjIwdlkzQnpNSUhWQmdnckJnRUZCUWNDQWpDQnlBeUJ4VUpsY20xbFpXNGcKYlhWbllXc2daWHBoWjNWMGVtVnJieUIzZDNjdWFYcGxibkJsTG1OdmJTQmFhWFZ5ZEdGbmFYSnBZVzRnYTI5dVptbGhiblI2WVNCcAplbUZ1SUdGMWNuSmxkR2xySUd0dmJuUnlZWFIxWVNCcGNtRnJkWEp5YVM0Z1RHbHRhWFJoWTJsdmJtVnpJR1JsSUdkaGNtRnVkR2xoCmN5QmxiaUIzZDNjdWFYcGxibkJsTG1OdmJTQkRiMjV6ZFd4MFpTQmxiQ0JqYjI1MGNtRjBieUJoYm5SbGN5QmtaU0JqYjI1bWFXRnkKSUdWdUlHVnNJR05sY25ScFptbGpZV1J2TUFrR0J3UUFpK3hBQVFJd05RWUlLd1lCQlFVSEFRRUVLVEFuTUNVR0NDc0dBUVVGQnpBQgpoaGxvZEhSd09pOHZiMk56Y0dSbGN5NXBlbVZ1Y0dVdVkyOXRNSUhFQmdnckJnRUZCUWNCQXdTQnR6Q0J0REFJQmdZRUFJNUdBUUV3CkNBWUdCQUNPUmdFRU1Bc0dCZ1FBamtZQkF3SUJEekI4QmdZRUFJNUdBUVV3Y2pBa0ZoNW9kSFJ3Y3pvdkwzZDNkeTVwZW1WdWNHVXUKWTI5dEwzQmtjeTlsYmk4VEFrVk9NQ1FXSG1oMGRIQnpPaTh2ZDNkM0xtbDZaVzV3WlM1amIyMHZjR1J6TDJWMUx4TUNSVlV3SkJZZQphSFIwY0hNNkx5OTNkM2N1YVhwbGJuQmxMbU52YlM5d1pITXZaWE12RXdKRlV6QVRCZ1lFQUk1R0FRWXdDUVlIQkFDT1JnRUdBVEEyCkJnTlZIUjhFTHpBdE1DdWdLYUFuaGlWb2RIUndPaTh2WTNKc1pHVnpMbWw2Wlc1d1pTNWpiMjB2WTJkcExXSnBiaTlqY213eU1BMEcKQ1NxR1NJYjNEUUVCQ3dVQUE0SUNBUUJzd2xYRmYxYng5UjUxakpxeUdvOVVJY3VYamw0SU9LN1kzcEFTMmY5YUdwbVgyTkQwVURCVApMcmZLYzY4T3hzalNhN25zYjN1V2QyVjVqWlVldEdOMFZJUFdLMkFnMXpwQ2ZmTWlrZm5CYzZMTFo5ZzNaR2NpeHdkVkI1NEozN1A5ClFiTGhDWmhzQ2VBZkVkaXJzaUY2bjhaRllXV0tDWTZmYTQ2cHRBUEFXVi9DR1EwTUM3THpaNjROOUhFUlFpdGNkNDJJVUVYbUtpRHIKdkFESkVlcjRSa0FrSWxPU0xtN2ROcFZWY1FjRktxa01IV3JGc3JNejdiL3ZRdUczU2loUzlNUHdkNHNGVXp0WWNKWFdNWTVmQytIQwpMUkdqMXErT25MY3pSSHJiR3p4MDJWVTFkdUlUYng4aXdUT3ZlVEhTbW5ESng3K2Zuc0tKeXFjVnRwYTBSeUdTZXE1WVFjakpELzBpClNvejlwakE1QTVLblpQMzgwV0NpS3RXSjVSUzhQKzlyUGNYRks3UTJiZlNBVlc0UElhWXVLT041WVorN2UrN3ZHTzMyb0VVanN6U0gKbEEra2hybGdEWVJUUThkZU03UUYxandWNzBEVEJJamNVTzJKMW5oNCtUOHcxWDk4ald6TzRGRFFjeEtPRWdMZmRScURtZWt5K2FZMwphM01CMVBmQlIzTThtZjNHSzJ3eE9MUjAyQjI0WVBpY3hoaG5LUUtQOFBGQlNHMis2d0hab2ZDOXUxREI4Z2R6UE9FT2dHZXUzVnBHCk5abW5OVDZvalorQU1qZmlhc09VYmx4RkhoOGdyOTRXdUNmOXMrWmgyLzIrN3hyMGJHcDB2Um5oa2c2ZEN4UUUzUFpuVDBZQm13c1kKRGtnTlg5WkNXN2ExNUlVeDlZcFk5QT09CjwvZHM6WDUwOUNlcnRpZmljYXRlPgo8L2RzOlg1MDlEYXRhPgo8ZHM6S2V5VmFsdWU+CjxkczpSU0FLZXlWYWx1ZT4KPGRzOk1vZHVsdXM+CnVyS2lEYklhK0NWa3dSQmlTUE9FbG56UXFzT1ZwM0praTlxUXc4MlVjNHZVMGxtVGtSS1Z5V2tUaEpsUGppdzdHMGlnZDlDblhINlgKa3lSOTIzWUVNKzI3Zkt5SzlYNkY0dTh6dVJ2T2R0QnljUW1HRGY3dXp3TjNXV3crMzhBdEpieVEvUjMvaHNka0ZQT3JjNk9URE1lbApwWFltemR1NkZ2bFNjUnc0OStBY0hpTThIU014V3JOOVY3YnlmTmlNeW1QeElodTRYa0pSRlNmWFBmWmFJaE91RndHYXRjdEtwU3FoCmhmNzhwZkxCYm1ESFh5c2tqbHIyZXJMMFdLUlBTSm15TytvbnVBdlh1aUk3Q1kvZEdaalJBL1VoY0hOa3J6TUhlQ3dhU1NkZU1oUGUKWVhGclA2K2QrT3dvUUwyZDlhMXBQSWhncFh1cUhjR05XZTNneHc9PQo8L2RzOk1vZHVsdXM+CjxkczpFeHBvbmVudD5BUUFCPC9kczpFeHBvbmVudD4KPC9kczpSU0FLZXlWYWx1ZT4KPC9kczpLZXlWYWx1ZT4KPC9kczpLZXlJbmZvPgo8ZHM6T2JqZWN0Pjx4YWRlczpRdWFsaWZ5aW5nUHJvcGVydGllcyBJZD0iU2lnbmF0dXJlLTE1MDU4OTAxMzIzODUtUXVhbGlmeWluZ1Byb3BlcnRpZXMiIFRhcmdldD0iI1NpZ25hdHVyZS0xNTA1ODkwMTMyMzg1IiB4bWxuczpkcz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC8wOS94bWxkc2lnIyIgeG1sbnM6eGFkZXM9Imh0dHA6Ly91cmkuZXRzaS5vcmcvMDE5MDMvdjEuMy4yIyI+PHhhZGVzOlVuc2lnbmVkUHJvcGVydGllcyBJZD0iU2lnbmF0dXJlLTE1MDU4OTAxMzIzODUtVW5zaWduZWRQcm9wZXJ0aWVzIj48eGFkZXM6VW5zaWduZWRTaWduYXR1cmVQcm9wZXJ0aWVzPjx4YWRlczpTaWduYXR1cmVUaW1lU3RhbXAgSWQ9IlNpZ25hdHVyZVRpbWVTdGFtcC0xNTA1ODkwMTMyMzg1Ij48eGFkZXM6SW5jbHVkZSBVUkk9IiNEb2N1bWVudFNpZ25hdHVyZVZhbHVlLTE1MDU4OTAxMzIzODUiIHJlZmVyZW5jZWREYXRhPSJmYWxzZSIvPjxkczpDYW5vbmljYWxpemF0aW9uTWV0aG9kIEFsZ29yaXRobT0iaHR0cDovL3d3dy53My5vcmcvVFIvMjAwMS9SRUMteG1sLWMxNG4tMjAwMTAzMTUiLz48eGFkZXM6RW5jYXBzdWxhdGVkVGltZVN0YW1wPk1JQUdDU3FHU0liM0RRRUhBcUNBTUlJTHVRSUJBekVQTUEwR0NXQ0dTQUZsQXdRQ0FRVUFNSUdUQmdzcWhraUc5dzBCQ1JBQkJLQ0Jnd1NCZ0RCK0FnRUJCZ2tyQmdFRUFmTTVad013SHpBSEJnVXJEZ01DR2dRVUlYQWtac0xnNXZIZFlrSVBoUjBVOVFvWmJwRUNFQ0xrZjVjWnNVblFXY0lQVkZYdnFPUVlEekl3TVRjd09USXdNRFkwT0RVeVdqQURBZ0VCQWdqa1ArbUdiVUhiUEtFYk1Ca0dDQ3NHQVFVRkJ3RURCQTB3Q3pBSkJnY0VBSUdYWGdFQm9JSUhkekNDQjNNd2dnVmJvQU1DQVFJQ0VIYXVPV2JndWo2bFY0aW5JZEtWQjI0d0RRWUpLb1pJaHZjTkFRRUxCUUF3UlRFTE1Ba0dBMVVFQmhNQ1JWTXhGREFTQmdOVkJBb01DMGxhUlU1UVJTQlRMa0V1TVNBd0hnWURWUVFEREJkSmVtVnVjR1V1WTI5dElDMGdSRVZUUVZKU1QweE1UekFlRncweE5qQTNNVFV3T1RBME16TmFGdzB5TVRBM01UVXdPVEEwTXpOYU1HWXhDekFKQmdOVkJBWVRBa1ZUTVJRd0VnWURWUVFLREF0SldrVk9VRVVnVXk1QkxqRVlNQllHQTFVRVlRd1BWa0ZVUlZNdFFUQXhNek0zTWpZd01TY3dKUVlEVlFRRERCNTBjMkZrWlhNdWFYcGxibkJsTG1OdmJTQXRJRVJGVTBGU1VrOU1URTh3Z2dJaU1BMEdDU3FHU0liM0RRRUJBUVVBQTRJQ0R3QXdnZ0lLQW9JQ0FRQzY2ak84ZDEwalRuN0pQQTJzSHhacWN0SWlBM2F2N1puZU5tVUNPZUoxMGY3SGVXWXc1aGxZbVErQmVYWEJyUVdyVHdtSkhJK0F4U0trclRsdTZTd2hob2pzMmphQ2Z1Z2Q4ZVdjd3F1QkhJYkZWb2xQckN0TlVJOUxjVkpWUHFERmtiaUtUZnZQWGZiczZtTmd5RFAzeU9JdmNPSmRCUFh5a0Rabk5idEhaREYwSjJ3bHhRMTM3MGw2Qkl4d3luZ3ZQamR5L0lCN3V0SzlacGhwalBYZDFCNW11RWdkam9qL2IzWVRUcHFtQlBDblhpbXlRM0dHUDBhbE1xNEwyUzBRWDgwR3U5djJwbDdtRFdrR1JMM0RCdnF2bnRzZXhsNk9aWkg5ZVN6Wk1DcXcwWFV5TU5OV1VUYmM5T3NrVzUxMmJsYWd2VTNQeXFaVDR6SHFkVGZtbUMxbjI3ZHV2bkowaEZaeVp1WC8wN0FNZngyNjdQbHlKM2xLNmJlaWJOVnAvUWgzTHR5L0h3YjhrVk40SUordzBoNU5QRkw1SUQxQ2ZYblhqd3V2eTF3UldmSTR6MUlzYTNTbERYNXN4NGhCOGQvT2o2ZEpvVVlPYVowY2p2cmgyWDZNY2RhNCtXOU5wclVXU293VUhsU0FXemFCcW1XbXBRQVA1S0tKZU5LMUJpaW00WkVMSENoNDZSZDRoWXAzRnFlMk5YVDkzVHB2V2Q2TEtpMDRGNklMWmVsNXB2aU1zSFJ3eE1Eb3MyVlRaTmgxL3l6MkRRYjcwdE5QZW93ZWI3UE55UHJBYllmVG1MZHNldnMzZHVtUnRHY1NkRVpDdmVabDlyWnJ0bnUyUjRKdWZiTHNHa0ZhK3oxS2xTYnlGd2FQMEtraUxNUFcybkN6dXdiaFFRSURBUUFCbzRJQ1BEQ0NBamd3Z2JBR0ExVWRFZ1NCcURDQnBZRVBhVzVtYjBCcGVtVnVjR1V1WTI5dHBJR1JNSUdPTVVjd1JRWURWUVFLREQ1SldrVk9VRVVnVXk1QkxpQXRJRU5KUmlCQk1ERXpNemN5TmpBdFVrMWxjbU11Vm1sMGIzSnBZUzFIWVhOMFpXbDZJRlF4TURVMUlFWTJNaUJUT0RGRE1FRUdBMVVFQ1F3NlFYWmtZU0JrWld3Z1RXVmthWFJsY25KaGJtVnZJRVYwYjNKaWFXUmxZU0F4TkNBdElEQXhNREV3SUZacGRHOXlhV0V0UjJGemRHVnBlakFPQmdOVkhROEJBZjhFQkFNQ0I0QXdGZ1lEVlIwbEFRSC9CQXd3Q2dZSUt3WUJCUVVIQXdnd0hRWURWUjBPQkJZRUZGbnVOQjhVU2JXb0pwQjl4dTA0RE1VU1hKOUhNQjhHQTFVZEl3UVlNQmFBRkxPNlpjZjlROFhiL0lmWjlYL0RualNiKzJ0Tk1Eb0dDQ3NHQVFVRkJ3RUxCQzR3TERBcUJnZ3JCZ0VGQlFjd0E0WWVhSFIwY0RvdkwzUnpZV1JsY3k1cGVtVnVjR1V1WTI5dE9qZ3dPVE12TUlHbUJnTlZIU0FFZ1o0d2dac3dnWmdHQ1NzR0FRUUI4emxuQXpDQmlqQWxCZ2dyQmdFRkJRY0NBUllaYUhSMGNEb3ZMM2QzZHk1cGVtVnVjR1V1WTI5dEwyTndjekJoQmdnckJnRUZCUWNDQWpCVkdsTkNaWEp0WldWdUlHMTFaMkZySUdWNllXZDFkSHBsYTI4Z2QzZDNMbWw2Wlc1d1pTNWpiMjBnVEdsdGFYUmhZMmx2Ym1WeklHUmxJR2RoY21GdWRHbGhjeUJsYmlCM2QzY3VhWHBsYm5CbExtTnZiVEEyQmdOVkhSOEVMekF0TUN1Z0thQW5oaVZvZEhSd09pOHZZM0pzWkdWekxtbDZaVzV3WlM1amIyMHZZMmRwTFdKcGJpOWhjbXd5TUEwR0NTcUdTSWIzRFFFQkN3VUFBNElDQVFBQ0NMTElkR0s2dnVXQm44bGxaYSsxSUN2ZzZwSmRoSzBTdGFOeDI2YTVyazV3TFA0aTJXdS8wT0NxK3J4UjBLMlQ0UWwxVHFWUkxQczUzakdRZURqdzBJcEMxa1JCR3VKc0c2c01GTXUxaERxeDJ3SVAvRlJWQ2hmYWQ4VlRXKzRwMGM5cldFRVJoUHp6Z1htbXp5aFN5cUtzTW5Td0RNcFNqY2wyY0dGU2gvY01Na3d6a2F0WW4wdVZJK1Vpa3dLNitHZWVOV3l5UlFFekVpNm9Rb1h1MTBvZytDU1VsNWxVeVAyR0dVaENZUWlta3NJdVcwMGVUVjgxN2dxSXdSZWx2OU1HWlhDOG1iYWN5MkdNbk5RcTNhb3U1TVRPTFByeDV6STJqSlltNEtUVU5sbXFXQ2oxeGRDKzdnQjBtZ1drWFpUYWFhSUZmcFUxWW1HdEZnMUc5dUJvYWo4ZXp6eVpTUXdtRzZVNnZNVXdCTDBtSzVVWnEvbnBya0RoUUZWN3dRVWdmZURBY0xEK1MxMXhVOFhzMjMzYkRkSjIrZUxsYzk3UFd5eXVlUnlwZEd5V1UvcUtZaVhmUFVOZGI2Rlc5NTltRzIzSWNFZHUwNDNPUVZjZEV0eTN4QnlmR0lWdjlveWF2TnpYRTIyaVZ3d1lOQTc4M0o2RW8xM0syczR2SGtjOFZNMm5qS2FzY0wycDIyTVo1YWVhaEluM2crc2hnVmg1bjVoc3VZeVYzR014VFJJRVJXcFFLVUYyc0pwaThPN1A5bXorMmE3SDFZclJHU3BVMnp1RTQ2SzhYRDNaaExZTjljNDFLYVdVOHhzcXJMS1lYZWwzclAzdTNWMGI3U1A2dmRuY1JvRm9oODVMOUd1ZjZ3eWNCWUFaaHdKWFNBOVdWaXJmR1RHQ0E1QXdnZ09NQWdFQk1Ga3dSVEVMTUFrR0ExVUVCaE1DUlZNeEZEQVNCZ05WQkFvTUMwbGFSVTVRUlNCVExrRXVNU0F3SGdZRFZRUUREQmRKZW1WdWNHVXVZMjl0SUMwZ1JFVlRRVkpTVDB4TVR3SVFkcTQ1WnVDNlBxVlhpS2NoMHBVSGJqQU5CZ2xnaGtnQlpRTUVBZ0VGQUtDQ0FRZ3dHZ1lKS29aSWh2Y05BUWtETVEwR0N5cUdTSWIzRFFFSkVBRUVNQndHQ1NxR1NJYjNEUUVKQlRFUEZ3MHhOekE1TWpBd05qUTROVEphTUM4R0NTcUdTSWIzRFFFSkJERWlCQ0J0ZFlMRXQrUUhtRGRpS3U4SkVnRUYxLzJyU1dzaWJJODV3K2xtUjFwbFNqQ0JtZ1lMS29aSWh2Y05BUWtRQWk4eGdZb3dnWWN3Z1lRd2dZRUVJRm81NE9YNzFPbExKUWloMml5d25VSkR0Umdjcmo4OW1NK0dpbE94aWtvRk1GMHdTYVJITUVVeEN6QUpCZ05WQkFZVEFrVlRNUlF3RWdZRFZRUUtEQXRKV2tWT1VFVWdVeTVCTGpFZ01CNEdBMVVFQXd3WFNYcGxibkJsTG1OdmJTQXRJRVJGVTBGU1VrOU1URThDRUhhdU9XYmd1ajZsVjRpbklkS1ZCMjR3RFFZSktvWklodmNOQVFFQkJRQUVnZ0lBZzhGdk9WalE1VW5tYXQ4eGJWU1RJSThCODZ5SWl2KzZkN3JjTXlKQXIrUWpOVGlPNWtIeXNCWVc0NEhoNHlGYysrZExGdjJCZHNVclF6MU8yWnhNTkFvTkVhR0hiUWFlcjRud25qeGV5bE5yb2prMGFqVlRwZ0RaSGRnQ0w1L1pNRWdmR1JicnZQNGV4VmEwalFjczI2Q0VJaHNicGc2ZWZZTFlnRk40SkxCdVB2UHdaVnFKdVBQalRKMVJDTDZXRHRyR3VRUUdRUEdCd2JnSE5xdys0SEppZk84KzVVM1VvWkZ6R0hSMGVqWTYvbCtjaGRuMVcyVnduVWtRb2tOVTZzN3JGVkpJb2puWDFsYlpuRUtQc2VVNHZRcC9oVFNaQ29nK3FiTkhuU0VFclZ5Mjh5MytHcEV5MTh3QUZZOEU1ajRUS2VIbmtaaHBCRTVrMEpNbFZYNVRUemRoL29DSHVPcUlESWU5c1VKUW1rZG1pTEl3ZjYydXhJNm1wYWNFKzdIMk9HMVhQZTgvVUxBRE4yYXovbXBDM1NCVlVMV3YrR200ZlRVcGhjc0NvbmIxWlNxOThIRk9JdHlURXN6RlhobFE1ZlNibTNZWEowK3czdGtFKzhITEQwMXBRdUxxZHcvYUEwVlJLVmtaVE1KZ21IMktwZFZOOWc1R3VLNEppUmxlNCtlREsyY0hPaGsweGQ1a1pEZGJuSlJ5Ymhmc3BJdEZzUDExbStiQlZ6bGNYL01CelRFK3pEUXFDTGlpTVc4ZURORXltMjRkMGsxTExBRXZJTG9QTjhmTmxpMWxLR3paeWdQNTdmY1E5SWN6enhxTURFSkJrQXZLbC91MHl5QzljOXoweDlIT2pNOEd3bjBJVENaOFNsVlY5MmZyUE5KSmRzdFRnYndBQUFBQTwveGFkZXM6RW5jYXBzdWxhdGVkVGltZVN0YW1wPjwveGFkZXM6U2lnbmF0dXJlVGltZVN0YW1wPjwveGFkZXM6VW5zaWduZWRTaWduYXR1cmVQcm9wZXJ0aWVzPjwveGFkZXM6VW5zaWduZWRQcm9wZXJ0aWVzPjx4YWRlczpTaWduZWRQcm9wZXJ0aWVzIElkPSJTaWduYXR1cmUtMTUwNTg5MDEzMjM4NS1TaWduZWRQcm9wZXJ0aWVzIj48eGFkZXM6U2lnbmVkU2lnbmF0dXJlUHJvcGVydGllcz48eGFkZXM6U2lnbmluZ1RpbWU+MjAxNy0wOS0yMFQwNjo0ODo1Mi40MTVaPC94YWRlczpTaWduaW5nVGltZT48eGFkZXM6U2lnbmluZ0NlcnRpZmljYXRlPjx4YWRlczpDZXJ0Pjx4YWRlczpDZXJ0RGlnZXN0PjxkczpEaWdlc3RNZXRob2QgQWxnb3JpdGhtPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwLzA5L3htbGRzaWcjc2hhMSIvPjxkczpEaWdlc3RWYWx1ZT5iUU9qd3NaMlNiNFNVSmhJNXpEUHk4MlVWdVE9PC9kczpEaWdlc3RWYWx1ZT48L3hhZGVzOkNlcnREaWdlc3Q+PHhhZGVzOklzc3VlclNlcmlhbD48ZHM6WDUwOUlzc3Vlck5hbWU+Q049Q0EgZGUgQ2l1ZGFkYW5vcyB5IEVudGlkYWRlcyAoNCkgLSBERVNBUlJPTExPLE9VPU5aWiBaaXVydGFnaXJpIHB1Ymxpa29hIC0gQ2VydGlmaWNhZG8gcHVibGljbyBTQ0ksTz1JWkVOUEUgUy5BLixDPUVTPC9kczpYNTA5SXNzdWVyTmFtZT48ZHM6WDUwOVNlcmlhbE51bWJlcj40Mzk3PC9kczpYNTA5U2VyaWFsTnVtYmVyPjwveGFkZXM6SXNzdWVyU2VyaWFsPjwveGFkZXM6Q2VydD48L3hhZGVzOlNpZ25pbmdDZXJ0aWZpY2F0ZT48eGFkZXM6U2lnbmF0dXJlUG9saWN5SWRlbnRpZmllcj48eGFkZXM6U2lnbmF0dXJlUG9saWN5SWQ+PHhhZGVzOlNpZ1BvbGljeUlkPjx4YWRlczpJZGVudGlmaWVyPnVybjplamd2OmRzczpwb2xpY3k6MTwveGFkZXM6SWRlbnRpZmllcj48eGFkZXM6RGVzY3JpcHRpb24+UG9saXRpY2EgZGUgZmlybWEgZGVsIEdvYmllcm5vIFZhc2NvIC0gRXVza28gSmF1cmxhcml0emE8L3hhZGVzOkRlc2NyaXB0aW9uPjwveGFkZXM6U2lnUG9saWN5SWQ+PHhhZGVzOlNpZ1BvbGljeUhhc2g+PGRzOkRpZ2VzdE1ldGhvZCBBbGdvcml0aG09Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvMDkveG1sZHNpZyNzaGExIi8+PGRzOkRpZ2VzdFZhbHVlPmpvcklwMWJ2bWdJWFNCVE1CWWliakhCVHNCRT08L2RzOkRpZ2VzdFZhbHVlPjwveGFkZXM6U2lnUG9saWN5SGFzaD48eGFkZXM6U2lnUG9saWN5UXVhbGlmaWVycz48eGFkZXM6U2lnUG9saWN5UXVhbGlmaWVyPjx4YWRlczpTUFVSST5odHRwOi8vd3d3Lml6ZW5wZS5jb20vczE1LTEyMDIwL2VzL2NvbnRlbmlkb3MvaW5mb3JtYWNpb24vZGVzY2FyZ2FfY2VydGlmaWNhZG9zL2VzX3BmL2FkanVudG9zL3BvbGl0aWNhX2Zpcm1hX2l6ZW5wZV92MV81LnBkZjwveGFkZXM6U1BVUkk+PC94YWRlczpTaWdQb2xpY3lRdWFsaWZpZXI+PC94YWRlczpTaWdQb2xpY3lRdWFsaWZpZXJzPjwveGFkZXM6U2lnbmF0dXJlUG9saWN5SWQ+PC94YWRlczpTaWduYXR1cmVQb2xpY3lJZGVudGlmaWVyPjwveGFkZXM6U2lnbmVkU2lnbmF0dXJlUHJvcGVydGllcz48L3hhZGVzOlNpZ25lZFByb3BlcnRpZXM+PC94YWRlczpRdWFsaWZ5aW5nUHJvcGVydGllcz48L2RzOk9iamVjdD4KPC9kczpTaWduYXR1cmU+PC9wPgo8L2Rpdj4KPGRpdiBzdHlsZT0iZGlzcGxheTogbm9uZTsiPgo8aXNJZGF6a2lEZXNrdG9wPnRydWU8L2lzSWRhemtpRGVza3RvcD4KPC9kaXY+CiAgICAgIDxzdHlsZSB0eXBlPSJ0ZXh0L2NzcyI+Ci8qQ1NTRG9jdW1lbnQqL2Rpdi55MjJfaGVhZGVyUm93MXtkaXNwbGF5Om5vbmU7fQoKLm51ZXZve2NvbG9yOiMxNzc5QUU7fQoubnVldm8xYXtjb2xvcjojOTk2NjMzO3RleHQtZGVjb3JhdGlvbjp1bmRlcmxpbmU7fQoKYXtjb2xvcjojMTc3OUFFO3RleHQtZGVjb3JhdGlvbjpub25lO30KI3Rvb2xraXREb2MgaDF7cGFkZGluZzogMSUgMSUgMSUgMSU7dGV4dC1hbGlnbjpjZW50ZXI7Zm9udC1zaXplOiAyMXB4IWltcG9ydGFudDttYXJnaW46MHB4IWltcG9ydGFudDt9Cmgxe2NvbG9yOiM1NTU1NTU7fQojdG9vbGtpdERvYyBoMnttYXJnaW4tdG9wOjdweCFpbXBvcnRhbnQ7IG1hcmdpbi1ib3R0b206N3B4IWltcG9ydGFudDtiYWNrZ3JvdW5kLWNvbG9yOiNlNmU2ZTYhaW1wb3J0YW50OyBjb2xvcjojNTU1NTU1IWltcG9ydGFudDtmb250LXdlaWdodDogYm9sZCFpbXBvcnRhbnQ7d2lkdGg6aW5oZXJpdDtmb250LXNpemU6IDEycHghaW1wb3J0YW50O3BhZGRpbmc6IDAuMyUgMCUgMC4zJSAwLjMlOyBtYXJnaW4tbGVmdDowcHghaW1wb3J0YW50OyBib3JkZXI6IDFweCBzb2xpZCAjZDNkM2QzO2ZvbnQtZmFtaWx5OiBWZXJkYW5hLEFyaWFsLHNhbnMtc2VyaWYhaW1wb3J0YW50O3RleHQtc2hhZG93OiBub25lIWltcG9ydGFudDt9Ci51aS13aWRnZXQtY29udGVudCAjdG9vbGtpdERvYyBoMSB7ZGlzcGxheTpub25lIWltcG9ydGFudDt9CiN0b29sa2l0RG9je2ZvbnQtZmFtaWx5OlZlcmRhbmEsIEFyaWFsIWltcG9ydGFudDtiYWNrZ3JvdW5kLXBvc2l0aW9uOiBib3R0b20gcmlnaHQ7Zm9udC1zaXplOiAxMnB4IWltcG9ydGFudDtkaXNwbGF5OiBibG9jaztib3JkZXItbGVmdDoxcHggc29saWQgI0NDQ0NDQzsgbWFyZ2luLWxlZnQ6NSU7bWFyZ2luLXJpZ2h0OjUlO2JvcmRlci1yaWdodDoxcHggc29saWQgI0NDQ0NDQzsgIGJvcmRlci1ib3R0b206MXB4IHNvbGlkICNDQ0NDQ0M7Ym9yZGVyLXRvcDoxcHggc29saWQgI0NDQ0NDQztiYWNrZ3JvdW5kLWNvbG9yOiNGNEY0RjQ7fQoudWktd2lkZ2V0LWNvbnRlbnQgI3Rvb2xraXREb2N7bWFyZ2luLWxlZnQ6MCU7bWFyZ2luLXJpZ2h0OjAlO30KI3Rvb2xraXREb2MgLmV0aXF1ZXRhRm9ybXVsYXJpbzF7Zm9udC13ZWlnaHQ6Ym9sZDttYXJnaW4tbGVmdDowcHg7fQojdG9vbGtpdERvYyAuc2FsdG9MaW5lYVJhZGlve3ZlcnRpY2FsLWFsaWduOnRvcDt9CiN0b29sa2l0RG9jIC5ldGlxdWV0YUZvcm11bGFyaW8ye3BhZGRpbmc6MCU0JTAlMCU7Zm9udC13ZWlnaHQ6bm9ybWFsO3doaXRlLXNwYWNlOiBwcmUtd3JhcDt3b3JkLXdyYXA6IGJyZWFrLXdvcmQ7d29yZC1icmVhazogYnJlYWstYWxsO30KI3Rvb2xraXREb2MgI2RlY2xhcmFjaW9uZXNSZXNwb25zYWJsZXMgLmV0aXF1ZXRhRm9ybXVsYXJpbzJ7cGFkZGluZzowJTAlMCUwJSAhaW1wb3J0YW50O2ZvbnQtd2VpZ2h0Om5vcm1hbDt3aGl0ZS1zcGFjZTogcHJlLXdyYXA7d29yZC13cmFwOiBicmVhay13b3JkO3dvcmQtYnJlYWs6IGJyZWFrLWFsbDt9CgojdG9vbGtpdERvYyAubGFiZWxEZVJhZGlve21hcmdpbjowcHghaW1wb3J0YW50O3BhZGRpbmc6MHB4IWltcG9ydGFudDt9CiN0b29sa2l0RG9jIC50b29sa2l0TiAuc2luU2FsdG8gc3BhbnttYXJnaW4tcmlndGg6MCFpbXBvcnRhbnQ7fQoKLmZpbGFWYWNpYXtkaXNwbGF5Om5vbmU7fQouZmlsYVZhY2lhe2Rpc3BsYXk6bm9uZTt9CiN0b29sa2l0RG9jIHRhYmxle2ZvbnQtZmFtaWx5OlZlcmRhbmEsIEFyaWFsIWltcG9ydGFudDt3aWR0aDphdXRvOyBtYXJnaW4tcmlnaHQ6MSUhaW1wb3J0YW50O3RleHQtYWxpZ246Y2VudGVyO2ZvbnQtc2l6ZToxMnB4IWltcG9ydGFudDt9CiN0b29sa2l0RG9jIHRhYmxlIHRoZWFkIC5ldGlxdWV0YUZvcm11bGFyaW8xe21hcmdpbi1sZWZ0OmluaGVyaXQ7d2lkdGg6YXV0bzsgcGFkZGluZy1ib3R0b206MSU7bWFyZ2luLXJpZ2h0OjElIWltcG9ydGFudDtiYWNrZ3JvdW5kLWNvbG9yOiNDQ0M7cGFkZGluZzoxMHB4IDEwcHggMTBweCAxMHB4O30KI3Rvb2xraXREb2MgI2RhdG9zQXZpc28gdGFibGUgdGhlYWQgLmV0aXF1ZXRhRm9ybXVsYXJpbzF7d2lkdGg6NDAlIWltcG9ydGFudDt3aGl0ZS1zcGFjZTpub3dyYXA7fQojdG9vbGtpdERvYyAjZGF0b3NBdmlzbyB0YWJsZSB0ZCAuZXRpcXVldGFGb3JtdWxhcmlvMXt3aWR0aDo0MCUhaW1wb3J0YW50O30KCiN0b29sa2l0RG9jIGlucHV0e21hcmdpbi1sZWZ0OmluaGVyaXQ7fQojdG9vbGtpdERvYyBzcGFue21hcmdpbi1yaWdodDoxJTsgZGlzcGxheTogaW5saW5lLWJsb2NrO30KI3Rvb2xraXREb2MgdGFibGUgdGR7bWFyZ2luLWxlZnQ6aW5oZXJpdDt3aWR0aDphdXRvIWltcG9ydGFudDsgIG1hcmdpbi1yaWdodDowJTt9CiN0b29sa2l0RG9jIHRhYmxlIHRyIHRkLndpZHRoMTBwZXJjZW50IHt3aWR0aDogMTAlfGltcG9ydGFudDt9CiN0b29sa2l0RG9jIHRhYmxlIHRyIHRkLndpZHRoOTBwZXJjZW50IHt3aWR0aDogOTAlfGltcG9ydGFudDt9CgojdG9vbGtpdERvYyB0ZC5taW53aWR0aDVwZXJjZW50IHttaW4td2lkdGg6NSU7fQojdG9vbGtpdERvYyBwe2ZvbnQtc2l6ZTppbmhlcml0O2Rpc3BsYXk6IGJsb2NrIWltcG9ydGFudDsgZm9udC13ZWlnaHQ6bm9ybWFsOyBtYXJnaW4tbGVmdDowcHg7bWFyZ2luLWJvdHRvbToxJTttYXJnaW4tdG9wOjBweCFpbXBvcnRhbnQ7cGFkZGluZzogMHB4IWltcG9ydGFudDt9CiN0b29sa2l0RG9jIGl7Zm9udC13ZWlnaHQ6bm9ybWFsO2Rpc3BsYXk6IGlubGluZS1ibG9jazttYXJnaW4tbGVmdDowcHghaW1wb3J0YW50O30KLmZsZWNoYXtjb2xvcjojMTc3OUFFO30KLkVycm9ye2ZvbnQtc2l6ZToxMjAlO2NvbG9yOnJlZDt9Ci5FcnJvcjF7Zm9udC1zaXplOjY1JTt2ZXJ0aWNhbC1hbGlnbjp0b3A7Zm9udC1mYW1pbHk6VmVyZGFuYSwgQXJpYWwhaW1wb3J0YW50O2NvbG9yOnJlZDtmb250LXdlaWdodDpib2xkO30KYnJ7Ym9yZGVyLWJvdHRvbToxcHhzb2xpZCNDQ0NDQ0M7Ym9yZGVyLXJpZ2h0OjBweHNvbGlkIzAwMDAwMDtib3JkZXItbGVmdDowcHhzb2xpZCMwMDAwMDA7Ym9yZGVyLXRvcDowcHhzb2xpZCMwMDAwMDA7fQojdG9vbGtpdERvY3VtZW50b3N7dGV4dC1hbGlnbjpsZWZ0O2ZvbnQtZmFtaWx5OlZlcmRhbmEsIEFyaWFsIWltcG9ydGFudDtib3JkZXItbGVmdDoxcHhzb2xpZCMwMDAwMDA7Ym9yZGVyLXJpZ2h0OjFweHNvbGlkIzAwMDAwMDtib3JkZXItYm90dG9tOjFweHNvbGlkIzAwMDAwMDt9CiN0b29sa2l0RG9jdW1lbnRvcyBsaXttYXJnaW4tdG9wOi0xJTttYXJnaW4tYm90dG9tOjAuOCU7cGFkZGluZzowLjMlMCUwLjMlMSU7fQoKLnRleHRvTGVnYWx7Zm9udDo4MCVWZXJkYW5hLEFyaWFsLHNhbnMtc2VyaWY7d2lkdGg6aW5oZXJpdDt9CiNkYXRvc2Nob2ljZU5vdGlmaWNhY2lvbnttYXJnaW4tbGVmdDppbmhlcml0O30KIC54NDNrR3J1cG9DaG9pY2VTdWJFbGVtZW50c3twYWRkaW5nLXRvcDoxMHB4O30KIC54NDNrR3J1cG9DaG9pY2VPcHRpb25ze3BhZGRpbmctdG9wOjEwcHg7IGZvbnQ6VmVyZGFuYSxBcmlhbCxzYW5zLXNlcmlmfQoKI2RvY3VtZW50b3NBcG9ydGFkb3MudG9vbGtpdERvY3VtZW50b3MgdGh7dGV4dC1hbGlnbjpjZW50ZXI7bWFyZ2luLWxlZnQ6aW5oZXJpdDt3aWR0aDphdXRvOyBwYWRkaW5nLWJvdHRvbToxJTttYXJnaW4tcmlnaHQ6MSUhaW1wb3J0YW50O2JhY2tncm91bmQtY29sb3I6I0NDQztwYWRkaW5nOjEwcHggMTBweCAxMHB4IDEwcHg7fQojZG9jdW1lbnRvc0Fwb3J0YWRvcy50b29sa2l0RG9jdW1lbnRvcyB0ZHttYXJnaW4tbGVmdDppbmhlcml0O3dpZHRoOmF1dG87cGFkZGluZy1ib3R0b206IDBweCFpbXBvcnRhbnQ7bWFyZ2luLXJpZ2h0OjElIWltcG9ydGFudDtwYWRkaW5nOjVweCAxMHB4IDVweCAxMHB4O3dvcmQtYnJlYWs6YnJlYWstYWxsO30KI2RvY3VtZW50b3NFbnRyZWdhZG9zLnRvb2xraXREb2N1bWVudG9zIHRoe3RleHQtYWxpZ246Y2VudGVyO21hcmdpbi1sZWZ0OmluaGVyaXQ7d2lkdGg6YXV0bzsgcGFkZGluZy1ib3R0b206MSU7bWFyZ2luLXJpZ2h0OjElIWltcG9ydGFudDtiYWNrZ3JvdW5kLWNvbG9yOiNDQ0M7cGFkZGluZzoxMHB4IDEwcHggMTBweCAxMHB4O30KI2RvY3VtZW50b3NFbnRyZWdhZG9zLnRvb2xraXREb2N1bWVudG9zIHRke21hcmdpbi1sZWZ0OmluaGVyaXQ7d2lkdGg6YXV0bztwYWRkaW5nLWJvdHRvbTogMHB4IWltcG9ydGFudDttYXJnaW4tcmlnaHQ6MSUhaW1wb3J0YW50O3BhZGRpbmc6NXB4IDEwcHggNXB4IDEwcHg7d29yZC1icmVhazpicmVhay1hbGw7fQojdG9vbGtpdERvYyAuc2FsdG8ge2hlaWdodDogM3B4IWltcG9ydGFudDtsaW5lLWhlaWdodDogMDtmb250LXNpemU6IDA7fQojdG9vbGtpdERvYyAueDQza1NlcGFyYXRvcntkaXNwbGF5Om5vbmU7fQojdG9vbGtpdERvYyAueDQza0VudW1lcmFjaW9uIC5ldGlxdWV0YUZvcm11bGFyaW8xe21hcmdpbi1ib3R0b206MHB4IWltcG9ydGFudDt9CiN0b29sa2l0RG9jIC54NDNrRW51bWVyYWNpb24gLmV0aXF1ZXRhRm9ybXVsYXJpbzJ7bWFyZ2luLWJvdHRvbTowcHghaW1wb3J0YW50O3doaXRlLXNwYWNlOiBwcmUtd3JhcDt3b3JkLXdyYXA6IGJyZWFrLXdvcmQ7d29yZC1icmVhazogYnJlYWstYWxsO30KI3Rvb2xraXREb2MgLng0M2tFbnVtZXJhY2lvbnttYXJnaW4tbGVmdDowIWltcG9ydGFudDt9CiN0b29sa2l0RG9jIC54NDNrRW51bWVyYWNpb24gdWwge21hcmdpbi1sZWZ0OiAwIWltcG9ydGFudDsgcGFkZGluZy1sZWZ0OiAyJSFpbXBvcnRhbnQ7fQojdG9vbGtpdERvYyAueDQza0VudW1lcmFjaW9uIHB7bWFyZ2luLXRvcDoxJSFpbXBvcnRhbnQ7fQojdG9vbGtpdERvYyAjZGF0b3NBdmlzbyB0YWJsZSB7d2lkdGg6MjUlO30KLnRvb2xraXRDb25zZW50aW1pZW50b3MgdGFibGUge3RleHQtYWxpZ246bGVmdCFpbXBvcnRhbnQ7fQoudG9vbGtpdERvY3VtZW50b3MgdGFibGUge3RleHQtYWxpZ246bGVmdCFpbXBvcnRhbnQ7d2lkdGg6YXV0bzt9Ci50b29sa2l0Q29uc2VudGltaWVudG9zIHRke21hcmdpbi1sZWZ0OjElO3dvcmQtYnJlYWs6YnJlYWstYWxsO30KCiNkZWNsYXJhY2lvbmVzUmVzcG9uc2FibGVzIC5ldGlxdWV0YUZvcm11bGFyaW8xe2ZvbnQtd2VpZ2h0Om5vcm1hbCFpbXBvcnRhbnQ7fQojdG9vbGtpdERvYyAjZGVjbGFyYWNpb25lc1Jlc3BvbnNhYmxlcyBkaXZ7bWFyZ2luOjBweCFpbXBvcnRhbnQ7fQojdG9vbGtpdERvYyAjZGVjbGFyYWNpb25JbnNjcmlwY2lvbiBkaXZ7ZGlzcGxheTogaW5saW5lLWJsb2NrIWltcG9ydGFudDsgKmRpc3BsYXk6aW5saW5lIWltcG9ydGFudDsgd2hpdGUtc3BhY2U6bm93cmFwOyAqd2lkdGg6MzAlO30KI3g0M2tfbGlzdGFfRGVjbGFyYWNpb25SZWdpc3Ryb1BhaXNWYXNjbyBzcGFuIHttYXJnaW4tYm90dG9tOjVweDt9CiN4NDNrX2xhYmVsX0RlY2xhcmFjaW9uTGlzdGFSZWdpc3RybyBzcGFue21hcmdpbi1ib3R0b206NXB4OyBtYXJnaW4tbGVmdDo1cHh9CiN0b29sa2l0RG9jICNkZWNsYXJhY2lvbkluc2NyaXBjaW9uIC5ldGlxdWV0YUZvcm11bGFyaW8yeypwYWRkaW5nLWJvdHRvbTo1cHghaW1wb3J0YW50OypwYWRkaW5nLXJpZ2h0OjVweCFpbXBvcnRhbnQ7KnBhZGRpbmctbGVmdDowIWltcG9ydGFudDt3aGl0ZS1zcGFjZTogcHJlLXdyYXA7d29yZC13cmFwOiBicmVhay13b3JkO3dvcmQtYnJlYWs6IGJyZWFrLWFsbDt9CiN0b29sa2l0RG9jICNkZWNsYXJhY2lvbkluc2NyaXBjaW9uIC5ldGlxdWV0YUZvcm11bGFyaW8xeypwYWRkaW5nLWJvdHRvbTo1cHghaW1wb3J0YW50O30KCiN4NDNrX2NoZWNrX2RlY2xhcmFjaW9uX2luc2NyaXBjaW9uIHNwYW4ge3dpZHRoOjEwMCUhaW1wb3J0YW50fQojeDQza19sYWJlbF9EZWNsYXJhY2lvbkxpc3RhUmVnaXN0cm8gc3BhbiB7bWFyZ2luLXJpZ2h0OjAlIWltcG9ydGFudDt9CgojdG9vbGtpdERvYyAudG9vbGtpdE4xIHByaW1lckVsZW1lbnRvIGRpdntwYWRkaW5nOjBweDtmb250LXNpemU6IGluaGVyaXQ7bWFyZ2luLWxlZnQ6MSU7ZGlzcGxheTpibG9jazttYXJnaW4tdG9wOjBweCFpbXBvcnRhbnQ7fQojdG9vbGtpdERvYyAudG9vbGtpdE4xIC50b29sa2l0TiB7bWFyZ2luLWxlZnQ6MHB4IWltcG9ydGFudDt9CiN0b29sa2l0RG9jIC50b29sa2l0TjEgLnRvb2xraXROMiBkaXYge3BhZGRpbmc6MHB4O2ZvbnQtc2l6ZTogaW5oZXJpdDttYXJnaW4tbGVmdDoyJSFpbXBvcnRhbnQ7ZGlzcGxheTpibG9jazt9CiN0b29sa2l0RG9jIC50b29sa2l0TjEgLnRvb2xraXROMiAudG9vbGtpdE4ge21hcmdpbi1sZWZ0OjBweCFpbXBvcnRhbnQ7fQojdG9vbGtpdERvYyAudG9vbGtpdE4xIC50b29sa2l0TjIgLnRvb2xraXROIGRpdnttYXJnaW4tbGVmdDogMHB4O30KCiN0b29sa2l0RG9jIC50b29sa2l0TjEgLnRvb2xraXROMiAudG9vbGtpdE4gLng0M2tFbnVtZXJhY2lvbiB7bWFyZ2luLWxlZnQ6MHB4IWltcG9ydGFudDsgbWFyZ2luLWJvdHRvbToxJTt9CiN0b29sa2l0RG9jIC50b29sa2l0TjIgZGl2e3BhZGRpbmc6MHB4O2ZvbnQtc2l6ZTogaW5oZXJpdDttYXJnaW4tbGVmdDoyJSFpbXBvcnRhbnQ7ZGlzcGxheTpibG9jazt9CiN0b29sa2l0RG9jIC50b29sa2l0TjIgLnRvb2xraXROIHttYXJnaW4tbGVmdDowcHghaW1wb3J0YW50O30KI3Rvb2xraXREb2MgLnRvb2xraXROMiAudG9vbGtpdE4gbGkgZGl2e21hcmdpbi1sZWZ0OjBweCFpbXBvcnRhbnQ7fQojdG9vbGtpdERvYyAudG9vbGtpdE4yIC50b29sa2l0TiAgdWwgZGl2e21hcmdpbi1sZWZ0OjBweCFpbXBvcnRhbnQ7fQojdG9vbGtpdERvYyAudG9vbGtpdE4yIC50b29sa2l0TiAuZGl2RW5MaW5lYXttYXJnaW4tbGVmdDowcHghaW1wb3J0YW50O2Rpc3BsYXk6aW5saW5lO30KI3Rvb2xraXREb2MgLnRvb2xraXROMSAudG9vbGtpdE4yIC50b29sa2l0TiAuZGl2RW5MaW5lYSBkaXYge21hcmdpbi1sZWZ0OiAwcHghaW1wb3J0YW50O30KI3Rvb2xraXREb2MgLnRvb2xraXROMiAudG9vbGtpdE4gLmRpdkVuTGluZWFCb3JkZURlcmVjaG97bWFyZ2luLWxlZnQ6MHB4IWltcG9ydGFudDtkaXNwbGF5OmlubGluZTtib3JkZXItcmlnaHQ6MXB4c29saWQjQ0NDQ0NDO30KI3Rvb2xraXREb2MgLnRvb2xraXROMyB7Zm9udC1zaXplOiBpbmhlcml0O21hcmdpbi1sZWZ0OjMlIWltcG9ydGFudDtkaXNwbGF5OmJsb2NrO30KI3Rvb2xraXREb2MgLnRvb2xraXROMyAudG9vbGtpdE4ge21hcmdpbi1sZWZ0OjBweCFpbXBvcnRhbnQ7fQojdG9vbGtpdERvYyAudG9vbGtpdE4zIC50b29sa2l0TiBkaXZ7cGFkZGluZzowcHg7Zm9udC1zaXplOiBpbmhlcml0O21hcmdpbi1sZWZ0OjMlIWltcG9ydGFudDtkaXNwbGF5OmJsb2NrO30KI3Rvb2xraXREb2MgLnRvb2xraXROMyBkaXZ7Zm9udC1zaXplOiBpbmhlcml0O21hcmdpbi1sZWZ0OjMlIWltcG9ydGFudDtkaXNwbGF5OmJsb2NrO30KI3Rvb2xraXREb2MgLnRvb2xraXREb2N1bWVudG9ze21hcmdpbi1sZWZ0OjElIWltcG9ydGFudDt9CiN0b29sa2l0RG9jIC50b29sa2l0Q29uc2VudGltaWVudG9ze21hcmdpbi1sZWZ0OjElIWltcG9ydGFudDt3b3JkLWJyZWFrOmJyZWFrLWFsbDt9CiN0b29sa2l0RG9jICNmaXJtYWRvUG9ye21hcmdpbi1sZWZ0OjElIWltcG9ydGFudDt9ICAKCiN0b29sa2l0RG9jIC50b29sa2l0TjEgLnRvb2xraXROMiAudG9vbGtpdE4gLmZpZWxkc2V0e21hcmdpbi1sZWZ0OjBweCFpbXBvcnRhbnQ7fQojdG9vbGtpdERvYyBkaXYge3BhZGRpbmctbGVmdDoxJTsgcGFkZGluZy1yaWdodDoxJTt9CiN0b29sa2l0RG9jIGZpZWxkc2V0ICB7bWFyZ2luLWxlZnQ6MHB4IWltcG9ydGFudDtib3JkZXI6MDt9Ci54NDNrTm9Cb3JkZXJ7Ym9yZGVyOjBweDt9CiN0b29sa2l0RG9jIC50b29sa2l0TjIgLnRvb2xraXROIC54NDNrR3J1cG9DaG9pY2UgIGRpdiB7bWFyZ2luLWxlZnQ6MHB4IWltcG9ydGFudDt9CiNjb2xtdW5WaTphZnRlciB7Y29udGVudDonXDI3MTQgJzsgY29sb3I6IzRmYjBlN30KI2NvbG11blZpTm90QXV0OmFmdGVyIHtjb250ZW50OidcMjcxNiAnOyBjb2xvcjojNGZiMGU3fQoKI2NvbG11bkFycm93UmlnaHQ6YWZ0ZXIge2NvbnRlbnQ6J1wyNUI4ICc7IGNvbG9yOiM0ZmIwZTd9CgojdG9vbGtpdERvYyBzcGFuIC5zaW5TYWx0byB7bWFyZ2luLXJpZ2h0OiAxMHB4IWltcG9ydGFudDt9CgojdG9vbGtpdERvYyAudGV4dG9WYWxvckZpam9SYWRpb3t3aWR0aDogMTAwJTtib3JkZXI6MXB4O21hcmdpbi1sZWZ0OjIycHghaW1wb3J0YW50O21hcmdpbi1yaWd0aDo1cHg7bWFyZ2luLWJvdHRvbTo1cHg7bWFyZ2luLXRvcDo1cHg7ZGlzcGxheTppbmxpbmUtYmxvY2s7ZmxvYXQ6bm9uZSFpbXBvcnRhbnQ7fQojdG9vbGtpdERvYyAuaW5wdXRWYWxvckZpam9SYWRpbyB7cG9zaXRpb246YWJzb2x1dGU7fQoKCiN0b29sa2l0RG9jIC50ZXh0b1ZhbG9yRmlqb0NoZWNre3dpZHRoOiAxMDAlO2JvcmRlcjoxcHg7bWFyZ2luLWxlZnQ6MjJweCFpbXBvcnRhbnQ7bWFyZ2luLXJpZ3RoOjVweDttYXJnaW4tYm90dG9tOjVweDttYXJnaW4tdG9wOjVweDtkaXNwbGF5OmlubGluZS1ibG9jaztmbG9hdDpub25lIWltcG9ydGFudDt9CiN0b29sa2l0RG9jIC54NDNrX2NoZWNrX2RlY2xhcmFjaW9uX2luc2NyaXBjaW9ue3dpZHRoOiAxMDAlO2JvcmRlcjoxcHg7bWFyZ2luLWxlZnQ6MjJweCFpbXBvcnRhbnQ7bWFyZ2luLXJpZ3RoOjVweDttYXJnaW4tYm90dG9tOjVweDttYXJnaW4tdG9wOjVweDtkaXNwbGF5OmlubGluZS1ibG9jaztmbG9hdDpub25lIWltcG9ydGFudDt9CiN0b29sa2l0RG9jIC5pbnB1dFZhbG9yRmlqb0NoZWNrIHtwb3NpdGlvbjphYnNvbHV0ZTt9CiN0b29sa2l0RG9jIC5ldGlxdWV0YUNoZWNrIHtkaXNwbGF5OmJsb2NrO30KI3Rvb2xraXREb2MgLng0M2tfY2hlY2tfZGVjbGFyYWNpb25faW5zY3JpcGNpb25faW5wdXQge2Rpc3BsYXk6YmxvY2s7fQoKI3Rvb2xraXREb2MgLnNhbHRvRWxlbWVudG8ge2Rpc3BsYXk6YmxvY2s7fQoKI3Rvb2xraXREb2MgLnNhbHRvTGluZWFSYWRpbyB7ZGlzcGxheTppbmxpbmUtYmxvY2s7d2lkdGg6YXV0bzttYXJnaW4tbGVmdDowcHg7fQoKfQogICAgICA8L3N0eWxlPgogICA8L2hlYWQ+CiAgIDxib2R5PgogICA8ZGl2IGlkPSJ0b29sa2l0RG9jIj4KICAgICAgPGgxPkluc2NyaXBjacOzbiBlbiBlbCByZWdpc3RybyBkZSBtZWRpYWRvcmVzIGRlIHNlZ3Vyb3M8L2gxPgogICAgICAgICAJPGRpdiBjbGFzcz0idG9vbGtpdE4xIHByaW1lckVsZW1lbnRvIj4KCgoKCgk8ZGl2IGNsYXNzPSJ0b29sa2l0TjIgY29uTGFiZWwiIGlkPSJkYXRvc09yZ2Fub0dlc3RvciI+CgoJPGgyPkEgKMOzcmdhbm8gZ2VzdG9yKTo8L2gyPgk8ZGl2IGNsYXNzPSJ0b29sa2l0TiBib3JkZSI+Cgo8ZGl2IGNsYXNzPSJkaXZFbkxpbmVhQm9yZGVEZXJlY2hvIiBpZD0ibWFuYWdpbmdVbml0TmFtZSI+Cgk8bGFiZWw+CgkJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzEiPsKgPC9zcGFuPgoJCTxzcGFuIGNsYXNzPSJldGlxdWV0YUZvcm11bGFyaW8yIj5ESVJFQ0NJw5NOIERFIFBPTMONVElDQSBGSU5BTkNJRVJBIFkgUkVDVVJTT1MgSU5TVElUVUNJT05BTEVTPC9zcGFuPgoJPC9sYWJlbD4KPC9kaXY+CjwvZGl2Pgo8L2Rpdj4KCgoKCgoJPGRpdiBjbGFzcz0idG9vbGtpdE4yIGNvbkxhYmVsIiBpZD0iZGF0b3NQZXJzb25hbGVzIj4KCgk8aDI+RGF0b3MgcGVyc29uYWxlczwvaDI+CTxkaXYgY2xhc3M9InRvb2xraXROIGJvcmRlIj4KCjxkaXYgY2xhc3M9ImRpdkVuTGluZWEiIGlkPSJob2xkZXIxTmFtZSI+Cgk8bGFiZWw+CgkJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzEiPk5vbWJyZTo8L3NwYW4+CgkJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzIiPkNJVURBREFOTzwvc3Bhbj4KCTwvbGFiZWw+Cgk8c3BhbiBjbGFzcz0ic2FsdG8iPsKgPC9zcGFuPgo8L2Rpdj4KPGRpdiBjbGFzcz0iZGl2RW5MaW5lYUJvcmRlRGVyZWNobyIgaWQ9ImhvbGRlcjFBcGUxIj4KCTxsYWJlbD4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMSI+UHJpbWVyIGFwZWxsaWRvOjwvc3Bhbj4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMiI+RklDVElDSU88L3NwYW4+Cgk8L2xhYmVsPgo8L2Rpdj4KPGRpdiBjbGFzcz0iZGl2RW5MaW5lYSIgaWQ9ImhvbGRlcjFBcGUyIj4KCTxsYWJlbD4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMSI+U2VndW5kbyBhcGVsbGlkbzo8L3NwYW4+CgkJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzIiPkFDVElWTzwvc3Bhbj4KCTwvbGFiZWw+Cgk8c3BhbiBjbGFzcz0ic2FsdG8iPsKgPC9zcGFuPgo8L2Rpdj4KPGRpdiBjbGFzcz0iZGl2RW5MaW5lYUJvcmRlRGVyZWNobyIgaWQ9ImhvbGRlcjFUaXBvRG5pIj4KCTxsYWJlbD4KCTxzcGFuIGNsYXNzPSJldGlxdWV0YUZvcm11bGFyaW8xIj5Eb2N1bWVudG8gZGUgaWRlbnRpZmljYWNpw7NuOiA8L3NwYW4+Cgk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMiI+RE5JPC9zcGFuPgkJCgk8L2xhYmVsPgo8L2Rpdj4KPGRpdiBjbGFzcz0iZGl2RW5MaW5lYUJvcmRlRGVyZWNobyIgaWQ9ImhvbGRlcjFEbmkiPgoJPGxhYmVsPgoJCTxzcGFuIGNsYXNzPSJldGlxdWV0YUZvcm11bGFyaW8xIj5Ow7ptZXJvOjwvc3Bhbj4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMiI+OTk5OTk5OTBTPC9zcGFuPgoJPC9sYWJlbD4KPC9kaXY+CjwvZGl2Pgo8L2Rpdj4KCgoKCgoJPGRpdiBjbGFzcz0idG9vbGtpdE4yIGNvbkxhYmVsIiBpZD0iZGF0b3NOb3RpZmljYWNpb24iPgoKCTxoMj5DYW5hbCBkZSBub3RpZmljYWNpw7NuIHkgY29tdW5pY2FjacOzbjwvaDI+CTxkaXYgY2xhc3M9InRvb2xraXROIGJvcmRlIj4KCjxwPkVsZWN0csOzbmljbzogU2UgZW52w61hbiBhIGxhIGJhbmRlamEgZGUgbm90aWZpY2FjaW9uZXMgeSBjb211bmljYWNpb25lcyBkZSA8YSBocmVmPSJodHRwczovL2V1c2thZGkuZXVzL21pc2dlc3Rpb25lcyIgdGFyZ2V0PSJfYmxhbmsiPk1pcyBnZXN0aW9uZXM8L2E+LiBQYXJhIGFjY2VkZXIsIGVzIG5lY2VzYXJpbyB1biA8YSBocmVmPSJodHRwczovL2V1c2thZGkuZXVzL3kyMi1lZHVraS9lcy9jb250ZW5pZG9zL2luZm9ybWFjaW9uL2Vnb2l0emFfbmlyZV9nZXN0aW9ha19sYWd1bnR6YS9lc19lZ29pdHphL3IwMWhSZWRpcmVjdENvbnQvY29udGVuaWRvcy9pbmZvcm1hY2lvbi9jZXJ0aWZpY2Fkb3NfYWRtaXRpZG9zL2VzX2NlcnRfZWxlL2NlcnRpZmljYWRvc19lbGVjdHJvbmljb3MuaHRtbCIgdGFyZ2V0PSJfYmxhbmsiPm1lZGlvIGRlIGlkZW50aWZpY2FjacOzbiBlbGVjdHLDs25pY288L2E+LiA8YnIvPiA8c3BhbiBzdHlsZT0iZm9udC1zaXplOiAwLjg1ZW07Y29sb3I6ICNCMEIwQjA7Ij4gIE5vdGE6IFNpIGVuIDEwIGTDrWFzIG5hdHVyYWxlcyB1c3RlZCBubyBhY2NlZGUgYSB1bmEgbm90aWZpY2FjacOzbiBlbGVjdHLDs25pY2EsIHNlIGVudGVuZGVyw6EgcXVlIGxhIGhhIHJlY2hhemFkbzsgZWwgdHLDoW1pdGUgc2UgZGFyw6EgcG9yIHJlYWxpemFkbyB5IGxhIGFkbWluaXN0cmFjacOzbiBzZWd1aXLDoSBhZGVsYW50ZSBjb24gZWwgcHJvY2VkaW1pZW50by48L3NwYW4+PGJyLz48YnIvPjwvcD4KPC9kaXY+CjwvZGl2PgoKCgoKCgk8ZGl2IGNsYXNzPSJ0b29sa2l0TjIgY29uTGFiZWwiIGlkPSJkYXRvc0F2aXNvIj4KCgk8aDI+RGF0b3MgcGFyYSByZWNpYmlyIGF2aXNvczwvaDI+CTxkaXYgY2xhc3M9InRvb2xraXROIj4KCjxkaXYgY2xhc3M9IiIgaWQ9InJhZGlvRWxlZ2lyRGF0b3NBdmlzbyI+CgoJPGxhYmVsIGNsYXNzPSJsYWJlbERlUmFkaW8iPgoJCgkJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzEiPigqKSDCv0Rlc2VhIHV0aWxpemFyIGVsIHNpc3RlbWEgZGUgYXZpc29zIHByZXZpb3MgcG9yIGNvcnJlbyBlbGVjdHLDs25pY28gbyBTTVM/PGJyLz48YnIvPjwvc3Bhbj4KCQkJPHNwYW4gY2xhc3M9InNhbHRvTGluZWFSYWRpbyI+CgkJCgkJCQkJCTxzcGFuIGNsYXNzPSJzYWx0b0VsZW1lbnRvIj48aW5wdXQgY2hlY2tlZD0iY2hlY2tlZCIgY2xhc3M9ImlucHV0VmFsb3JGaWpvUmFkaW8iIGRpc2FibGVkPSJkaXNhYmxlZCIgdHlwZT0icmFkaW8iIHZhbHVlPSIxIi8+PHNwYW4gY2xhc3M9InRleHRvVmFsb3JGaWpvUmFkaW8iPjxiPk5vPC9iPjogTm8gcmVjaWJpcsOhIG5pbmfDum4gYXZpc28gY3VhbmRvIHNlIGxlIGVudsOtZSB1bmEgbm90aWZpY2FjacOzbiBvIGNvbXVuaWNhY2nDs24gKGVsZWN0csOzbmljYSBvIHBvc3RhbCk8L3NwYW4+PC9zcGFuPjxzcGFuIGNsYXNzPSJzYWx0byI+wqA8L3NwYW4+CgkJCQkJCTwvc3Bhbj4KCQkJPC9sYWJlbD4KCQo8L2Rpdj4KPC9kaXY+CjwvZGl2PgoKCgoKCgk8ZGl2IGNsYXNzPSJ0b29sa2l0TjIgY29uTGFiZWwiIGlkPSJkYXRvc0lkaW9tYSI+CgoJPGgyPklkaW9tYSBkZSBsYXMgbm90aWZpY2FjaW9uZXMsIGNvbXVuaWNhY2lvbmVzIHkgYXZpc29zPC9oMj4JPGRpdiBjbGFzcz0idG9vbGtpdE4iPgoKPGRpdiBjbGFzcz0iZGl2RW5MaW5lYSIgaWQ9ImRhdG9zY2hvaWNlSWRpb21hIj4KCQk8c3BhbiBjbGFzcz0ic2FsdG9MaW5lYVJhZGlvIj4KCQkKCQkJCQkJCTxzcGFuIGNsYXNzPSJzaW5TYWx0byI+PGlucHV0IGNoZWNrZWQ9ImNoZWNrZWQiIGNsYXNzPSJpbnB1dFZhbG9yRmlqb1JhZGlvIiBkaXNhYmxlZD0iZGlzYWJsZWQiIHR5cGU9InJhZGlvIiB2YWx1ZT0iRVMiLz48c3BhbiBjbGFzcz0idGV4dG9WYWxvckZpam9SYWRpbyI+Q2FzdGVsbGFubzwvc3Bhbj48L3NwYW4+CgkJCQkJPC9zcGFuPgoJCQo8L2Rpdj4KPC9kaXY+CjwvZGl2PgoKCgoKCgk8ZGl2IGNsYXNzPSJ0b29sa2l0TjIiIGlkPSJMT1BEIj4KCgk8ZGl2IGNsYXNzPSJ0b29sa2l0TiI+CgoKCgoKCTxkaXYgY2xhc3M9InRvb2xraXROMyBjb25MYWJlbCIgaWQ9ImRhdG9zTE9QRCI+CgoJPGgyPlByb3RlY2Npw7NuIGRlIERhdG9zIGRlIENhcsOhY3RlciBQZXJzb25hbCAoTE9QRCk8L2gyPgk8ZGl2IGNsYXNzPSJ0b29sa2l0TiI+Cgo8cD5Mb3MgZGF0b3MgZGUgZXN0YSBzb2xpY2l0dWQgcGFzYW4gYSBmb3JtYXIgcGFydGUgZGUgdW4gZmljaGVybyBjb24gbGFzIHNpZ3VpZW50ZXMgY2FyYWN0ZXLDrXN0aWNhczo8L3A+CjxwPi0gTm9tYnJlOiBSZWdpc3RybyBkZSBwZXJzb25hcyBtZWRpYWRvcmFzIGRlIHNlZ3Vyb3M8L3A+CjxwPi0gUmVndWxhZG8gcG9yOiBPUkRFTiBkZSAyOCBkZSBmZWJyZXJvIGRlIDIwMTQgZGVsIENvbnNlamVybyBkZSBIYWNpZW5kYSB5IEZpbmFuemFzIGRlIGZpY2hlcm9zIGRlIGRhdG9zIGRlIGNhcsOhY3RlciBwZXJzb25hbCBkZWwgRGVwYXJ0YW1lbnRvIGRlIEhhY2llbmRhIHkgRmluYW56YXMgeSBkZSBsb3Mgb3JnYW5pc21vcyBhdXTDs25vbW9zIEV1c2thbCBFc3RhdMOtc3Rpa2EgRXJha3VuZGVhIC8gSW5zdGl0dXRvIFZhc2NvIGRlIEVzdGFkw61zdGljYSB5IEF1dG9yaWRhZCBWYXNjYSBkZSBsYSBDb21wZXRlbmNpYTwvcD4KPHA+LSBUaXR1bGFyOiBEaXJlY2Npw7NuIGRlIFBvbMOtdGljYSBGaW5hbmNpZXJhIHkgUmVjdXJzb3MgSW5zdGl0dWNpb25hbGVzLjwvcD4KPHA+LSBGaW5hbGlkYWQ6IEluc2NyaXBjacOzbiBkZSBwZXJzb25hcyBtZWRpYWRvcmFzIGRlIHNlZ3Vyb3MsIGNvcnJlZG9yYXMgZGUgcmVhc2VndXJvcyB5IHN1cyBhbHRvcyBjYXJnb3MsIHF1ZSByZWFsaXphbiBsYSBhY3RpdmlkYWQgbWVyY2FudGlsIGVuIHNlZ3Vyb3MgcHJpdmFkb3MuPC9wPgo8cD5FbCBmaWNoZXJvIGhhIHNpZG8gcHJldmlhbWVudGUgbm90aWZpY2FkbyBhIGxhIEFnZW5jaWEgVmFzY2EgZGUgUHJvdGVjY2nDs24gZGUgRGF0b3MgeSBjdWVudGEgY29uIGxhcyBtZWRpZGFzIGRlIHNlZ3VyaWRhZCBuZWNlc2FyaWFzLiBMb3MgZGF0b3MgY29udGVuaWRvcyBubyBzZXLDoW4gY29tdW5pY2Fkb3MgYSB0ZXJjZXJhcyBwYXJ0ZXMsIGV4Y2VwdG8gZW4gbG9zIHN1cHVlc3RvcyBwcmV2aXN0b3MgZW4gbGEgbGV5LjwvcD4KPHA+UGFyYSBlamVyY2VyIGxvcyBkZXJlY2hvcyBkZSBhY2Nlc28sIGNhbmNlbGFjacOzbiwgcmVjdGlmaWNhY2nDs24geSBvcG9zaWNpw7NuIHF1ZSBleHByZXNhbWVudGUgcmVjb25vY2UgbGEgTE9QRCwgcHVlZGUgcG9uZXJzZSBlbiBjb250YWN0byBjb24gbGEgRGlyZWNjacOzbiBjb3JyZXNwb25kaWVudGUgZGVsIEdvYmllcm5vIFZhc2NvOiA8L3A+CjxwPmMvIERvbm9zdGlhLVNhbiBTZWJhc3RpYW4sMS4gMDEwMTAgVml0b3JpYS1HYXp0ZWl6PC9wPgo8L2Rpdj4KPC9kaXY+CjwvZGl2Pgo8L2Rpdj4KCgoJPC9kaXY+Cgk8ZGl2IGNsYXNzPSJ0b29sa2l0TjEiPgoKCgoKCTxkaXYgY2xhc3M9InRvb2xraXROMiBjb25MYWJlbCIgaWQ9ImRlY2xhcmFjaW9uQW1iaXRvVGVycml0b3JpYWwiPgoKCTxoMj7DgW1iaXRvIHRlcnJpdG9yaWFsIGRlIGFjdHVhY2nDs248L2gyPgk8ZGl2IGNsYXNzPSJ0b29sa2l0TiBib3JkZSI+Cgo8cD5FbiB2aXJ0dWQgZGUgbGEgZGlzdHJpYnVjacOzbiBkZSBjb21wZXRlbmNpYXMgZW50cmUgbGEgQWRtaW5pc3RyYWNpw7NuIEdlbmVyYWwgZGVsIEVzdGFkbyB5IGxhcyBDb211bmlkYWRlcyBBdXTDs25vbWFzIGVzdGFibGVjaWRhIGVuIGVsIGFydMOtY3VsbyA0NyBkZSBsYSBMZXkgMjYvMjAwNiwgZGUgMTcgZGUganVsaW8sIGRlIG1lZGlhY2nDs24gZGUgc2VndXJvcyB5IHJlYXNlZ3Vyb3MgcHJpdmFkb3M6PC9wPgoKICAgICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzcz0iZGl2RW5MaW5lYUJvcmRlRGVyZWNobyIgaWQ9ImFtYml0byI+CiAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICA8ZGl2PgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAJICAgICAgICAgICAgICAgCSAgPHNwYW4gY2xhc3M9ImV0aXF1ZXRhQ2hlY2siPjxpbnB1dCBjaGVja2VkPSJjaGVja2VkIiBjbGFzcz0iaW5wdXRWYWxvckZpam9DaGVjayIgZGlzYWJsZWQ9ImRpc2FibGVkIiB0eXBlPSJjaGVja2JveCIgdmFsdWU9IjEiLz48c3BhbiBjbGFzcz0idGV4dG9WYWxvckZpam9DaGVjayI+KiBEZWNsYXJhIHF1ZSBlbCDDoW1iaXRvIGRlIG9wZXJhY2lvbmVzIGVuIGVsIHF1ZSB2YSBhIGVqZXJjZXIgc3UgYWN0aXZpZGFkIGNvbW8gbWVkaWFkb3IgZGUgc2VndXJvcyA8Yj4gU0UgTElNSVRBIGFsIMOhbWJpdG8gdGVycml0b3JpYWwgZGUgbGEgQ29tdW5pZGFkIEF1dMOzbm9tYSBkZWwgUGHDrXMgVmFzY288L2I+Ljwvc3Bhbj48L3NwYW4+CiAgICAgICAgICAgICAgIAkgICAgICAgICAgICAgICAgICAgICAgICAJPC9kaXY+CiAgICAgICAgICAgICAgIDwvZGl2PgogICAKPGRpdiBjbGFzcz0iZGl2RW5MaW5lYUJvcmRlRGVyZWNobyIgaWQ9ImF2aXNvdmluY3Vsb3MyIj4KCTxsYWJlbD4KCQk8aT5OT1RBOiBFeCBhcnTDrWN1bG8gNDcuIDMgZGUgbGEgTGV5IDI2LzIwMDYsIGxhIGNvbXBldGVuY2lhIGRlIGxhIEFkbWluaXN0cmFjacOzbiBkZSBsYSBDb211bmlkYWQgQXV0w7Nub21hIGRlbCBQYcOtcyBWYXNjbyBlc3TDoSBkZWxpbWl0YWRhIHBvciBsYSBjb25jdXJyZW5jaWEgZGUgbG9zIHB1bnRvcyBkZSBjb25leGnDs24gZG9taWNpbGlvIHNvY2lhbCB5IMOhbWJpdG8gZGUgb3BlcmFjaW9uZXMgZW4gZWwgdGVycml0b3JpbyBkZSBsYSBDb211bmlkYWQgQXV0w7Nub21hLiBDdWFuZG8gZXN0b3Mgbm8gc2UgZGFuLCBwb3JxdWUgc2UgZXh0aWVuZGUgZWwgw6FtYml0byBkZSBvcGVyYWNpb25lcyBhIG3DoXMgZGUgdW5hIENvbXVuaWRhZCBBdXTDs25vbWEsIGVsIG1lZGlhZG9yIGRlYmUgaW5zY3JpYmlyc2UgZW4gZWwgUmVnaXN0cm8gZGUgTWVkaWFkb3JlcyBkZSBTZWd1cm9zIGRlIGxhIERpcmVjY2nDs24gR2VuZXJhbCBkZSBTZWd1cm9zLiBQb3IgZmF2b3IsIE5PIENPTlRJTsOaRSBjb24gbGEgc29saWNpdHVkLjwvaT4KCTwvbGFiZWw+CjwvZGl2Pgo8L2Rpdj4KPC9kaXY+CgoKCgoKCTxkaXYgY2xhc3M9InRvb2xraXROMiBjb25MYWJlbCIgaWQ9IkdydXBvdGlwb21lZGlhZG9yIj4KCgk8aDI+VGlwbyBkZSBtZWRpYWRvcjo8L2gyPgk8ZGl2IGNsYXNzPSJ0b29sa2l0TiBib3JkZSI+Cgo8ZGl2IGNsYXNzPSJkaXZFbkxpbmVhIiBpZD0iTGlzdGF0aXBvTWVkaWFkb3IiPgoJPGxhYmVsPgoJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzEiPlRpcG8gZGUgbWVkaWFkb3I8L3NwYW4+Cgk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMiI+QWdlbnRlIGRlIHNlZ3Vyb3MgdmluY3VsYWRvICAgIDwvc3Bhbj4JCQoJPC9sYWJlbD4KCTxzcGFuIGNsYXNzPSJzYWx0byI+wqA8L3NwYW4+CjwvZGl2Pgo8L2Rpdj4KPC9kaXY+CgoKCgoKCTxkaXYgY2xhc3M9InRvb2xraXROMiBjb25MYWJlbCIgaWQ9ImRpcmVjY2lvbkFjdGl2aWRhZCI+CgoJPGgyPkRvbWljaWxpbyBhY3RpdmlkYWQ8L2gyPgk8ZGl2IGNsYXNzPSJ0b29sa2l0TiBib3JkZSI+Cgo8ZGl2IGNsYXNzPSJkaXZFbkxpbmVhQm9yZGVEZXJlY2hvIiBpZD0ibGlzdGFQcm92aW5jaWEiPgoJPGxhYmVsPgoJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzEiPlRlcnJpdG9yaW8gSGlzdMOzcmljbzo8L3NwYW4+Cgk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMiI+w4FsYXZhPC9zcGFuPgkJCgk8L2xhYmVsPgo8L2Rpdj4KPGRpdiBjbGFzcz0iZGl2RW5MaW5lYSIgaWQ9Imxpc3RhTXVuaWNpcGlvIj4KCTxsYWJlbD4KCTxzcGFuIGNsYXNzPSJldGlxdWV0YUZvcm11bGFyaW8xIj5NdW5pY2lwaW86PC9zcGFuPgoJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzIiPkFtdXJyaW88L3NwYW4+CQkKCTwvbGFiZWw+Cgk8c3BhbiBjbGFzcz0ic2FsdG8iPsKgPC9zcGFuPgo8L2Rpdj4KPGRpdiBjbGFzcz0iZGl2RW5MaW5lYUJvcmRlRGVyZWNobyIgaWQ9IkNhbXBvQmFzaWNvQ2FsbGUiPgoJPGxhYmVsPgoJCTxzcGFuIGNsYXNzPSJldGlxdWV0YUZvcm11bGFyaW8xIj5EaXJlY2Npw7NuOjwvc3Bhbj4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMiI+QVFBQUEga2FsZWE8L3NwYW4+Cgk8L2xhYmVsPgo8L2Rpdj4KPGRpdiBjbGFzcz0iZGl2RW5MaW5lYUJvcmRlRGVyZWNobyIgaWQ9IkNhbXBvQmFzaWNvUG9ydGFsIj4KCTxsYWJlbD4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMSI+TsK6Ojwvc3Bhbj4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMiI+Mzwvc3Bhbj4KCTwvbGFiZWw+CjwvZGl2Pgo8ZGl2IGNsYXNzPSJkaXZFbkxpbmVhQm9yZGVEZXJlY2hvIiBpZD0iQ2FtcG9CYXNpY29QaXNvIj4KCTxsYWJlbD4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMSI+UGlzbzo8L3NwYW4+CgkJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzIiPmJham88L3NwYW4+Cgk8L2xhYmVsPgo8L2Rpdj4KPGRpdiBjbGFzcz0iZGl2RW5MaW5lYSIgaWQ9IkNhbXBvQmFzaWNvQ3AiPgoJPGxhYmVsPgoJCTxzcGFuIGNsYXNzPSJldGlxdWV0YUZvcm11bGFyaW8xIj5Dw7NkaWdvIHBvc3RhbDo8L3NwYW4+CgkJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzIiPjAxMTIzPC9zcGFuPgoJPC9sYWJlbD4KCTxzcGFuIGNsYXNzPSJzYWx0byI+wqA8L3NwYW4+CjwvZGl2Pgo8ZGl2IGNsYXNzPSJkaXZFbkxpbmVhQm9yZGVEZXJlY2hvIiBpZD0iQ2FtcG9CYXNpY29UZm5vIj4KCTxsYWJlbD4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMSI+VGVsw6lmb25vOjwvc3Bhbj4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMiI+OTQ1NDQ1NTY2PC9zcGFuPgoJPC9sYWJlbD4KPC9kaXY+CjxkaXYgY2xhc3M9ImRpdkVuTGluZWFCb3JkZURlcmVjaG8iIGlkPSJDYW1wb0Jhc2ljb2VtYWlsIj4KCTxsYWJlbD4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMSI+Q29ycmVvIGVsZWN0csOzbmljbzo8L3NwYW4+CgkJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzIiPnBydUBnbWFpbC5jb208L3NwYW4+Cgk8L2xhYmVsPgo8L2Rpdj4KPGRpdiBjbGFzcz0iZGl2RW5MaW5lYUJvcmRlRGVyZWNobyIgaWQ9IkNhbXBvQmFzaWNvd2ViIj4KCTxsYWJlbD4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMSI+RGlyZWNjacOzbiB3ZWI6PC9zcGFuPgoJCTxzcGFuIGNsYXNzPSJldGlxdWV0YUZvcm11bGFyaW8yIj53d3cucHJ1ZWJhLmNvbTwvc3Bhbj4KCTwvbGFiZWw+CjwvZGl2Pgo8L2Rpdj4KPC9kaXY+CgoKCgoKCgoKCgoJPGRpdiBjbGFzcz0idG9vbGtpdE4yIGNvbkxhYmVsIiBpZD0iZW1wcmVzYXN2aW5jdWxhZGFzIj4KCgk8aDI+RW50aWRhZGVzIGFzZWd1cmFkb3JhcyBjb24gbGFzIHF1ZSBsYSBwZXJzb25hIG1lZGlhZG9yYSBkZSBzZWd1cm9zIHRpZW5lIHZpbmN1bGFjacOzbjwvaDI+CTxkaXYgY2xhc3M9InRvb2xraXROIGJvcmRlIj4KCjxwPkRlYmVyw6EgaW5kaWNhciBsb3MgZGF0b3MgZGUgbGFzIGVudGlkYWRlcyBhc2VndXJhZG9yYXMgY29uIGxhcyBjdWFsZXMgdGllbmUgdmluY3VsYWNpw7NuLjwvcD4KPGRpdiBjbGFzcz0idG9vbGtpdE4iIGlkPSJ1cmxER1MiPgoJPHRhYmxlIHN0eWxlPSIgIj4KCQk8dGhlYWQ+CgkJCTx0cj4KCQkJCTx0aCBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMSI+RW50aWRhZCBhc2VndXJhZG9yYTwvdGg+CgkJCQk8dGggY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzEiPkNJRjwvdGg+CgkJCQk8dGggY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzEiPkNsYXZlIERHUzwvdGg+CgkJCTwvdHI+CgkJPC90aGVhZD4KCQk8dGJvZHk+CgkJCTx0ciBpZD0idXJsREdTMCI+CgkJCQk8dGQgc3R5bGU9IndvcmQtYnJlYWs6IGJyZWFrLWFsbCI+YmlsYmFvPC90ZD4KCQkJCTx0ZCBzdHlsZT0id29yZC1icmVhazogYnJlYWstYWxsIj4gIEE0ODAwMTY0ODwvdGQ+CgkJCQk8dGQgc3R5bGU9IndvcmQtYnJlYWs6IGJyZWFrLWFsbCI+QzAwMjY8L3RkPgoJCQk8L3RyPgoJCQk8dHIgaWQ9InVybERHUzEiPgoJCQkJPHRkIHN0eWxlPSJ3b3JkLWJyZWFrOiBicmVhay1hbGwiPnNhbnRhbmRlcjwvdGQ+CgkJCQk8dGQgc3R5bGU9IndvcmQtYnJlYWs6IGJyZWFrLWFsbCI+QTQ2MDAzMjczPC90ZD4KCQkJCTx0ZCBzdHlsZT0id29yZC1icmVhazogYnJlYWstYWxsIj5DMDAzNzwvdGQ+CgkJCTwvdHI+CgkJPC90Ym9keT4KCTwvdGFibGU+CjwvZGl2Pgo8L2Rpdj4KPC9kaXY+CgoKCgoKCTxkaXYgY2xhc3M9InRvb2xraXROMiBjb25MYWJlbCIgaWQ9ImNhcGFjaWRhZCI+CgoJPGgyPkNhcGFjaWRhZCBmaW5hbmNpZXJhPC9oMj4JPGRpdiBjbGFzcz0idG9vbGtpdE4gYm9yZGUiPgoKPGRpdiBjbGFzcz0iZGl2RW5MaW5lYUJvcmRlRGVyZWNobyIgaWQ9ImF2aXNvZGVjbGFybzEiPgoJPGxhYmVsPgoJCTxpPkRlYmUgY3VtcGxpbWVudGFyIGxhIHBlc3Rhw7FhICdDYXBhY2lkYWQgRmluYW5jaWVyYScgeSBhcG9ydGFyIGFkZW3DoXMgZW4gZWwgcGFzbyAyICdkb2N1bWVudG9zJyBjb3BpYSBkZWwgYXZhbCBlbWl0aWRvIHBvciBsYSBlbnRpZGFkIGZpbmFuY2llcmEgbyB1biBzZWd1cm8gZGUgY2F1Y2nDs24uPC9pPgoJPC9sYWJlbD4KPC9kaXY+CjxkaXYgY2xhc3M9ImRpdkVuTGluZWFCb3JkZURlcmVjaG8iIGlkPSJkZWNsYXJvY2FwYWNpZGFkIj4KCQk8c3BhbiBjbGFzcz0ic2FsdG9MaW5lYVJhZGlvIj4KCQkKCQkJCQkJPHNwYW4gY2xhc3M9InNhbHRvRWxlbWVudG8iPjxpbnB1dCBjaGVja2VkPSJjaGVja2VkIiBjbGFzcz0iaW5wdXRWYWxvckZpam9SYWRpbyIgZGlzYWJsZWQ9ImRpc2FibGVkIiB0eXBlPSJyYWRpbyIgdmFsdWU9IjEiLz48c3BhbiBjbGFzcz0idGV4dG9WYWxvckZpam9SYWRpbyI+VGllbmUgY2FwYWNpZGFkIGZpbmFuY2llcmEuPC9zcGFuPjwvc3Bhbj48c3BhbiBjbGFzcz0ic2FsdG8iPsKgPC9zcGFuPgoJCQkJCQkJPC9zcGFuPgoJCQo8L2Rpdj4KPC9kaXY+CjwvZGl2PgoKCgk8L2Rpdj4KCTxkaXYgY2xhc3M9InRvb2xraXROMSI+CgoKCgoJPGRpdiBjbGFzcz0idG9vbGtpdE4yIGNvbkxhYmVsIiBpZD0iY2FsY3Vsb0NhcGFjaWRhZEZpbmFuY2llcmEiPgoKCTxoMj5Dw6FsY3VsbyBjYXBhY2lkYWQgZmluYW5jaWVyYTwvaDI+CTxkaXYgY2xhc3M9InRvb2xraXROIGJvcmRlIj4KCjxwPjEuLSBEZWNsYXJvIHF1ZSAgbGEgYWNyZWRpdGFjacOzbiBkZWwgcmVxdWlzaXRvIGRlIGNhcGFjaWRhZCBmaW5hbmNpZXJhIHBhcmEgZWplcmNlciBsYSBhY3RpdmlkYWQgZGUgbWVkaWFjacOzbiBkZSBzZWd1cm9zIGNvbW8gY29ycmVkb3IgIGRlIHNlZ3Vyb3MsIHBlcnNvbmEgZsOtc2ljYSBjb25mb3JtZSBhIGxvIGV4aWdpZG8gZW4gIGxhIGRpc3Bvc2ljacOzbiB0cmFuc2l0b3JpYSB0ZXJjZXJhICBkZSBsYSBMZXkgIDI2LzIwMDYsICBzZSAgIHJlYWxpemEgY29uIGFycmVnbG8gIGEgbGFzIHNpZ3VpZW50ZXMgY2FudGlkYWRlczo8L3A+CjxwPkEpICA0JSAgZGUgbG9zICBGb25kb3MgcGVyY2liaWRvcyAgZGUgIGxvcyBjbGllbnRlcyBlbiBjb25jZXB0byBkZSAgcGFnb3MgZGUgcmVjaWJvcyBkZSBwcmltYXMgZGUgc2VndXJvcyBjb3JyZXNwb25kaWVudGVzIGEgbG9zIDEyIG1lc2VzIGFudGVyaW9yZXMgYSAgYXF1ZWwgZW4gcXVlIHNlIGNvbnN0aXR1eWUgIGxhIGdhcmFudMOtYSwgZGUgYWN1ZXJkbyBjb24gZWwgc2lndWllbnRlICBjw6FsY3Vsbzo8L3A+CjxkaXYgY2xhc3M9ImRpdkVuTGluZWEiIGlkPSJpbXBvcnRlRm9uZG9zUGVyZGlkb3MiPgoJPGxhYmVsPgoJCTxzcGFuIGNsYXNzPSJldGlxdWV0YUZvcm11bGFyaW8xIj4tSW1wb3J0ZSB0b3RhbCAgZGUgbG9zICBmb25kb3MgcGVyY2liaWRvcyAoZXVyb3MpOiA8L3NwYW4+CgkJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzIiPjMwMDAwMDwvc3Bhbj4KCTwvbGFiZWw+Cgk8c3BhbiBjbGFzcz0ic2FsdG8iPsKgPC9zcGFuPgo8L2Rpdj4KPGRpdiBjbGFzcz0iZGl2RW5MaW5lYSIgaWQ9ImltcG9ydGVDdWF0cm9Qb3JjaWVudG8iPgoJPGxhYmVsPgoJCTxzcGFuIGNsYXNzPSJldGlxdWV0YUZvcm11bGFyaW8xIj4tIDQlIChldXJvcyk6IDwvc3Bhbj4KCQk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMiI+MTIwMDA8L3NwYW4+Cgk8L2xhYmVsPgoJPHNwYW4gY2xhc3M9InNhbHRvIj7CoDwvc3Bhbj4KPC9kaXY+CjxwPkIpIEltcG9ydGUgIG3DrW5pbW8gPSAxOC43NjAgIGV1cm9zIChSZXNvbHVjacOzbiBkZSAyMyBkZSBTZXB0aWVtYnJlIGRlIDIwMDgsIGRlIGxhIERpcmVjY2nDs24gR2VuZXJhbCBkZSBTZWd1cm9zIHkgRm9uZG9zIGRlIFBlbnNpb25lcykuPC9wPgo8ZGl2IGNsYXNzPSJkaXZFbkxpbmVhIiBpZD0iaW1wb3J0ZUNhcGFjaWRhZCI+Cgk8bGFiZWw+CgkJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzEiPi08Yj5JbXBvcnRlIGRlIGxhIGNhcGFjaWRhZCBmaW5hbmNpZXJhPC9iPiBDaWZyYSBtYXlvciBlbnRyZSAnQScgeSAnQicgKGV1cm9zKTo8L3NwYW4+CgkJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzIiPjE4NzYwPC9zcGFuPgoJPC9sYWJlbD4KCTxzcGFuIGNsYXNzPSJzYWx0byI+wqA8L3NwYW4+CjwvZGl2Pgo8ZGl2IGNsYXNzPSJkaXZFbkxpbmVhQm9yZGVEZXJlY2hvIiBpZD0iY29udHJhdGFBdmFsMSI+Cgk8bGFiZWw+Cgk8c3BhbiBjbGFzcz0iZXRpcXVldGFGb3JtdWxhcmlvMSI+Mi4tIEEgZGljaG9zIGVmZWN0b3Mgc2UgY29udHJhdGEgKHNlw7FhbGFyIGVsIHF1ZSBwcm9jZWRhKTogPC9zcGFuPgoJPC9sYWJlbD4KPC9kaXY+CgoKCgoJPGRpdiBjbGFzcz0idG9vbGtpdE4zIiBpZD0iY29udHJhdGFBdmFsIj4KCgk8ZGl2IGNsYXNzPSJ0b29sa2l0TiBib3JkZSI+CgoKCiAgICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9ImRpdkVuTGluZWFCb3JkZURlcmVjaG8iIGlkPSJzZWd1cm8iPgogICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgPGRpdj4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCSAgICAgICAgICAgICAgIAkgIDxzcGFuIGNsYXNzPSJldGlxdWV0YUNoZWNrIj48aW5wdXQgY2hlY2tlZD0iY2hlY2tlZCIgY2xhc3M9ImlucHV0VmFsb3JGaWpvQ2hlY2siIGRpc2FibGVkPSJkaXNhYmxlZCIgdHlwZT0iY2hlY2tib3giIHZhbHVlPSIyIi8+PHNwYW4gY2xhc3M9InRleHRvVmFsb3JGaWpvQ2hlY2siPlNlZ3VybyBkZSBjYXVjacOzbiBjb24gbGEgZW50aWRhZCBhc2VndXJhZG9yYSA8L3NwYW4+PC9zcGFuPgogICAgICAgICAgICAgICAJICAgICAgICAgICAgICAgICAgICAgICAgCTwvZGl2PgogICAgICAgICAgICAgICA8L2Rpdj4KICAgCjxkaXYgY2xhc3M9ImRpdkVuTGluZWEiIGlkPSJjb250cmF0YVNlZ3VybyI+Cgk8bGFiZWw+CgkJPHNwYW4gY2xhc3M9ImV0aXF1ZXRhRm9ybXVsYXJpbzEiPsKgPC9zcGFuPgoJCTxzcGFuIGNsYXNzPSJldGlxdWV0YUZvcm11bGFyaW8yIj5jYXVjacOzbjwvc3Bhbj4KCTwvbGFiZWw+Cgk8c3BhbiBjbGFzcz0ic2FsdG8iPsKgPC9zcGFuPgo8L2Rpdj4KPC9kaXY+CjwvZGl2Pgo8cD4zLi0gQXNpbWlzbW8sICBkZWNsYXJvIGFudGUgbGEgRGlyZWNjacOzbiBkZSBQb2zDrXRpY2EgRmluYW5jaWVyYSB5IFJlY3Vyc29zIEluc3RpdHVjaW9uYWxlcyBkZWwgR29iaWVybm8gVmFzY28gYXN1bWlyIGVsIGNvbXByb21pc28gZGUgYWN0dWFsaXphciBlbCBpbXBvcnRlIGRlIGxhIGNhcGFjaWRhZCBmaW5hbmNpZXJhLCBhIGZpbiBkZSBtYW50ZW5lciBsYSAgaW5zY3JpcGNpw7NuIGVuIGVsIFJlZ2lzdHJvIGFkbWluaXN0cmF0aXZvIGVzcGVjaWFsIGRlIG1lZGlhZG9yZXMgZGUgU2VndXJvcywgY29ycmVkb3JlcyBkZSBTZWd1cm9zIHkgc3VzIGFsdG9zIGNhcmdvcywgIGRlIGFjdWVyZG8gY29uIGxvIGVzdGFibGVjaWRvIGVuIGxhIGxleSAgMjYvMjAwNiwgZGUgbWVkaWFjacOzbiBkZSBzZWd1cm9zIHkgZGUgcmVhc2VndXJvcyBwcml2YWRvcy48L3A+CjwvZGl2Pgo8L2Rpdj4KCgoJPC9kaXY+Cgk8ZGl2IGNsYXNzPSJ0b29sa2l0TjEiPgoKCTwvZGl2PgoJPGRpdiBjbGFzcz0idG9vbGtpdE4xIj4KCgoKCgk8ZGl2IGNsYXNzPSJ0b29sa2l0TjIgY29uTGFiZWwiIGlkPSJncnVwb19kZWNsYXJhY2lvbmVzIj4KCgk8aDI+RGVjbGFyYWNpb25lcyByZXNwb25zYWJsZXM8L2gyPgk8ZGl2IGNsYXNzPSJ0b29sa2l0TiBib3JkZSI+Cgo8cD48Yj5QZXJzb25hIHRpdHVsYXI6PC9iPiAgPGJyLz5Vc3RlZCBkZWNsYXJhLCBiYWpvIHN1IHJlc3BvbnNhYmlsaWRhZCwgbGEgdmVyYWNpZGFkIGRlbCBjb250ZW5pZG8gZGUgZXN0YXMgZGVjbGFyYWNpb25lcy4gTGEgQWRtaW5pc3RyYWNpw7NuIHB1ZWRlIGRlY2lkaXIgbm8gY29udGludWFyIGNvbiBlbCBwcm9jZWRpbWllbnRvIGVuIGNhc28gZGUgY3VhbHF1aWVyIGluZXhhY3RpdHVkLCBmYWxzZWRhZCB1IG9taXNpw7NuIC1kZSBjYXLDoWN0ZXIgZXNlbmNpYWwtIGVuIGxvcyBkYXRvcyBkZSBsYXMgZGVjbGFyYWNpb25lcyByZXNwb25zYWJsZXMsIHNpbiBwZXJqdWljaW8gZGUgb3RyYXMgcmVzcG9uc2FiaWxpZGFkZXMgcGVuYWxlcywgY2l2aWxlcyBvIGFkbWluaXN0cmF0aXZhcy48L3A+CgoKCgoJPGRpdiBjbGFzcz0idG9vbGtpdE4zIiBpZD0iZGVjbGFyYWNpb25lc1Jlc3BvbnNhYmxlcyI+CgoJPGRpdiBjbGFzcz0idG9vbGtpdE4iPgoKCgoKCgk8ZGl2IGNsYXNzPSJ0b29sa2l0TjQiIGlkPSJkZWNsYXJhY2lvbkVzcGVjaWZpY2EiPgoKCTxkaXYgY2xhc3M9InRvb2xraXROIj4KCgoKCgoKCgoJPGRpdiBjbGFzcz0idG9vbGtpdE40IGNvbkxhYmVsIiBpZD0iZ3J1cG9EZWNsYXJhY0hvbm9yYWJpbGlkYWQiPgoKCTxoMj5Ib25vcmFiaWxpZGFkIGNvbWVyY2lhbCB5IHByb2Zlc2lvbmFsPC9oMj4JPGRpdiBjbGFzcz0idG9vbGtpdE4gYm9yZGUiPgoKCiAgICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9ImRpdkVuTGluZWEiIGlkPSJkZWNsYXJhY2lvbl9lc3BlY2lmaWNhMiI+CiAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICA8ZGl2PgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAJICAgICAgICAgICAgICAgCSAgPHNwYW4gY2xhc3M9ImV0aXF1ZXRhQ2hlY2siPjxpbnB1dCBjaGVja2VkPSJjaGVja2VkIiBjbGFzcz0iaW5wdXRWYWxvckZpam9DaGVjayIgZGlzYWJsZWQ9ImRpc2FibGVkIiB0eXBlPSJjaGVja2JveCIgdmFsdWU9IjEiLz48c3BhbiBjbGFzcz0idGV4dG9WYWxvckZpam9DaGVjayI+KiBIYSBvYnNlcnZhZG8gdW5hIHRyYXllY3RvcmlhIHBlcnNvbmFsIGRlIHJlc3BldG8gYSBsYXMgbGV5ZXMgbWVyY2FudGlsZXMgeSBvdHJhcyBxdWUgcmVndWxhbiBsYSBhY3RpdmlkYWQgZWNvbsOzbWljYSB5IGxhIHZpZGEgZGUgbG9zIG5lZ29jaW9zLCBhc8OtIGNvbW8gYSBsYXMgYnVlbmFzIHByw6FjdGljYXMgY29tZXJjaWFsZXMsIGZpbmFuY2llcmFzIHkgZGUgc2VndXJvcy48L3NwYW4+PC9zcGFuPgogICAgICAgICAgICAgICAJICAgICAgICAgICAgICAgICAgICAgICAgCTwvZGl2PgogICAgICAgICAgICAgICA8L2Rpdj4KICAgCgogICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzPSJkaXZFbkxpbmVhIiBpZD0iZGVjbGFyYWNpb25fZXNwZWNpZmljYTMiPgogICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgPGRpdj4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCSAgICAgICAgICAgICAgIAkgIDxzcGFuIGNsYXNzPSJldGlxdWV0YUNoZWNrIj48aW5wdXQgY2hlY2tlZD0iY2hlY2tlZCIgY2xhc3M9ImlucHV0VmFsb3JGaWpvQ2hlY2siIGRpc2FibGVkPSJkaXNhYmxlZCIgdHlwZT0iY2hlY2tib3giIHZhbHVlPSIxIi8+PHNwYW4gY2xhc3M9InRleHRvVmFsb3JGaWpvQ2hlY2siPiogTm8gZXN0w6EgaW5oYWJpbGl0YWRhIHBhcmEgZWplcmNlciBjYXJnb3MgcMO6YmxpY29zIG8gZGUgYWRtaW5pc3RyYWNpw7NuIG8gZGlyZWNjacOzbiBlbiBlbnRpZGFkZXMgZmluYW5jaWVyYXMsIGFzZWd1cmFkb3JhcyBvIGRlIG1lZGlhY2nDs24gZGUgc2VndXJvcyBvIGRlIHJlYXNlZ3Vyb3MuPC9zcGFuPjwvc3Bhbj4KICAgICAgICAgICAgICAgCSAgICAgICAgICAgICAgICAgICAgICAgIAk8L2Rpdj4KICAgICAgICAgICAgICAgPC9kaXY+CiAgIAoKICAgICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzcz0iZGl2RW5MaW5lYSIgaWQ9ImRlY2xhcmFjaW9uX2VzcGVjaWZpY2E0Ij4KICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgIDxkaXY+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAkgICAgICAgICAgICAgICAJICA8c3BhbiBjbGFzcz0iZXRpcXVldGFDaGVjayI+PGlucHV0IGNoZWNrZWQ9ImNoZWNrZWQiIGNsYXNzPSJpbnB1dFZhbG9yRmlqb0NoZWNrIiBkaXNhYmxlZD0iZGlzYWJsZWQiIHR5cGU9ImNoZWNrYm94IiB2YWx1ZT0iMSIvPjxzcGFuIGNsYXNzPSJ0ZXh0b1ZhbG9yRmlqb0NoZWNrIj4qIE5vIGhhIHNpZG8gaW5oYWJpbGl0YWRhIGNvbmZvcm1lIGEgbG8gZGlzcHVlc3RvIGVuIGxhIExleSBDb25jdXJzYWwgMjIvMjAwMywgZGUgOSBkZSBqdWxpby48L3NwYW4+PC9zcGFuPgogICAgICAgICAgICAgICAJICAgICAgICAgICAgICAgICAgICAgICAgCTwvZGl2PgogICAgICAgICAgICAgICA8L2Rpdj4KICAgCgogICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzPSJkaXZFbkxpbmVhIiBpZD0iZGVjbGFyYWNpb25fZXNwZWNpZmljYTUiPgogICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgPGRpdj4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCSAgICAgICAgICAgICAgIAkgIDxzcGFuIGNsYXNzPSJldGlxdWV0YUNoZWNrIj48aW5wdXQgY2hlY2tlZD0iY2hlY2tlZCIgY2xhc3M9ImlucHV0VmFsb3JGaWpvQ2hlY2siIGRpc2FibGVkPSJkaXNhYmxlZCIgdHlwZT0iY2hlY2tib3giIHZhbHVlPSIxIi8+PHNwYW4gY2xhc3M9InRleHRvVmFsb3JGaWpvQ2hlY2siPiogTm8gZXN0w6EgaW5jdXJzYSBlbiBpbmNhcGFjaWRhZCBvIHByb2hpYmljacOzbiBjb25mb3JtZSBhIGxhIGxlZ2lzbGFjacOzbiB2aWdlbnRlLjwvc3Bhbj48L3NwYW4+CiAgICAgICAgICAgICAgIAkgICAgICAgICAgICAgICAgICAgICAgICAJPC9kaXY+CiAgICAgICAgICAgICAgIDwvZGl2PgogICAKCiAgICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9ImRpdkVuTGluZWEiIGlkPSJkZWNsYXJhY2lvbl9lc3BlY2lmaWNhNiI+CiAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICA8ZGl2PgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAJICAgICAgICAgICAgICAgCSAgPHNwYW4gY2xhc3M9ImV0aXF1ZXRhQ2hlY2siPjxpbnB1dCBjaGVja2VkPSJjaGVja2VkIiBjbGFzcz0iaW5wdXRWYWxvckZpam9DaGVjayIgZGlzYWJsZWQ9ImRpc2FibGVkIiB0eXBlPSJjaGVja2JveCIgdmFsdWU9IjEiLz48c3BhbiBjbGFzcz0idGV4dG9WYWxvckZpam9DaGVjayI+KiBObyBoYSBzaWRvIHN1c3BlbmRpZGEgcG9yIHNhbmNpw7NuIGZpcm1lIHBhcmEgZWwgZWplcmNpY2lvIGRlIGxhIGFjdGl2aWRhZCBkZSBtZWRpYWNpw7NuIGNvbmZvcm1lIGEgbG8gZGlzcHVlc3RvIGVuIGVsIGFydMOtY3VsbyA1NiBkZSBsYSBMZXkgMjYvMjAwNiwgZGUgMTcgZGUganVsaW8sIGRlIG1lZGlhY2nDs24gZGUgc2VndXJvcyB5IHJlYXNlZ3Vyb3MgcHJpdmFkb3MuPC9zcGFuPjwvc3Bhbj4KICAgICAgICAgICAgICAgCSAgICAgICAgICAgICAgICAgICAgICAgIAk8L2Rpdj4KICAgICAgICAgICAgICAgPC9kaXY+CiAgIAoKICAgICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzcz0iZGl2RW5MaW5lYSIgaWQ9ImRlY2xhcmFjaW9uX2VzcGVjaWZpY2E3Ij4KICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgIDxkaXY+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAkgICAgICAgICAgICAgICAJICA8c3BhbiBjbGFzcz0iZXRpcXVldGFDaGVjayI+PGlucHV0IGNoZWNrZWQ9ImNoZWNrZWQiIGNsYXNzPSJpbnB1dFZhbG9yRmlqb0NoZWNrIiBkaXNhYmxlZD0iZGlzYWJsZWQiIHR5cGU9ImNoZWNrYm94IiB2YWx1ZT0iMSIvPjxzcGFuIGNsYXNzPSJ0ZXh0b1ZhbG9yRmlqb0NoZWNrIj4qIENhcmVjZSBkZSBhbnRlY2VkZW50ZXMgcGVuYWxlcyBwb3IgZGVsaXRvcyBkZSBmYWxzZWRhZCwgdmlvbGFjacOzbiBkZSBzZWNyZXRvcywgZGVzY3VicmltaWVudG8geSByZXZlbGFjacOzbiBkZSBzZWNyZXRvcyBjb250cmEgbGEgaGFjaWVuZGEgcMO6YmxpY2EgeSBjb250cmEgbGEgc2VndXJpZGFkIHNvY2lhbCwgbWFsdmVyc2FjacOzbiBkZSBjYXVkYWxlcyBww7pibGljb3MgeSBjdWFsZXNxdWllcmEgb3Ryb3MgZGVsaXRvcyBjb250cmEgbGEgcHJvcGllZGFkLjwvc3Bhbj48L3NwYW4+CiAgICAgICAgICAgICAgIAkgICAgICAgICAgICAgICAgICAgICAgICAJPC9kaXY+CiAgICAgICAgICAgICAgIDwvZGl2PgogICAKCiAgICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9ImRpdkVuTGluZWEiIGlkPSJkZWNsYXJhY2lvbl9lc3BlY2lmaWNhOCI+CiAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICA8ZGl2PgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAJICAgICAgICAgICAgICAgCSAgPHNwYW4gY2xhc3M9ImV0aXF1ZXRhQ2hlY2siPjxpbnB1dCBjaGVja2VkPSJjaGVja2VkIiBjbGFzcz0iaW5wdXRWYWxvckZpam9DaGVjayIgZGlzYWJsZWQ9ImRpc2FibGVkIiB0eXBlPSJjaGVja2JveCIgdmFsdWU9IjEiLz48c3BhbiBjbGFzcz0idGV4dG9WYWxvckZpam9DaGVjayI+KiBObyBvc3RlbnRhIGNhcmdvIG5pIGRlc2Fycm9sbGEgZnVuY2nDs24gYWxndW5hIHF1ZSBwdWVkYSBpbmN1cnJpciBlbiBsb3Mgc3VwdWVzdG9zIGRlIGluY29tcGF0aWJpbGlkYWQgY29udGVtcGxhZG9zIGVuIGxvcyBhcnTDrWN1bG9zICAzMSB5IDMyIGRlIGxhIExleSAyNi8yMDA2Ljwvc3Bhbj48L3NwYW4+CiAgICAgICAgICAgICAgIAkgICAgICAgICAgICAgICAgICAgICAgICAJPC9kaXY+CiAgICAgICAgICAgICAgIDwvZGl2PgogICAKCiAgICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9ImRpdkVuTGluZWEiIGlkPSJkZWNsYXJhY2lvbl9lc3BlY2lmaWNhOSI+CiAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICA8ZGl2PgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAJICAgICAgICAgICAgICAgCSAgPHNwYW4gY2xhc3M9ImV0aXF1ZXRhQ2hlY2siPjxpbnB1dCBjaGVja2VkPSJjaGVja2VkIiBjbGFzcz0iaW5wdXRWYWxvckZpam9DaGVjayIgZGlzYWJsZWQ9ImRpc2FibGVkIiB0eXBlPSJjaGVja2JveCIgdmFsdWU9IjEiLz48c3BhbiBjbGFzcz0idGV4dG9WYWxvckZpam9DaGVjayI+KiBBc2ltaXNtbyBkZWNsYXJhIHF1ZSB0b2RvIGVsIHBlcnNvbmFsIHF1ZSBwYXJ0aWNpcGEgZGlyZWN0YW1lbnRlIGVuIGxhIG1lZGlhY2nDs24gZGUgc2VndXJvcyBjdW1wbGUgY29uIGxvcyByZXF1aXNpdG9zIGRlIGhvbm9yYWJpbGlkYWQgYW50ZXJpb3Jlcy48L3NwYW4+PC9zcGFuPgogICAgICAgICAgICAgICAJICAgICAgICAgICAgICAgICAgICAgICAgCTwvZGl2PgogICAgICAgICAgICAgICA8L2Rpdj4KICAgCjwvZGl2Pgo8L2Rpdj4KCgoKCgk8ZGl2IGNsYXNzPSJ0b29sa2l0TjQiIGlkPSJncnVwb0RlY2xhcmFjUmVzdG8iPgoKCTxkaXYgY2xhc3M9InRvb2xraXROIj4KCgogICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzPSJkaXZFbkxpbmVhIiBpZD0iZGVjbGFyYWNpb25fZXNwZWNpZmljYTEwIj4KICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgIDxkaXY+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAkgICAgICAgICAgICAgICAJICA8c3BhbiBjbGFzcz0iZXRpcXVldGFDaGVjayI+PGlucHV0IGNoZWNrZWQ9ImNoZWNrZWQiIGNsYXNzPSJpbnB1dFZhbG9yRmlqb0NoZWNrIiBkaXNhYmxlZD0iZGlzYWJsZWQiIHR5cGU9ImNoZWNrYm94IiB2YWx1ZT0iMSIvPjxzcGFuIGNsYXNzPSJ0ZXh0b1ZhbG9yRmlqb0NoZWNrIj4qIEN1bXBsZSBjb24gbG9zIHJlcXVpc2l0b3MgZXN0YWJsZWNpZG9zIGVuIGxhIG5vcm1hdGl2YSB2aWdlbnRlLjwvc3Bhbj48L3NwYW4+CiAgICAgICAgICAgICAgIAkgICAgICAgICAgICAgICAgICAgICAgICAJPC9kaXY+CiAgICAgICAgICAgICAgIDwvZGl2PgogICAKCiAgICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9ImRpdkVuTGluZWEiIGlkPSJkZWNsYXJhY2lvbl9lc3BlY2lmaWNhMTEiPgogICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgPGRpdj4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCSAgICAgICAgICAgICAgIAkgIDxzcGFuIGNsYXNzPSJldGlxdWV0YUNoZWNrIj48aW5wdXQgY2hlY2tlZD0iY2hlY2tlZCIgY2xhc3M9ImlucHV0VmFsb3JGaWpvQ2hlY2siIGRpc2FibGVkPSJkaXNhYmxlZCIgdHlwZT0iY2hlY2tib3giIHZhbHVlPSIxIi8+PHNwYW4gY2xhc3M9InRleHRvVmFsb3JGaWpvQ2hlY2siPiogU29uIGNpZXJ0b3MgeSBjb21wbGV0b3MgdG9kb3MgbG9zIGRhdG9zIGRlIGxhIHByZXNlbnRlIHNvbGljaXR1ZCwgYXPDrSBjb21vIHRvZGEgbGEgZG9jdW1lbnRhY2nDs24gcXVlIHByZXNlbnRvIHkgYXN1bW8gbGEgY29ycmVzcG9uZGllbnRlIHJlc3BvbnNhYmlsaWRhZCAoQXJ0w61jdWxvIDI4LjcsIGRlIGxhIExleSAzOS8yMDE1LCBkZSAxIGRlIG9jdHVicmUsIGRlbCBQcm9jZWRpbWllbnRvIEFkbWluaXN0cmF0aXZvIENvbcO6biBkZSBsYXMgQWRtaW5pc3RyYWNpb25lcyBQw7pibGljYXMpLjxici8+PGJyLz5MYSBpbmV4YWN0aXR1ZCwgZmFsc2VkYWQgdSBvbWlzacOzbiwgZGUgY2Fyw6FjdGVyIGVzZW5jaWFsLCBkZSBjdWFscXVpZXIgZGF0byBvIGluZm9ybWFjacOzbiBxdWUgc2UgaW5jb3Jwb3JlIGEgdW5hIGRlY2xhcmFjacOzbiByZXNwb25zYWJsZSBvIGEgdW5hIGNvbXVuaWNhY2nDs24sIG8gbGEgbm8gcHJlc2VudGFjacOzbiBhbnRlIGxhIEFkbWluaXN0cmFjacOzbiBjb21wZXRlbnRlIGRlIGxhIGRlY2xhcmFjacOzbiByZXNwb25zYWJsZSwgbGEgZG9jdW1lbnRhY2nDs24gcXVlIHNlYSBlbiBzdSBjYXNvIHJlcXVlcmlkYSBwYXJhIGFjcmVkaXRhciBlbCBjdW1wbGltaWVudG8gZGUgbG8gZGVjbGFyYWRvLCBvIGxhIGNvbXVuaWNhY2nDs24sIGRldGVybWluYXLDoSBsYSBpbXBvc2liaWxpZGFkIGRlIGNvbnRpbnVhciBjb24gZWwgZWplcmNpY2lvIGRlbCBkZXJlY2hvIG8gYWN0aXZpZGFkIGFmZWN0YWRhIGRlc2RlIGVsIG1vbWVudG8gZW4gcXVlIHNlIHRlbmdhIGNvbnN0YW5jaWEgZGUgdGFsZXMgaGVjaG9zLCBzaW4gcGVyanVpY2lvIGRlIGxhcyByZXNwb25zYWJpbGlkYWRlcyBwZW5hbGVzLCBjaXZpbGVzIG8gYWRtaW5pc3RyYXRpdmFzIGEgcXVlIGh1YmllcmEgbHVnYXIgKEFydMOtY3VsbyA2OS40LCBkZSBsYSBMZXkgMzkvMjAxNSwgZGUgMSBkZSBvY3R1YnJlLCBkZWwgUHJvY2VkaW1pZW50byBBZG1pbmlzdHJhdGl2byBDb23Dum4gZGUgbGFzIEFkbWluaXN0cmFjaW9uZXMgUMO6YmxpY2FzKS48L3NwYW4+PC9zcGFuPgogICAgICAgICAgICAgICAJICAgICAgICAgICAgICAgICAgICAgICAgCTwvZGl2PgogICAgICAgICAgICAgICA8L2Rpdj4KICAgCjwvZGl2Pgo8L2Rpdj4KPC9kaXY+CjwvZGl2Pgo8L2Rpdj4KPC9kaXY+CjwvZGl2Pgo8L2Rpdj4KCgoJPC9kaXY+Cgk8ZGl2IGNsYXNzPSJ0b29sa2l0TjEiPgoJPC9kaXY+CgogICAgICAgICAgICAgIDxkaXYgY2xhc3M9InRvb2xraXREb2N1bWVudG9zIiBpZD0iZG9jdW1lbnRvc0Fwb3J0YWRvcyI+CiAgICAgICA8aDI+RG9jdW1lbnRvcyBhcG9ydGFkb3M8L2gyPgogICAgICAgPHRhYmxlPgogICAgICAgPHRoZWFkPgogICAgICAgPHRoPlRpcG8gZGUgZG9jdW1lbnRvPC90aD4KICAgICAgIDx0aD5Ob21icmUgPC90aD4KICAgICAgIDwvdGhlYWQ+CiAgICAgICAgICA8dGJvZHk+CiAgICAgICAgICAgICAgICAgICAgICAgICAgIDx0cj4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDx0ZD5BY3JlZGl0YWNpw7NuIGRlIGNhcGFjaWRhZCBmaW5hbmNpZXJhIChBdmFsIG8gc2VndXJvIGRlIGNhdWNpw7NuKTwvdGQ+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dGQgc3R5bGU9IndvcmQtYnJlYWs6IGJyZWFrLWFsbCI+cmVwb3J0LnBkZjwvdGQ+CiAgICAgICAgICAgICAgIDwvdHI+IAogICAgICAgICAgICAgICAgICAgICAgICAgICAgPHRyPgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHRkPkNvcGlhIGNvbnRyYXRvIGVudGlkYWRlcyBhc2VndXJhZG9yYXMgdmluY3VsYWRhczwvdGQ+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dGQgc3R5bGU9IndvcmQtYnJlYWs6IGJyZWFrLWFsbCI+MTEucGRmPC90ZD4KICAgICAgICAgICAgICAgPC90cj4gCiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dHI+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dGQ+TWVtb3JpYSBkZSBBY3RpdmlkYWRlczwvdGQ+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dGQgc3R5bGU9IndvcmQtYnJlYWs6IGJyZWFrLWFsbCI+cmVwb3J0ICgxKS5wZGY8L3RkPgogICAgICAgICAgICAgICA8L3RyPiAKICAgICAgICAgICAgICAgICAgICAgICAgICAgIDx0cj4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDx0ZD5Db3BpYSBjb250cmF0byBlbnRpZGFkZXMgYXNlZ3VyYWRvcmFzIHZpbmN1bGFkYXM8L3RkPgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHRkIHN0eWxlPSJ3b3JkLWJyZWFrOiBicmVhay1hbGwiPlVzdWFyaW9zIHBvciBncnVwby5wZGY8L3RkPgogICAgICAgICAgICAgICA8L3RyPiAKICAgICAgICAgICAgICAgICAgICAgIDwvdGJvZHk+CiAgICAgIDwvdGFibGU+IAogICAgICA8L2Rpdj4KICAgICAgICAgICAgCiAgICAgIAogICAgICAKICAgICAgPGRpdiBpZD0iZmlybWFkb1BvciI+PGgyIGlkPSJwaWUiPkZpcm1hZG8gZWxlY3Ryw7NuaWNhbWVudGUgcG9yOjwvaDI+PHA+Q0lVREFEQU5PIEZJQ1RJQ0lPIEFDVElWTyAoOTk5OTk5OTBTKTwvcD48L2Rpdj4KICAgPC9kaXY+ICAgCiAgIDwvYm9keT4KPC9odG1sPg==</sign>               </bodyEvent>             </ejgvDocumentEvent>           </signEvent>           <signerID>99999990S</signerID>           <signerName>CIUDADANO FICTICIO ACTIVO</signerName>           <departmentID>56</departmentID>           <entityID>04833001</entityID>           <format>html</format>         </signatureEvent>       </signaturesEvent>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Solicitud</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>TRUE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>CIUDADANO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>99999990S</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap1_titularoaport</name>           <value>FICTICIO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap2_titularoaport</name>           <value>ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>DNI</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_poliza.0.ejgv_reg_0003</roleId>       <roleNameEs>Pliza de responsabilidad civil</roleNameEs>       <roleNameEu>Erantzukizun zibileko poliza</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Pliza de responsabilidad civil</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>CIUDADANO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>99999990S</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap1_titularoaport</name>           <value>FICTICIO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap2_titularoaport</name>           <value>ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>DNI</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_programa.0.ejgv_reg_0002</roleId>       <roleNameEs>Programa de actividades y formacin</roleNameEs>       <roleNameEu>Prestakuntza- eta ekintza-programa</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Programa de actividades y formacin</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>CIUDADANO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>99999990S</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap1_titularoaport</name>           <value>FICTICIO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap2_titularoaport</name>           <value>ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>DNI</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_titacademico.0.ejgv_reg_0004</roleId>       <roleNameEs>Diploma de mediador de seguros</roleNameEs>       <roleNameEu>Aseguru Bitartekariaren Diploma</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Diploma de mediador de seguros</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>CIUDADANO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>99999990S</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap1_titularoaport</name>           <value>FICTICIO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap2_titularoaport</name>           <value>ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>DNI</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid/>       <roleId>ejgv_d_certificado.0.ejgv_reg_0061</roleId>       <roleNameEs>Certificado de curso formativo Grupo A</roleNameEs>       <roleNameEu>Prestakuntza-ikastaroaren ziurtagiria. A taldea</roleNameEu>       <documentType>DNA</documentType>       <format>E</format>       <location/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Certificado de curso formativo Grupo A</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>CIUDADANO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>99999990S</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap1_titularoaport</name>           <value>FICTICIO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_ap2_titularoaport</name>           <value>ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>DNI</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>   </documentsEvent>   <dataControlEvent>     <type>MESSAGECONTROL</type>     <value>S</value>   </dataControlEvent>   <dataControlEvent>     <type>CERTIFIEDVALIDATIONMODE</type>     <value>ASYNC</value>   </dataControlEvent> </contextSubmissionEvent>]]></xmlValue> </NotificationBody>");
		   //Error Conchi Nulo AC
//		   sendMessage("<NotificationBody xmlns=\"com/ejie/notification/xml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <Property>     <Name>EventWho</Name>     <Value>R02</Value>   </Property>   <Property>     <Name>EventTipology</Name>     <Value>R02_TRAMITATION</Value>   </Property>   <Property>     <Name>EventWhat</Name>     <Value>R02_REQUEST</Value>   </Property>   <Property>     <Name>ProcedureID</Name>     <Value>0009402</Value>   </Property>   <Property>     <Name>PlateaType</Name>     <Value>SOLTELEMATICA</Value>   </Property>   <Property>     <Name>PlateaSubType</Name>     <Value>1</Value>   </Property>   <Property>     <Name>Mailbox</Name>     <Value xsi:nil=\"true\"/>   </Property>   <Property>     <Name>Status</Name>     <Value xsi:nil=\"true\"/>   </Property>   <xmlValue><![CDATA[<contextSubmissionEvent xmlns=\"com/ejie/folderManagement/xml\">   <daDocumentalSeries>5744</daDocumentalSeries>   <departmentID>56</departmentID>   <departmentNameEs>HACIENDA Y ECONOMA</departmentNameEs>   <departmentNameEu>OGASUNA ETA EKONOMIA</departmentNameEu>   <entityID>04833001</entityID>   <entityNameEs>Administracin Pblica de la CAE</entityNameEs>   <entityNameEu>EAEko Administrazio Publikoa</entityNameEu>   <familyID>REGIST</familyID>   <folderID>R02TC5A402B12743B8642587B653A897C425ACE66F18</folderID>   <creationTimestamp>20/09/2017 11:56:26</creationTimestamp>   <mailbox>R01I-Y52B-RMS02</mailbox>   <managingUnitID>2284</managingUnitID>   <managingUnitNameEs>DIRECCIN DE POLTICA FINANCIERA Y RECURSOS INSTITUCIONALES</managingUnitNameEs>   <managingUnitNameEu>FINANTZA POLITIKAKO ETA ERAKUNDEEN BALIABIDEETAKO ZUZENDARITZA</managingUnitNameEu>   <solicitudID>119032</solicitudID>   <procedureID>0009402</procedureID>   <procedureNameEs>Inscripcin en el registro de mediadores de seguros</procedureNameEs>   <procedureNameEu>Aseguru-artekarien erregistroan inskribatzea</procedureNameEu>   <procedureInboxID>R01I-Y52B-RMSRP01</procedureInboxID>   <procedureInboxName>Registro mediadores de seguros - Responsables</procedureInboxName>   <registryNumber>2017RTE00011192</registryNumber>   <registryTimestamp>20/09/2017 11:56:24</registryTimestamp>   <registrySenderID>99999990S</registrySenderID>   <registrySenderName>CIUDADANO FICTICIO ACTIVO</registrySenderName>   <registryAddresseeCode>2284</registryAddresseeCode>   <registryTopicCode>0009402</registryTopicCode>   <participantID>R02T978497A8C275EC21AD73B8F2AB45D6EA115C2E7C</participantID>   <senderID>99999990S</senderID>   <senderName>CIUDADANO FICTICIO ACTIVO</senderName>   <senderType>2</senderType>   <submissionType>1</submissionType>   <submissionTypeNameEs>Solicitud</submissionTypeNameEs>   <submissionTypeNameEu>Eskaera</submissionTypeNameEu>   <managerCalendarType>cal-capv</managerCalendarType>   <resolutionCalendarType>cal-capv</resolutionCalendarType>   <applicationID>R02T97006F43CFB88B7C29137FC81A3F013C95FE2347</applicationID>   <ApplicantsInfoEvent>     <ApplicantInfoEvent>       <notificationEvent>         <addresseeID>99999990S</addresseeID>         <addresseeName>CIUDADANO FICTICIO ACTIVO</addresseeName>         <channelType>1</channelType>       </notificationEvent>       <personsEvent>         <personEvent>           <id>J7102572J</id>           <name>ENTIDAD FICTICIO ACTIVO</name>           <personType>2</personType>           <holderShip>1</holderShip>         </personEvent>         <personEvent>           <id>99999990S</id>           <name>CIUDADANO</name>           <lastname1>FICTICIO</lastname1>           <lastname2>ACTIVO</lastname2>           <personType>1</personType>           <holderShip>2</holderShip>         </personEvent>       </personsEvent>       <language>es</language>     </ApplicantInfoEvent>   </ApplicantsInfoEvent>   <documentsEvent>     <documentEvent>       <oid>09f424018087ef82</oid>       <roleId>ejgv_d_aval.0.ejgv_reg_0005</roleId>       <roleNameEs>Acreditacin de capacidad financiera (Aval o seguro de caucin)</roleNameEs>       <roleNameEu>Finantza-gaitasunaren egiaztagiria</roleNameEu>       <sourceName>r76-permisos por usuario.pdf</sourceName>       <documentType>DAD</documentType>       <extension>pdf</extension>       <format>E</format>       <location>09f424018087ef82</location>       <signaturesEvent/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Acreditacin de capacidad financiera (Aval o seguro de caucin)</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid>09f424018087ef90</oid>       <roleId>ejgv_d_curriculum.0.ejgv_reg_0008</roleId>       <roleNameEs>Documentacin referente al titular del servicio</roleNameEs>       <roleNameEu>Eu_Documentacin referente al titular del servicio</roleNameEu>       <sourceName>Usuarios por grupo.pdf</sourceName>       <documentType>DAD</documentType>       <extension>pdf</extension>       <format>E</format>       <location>09f424018087ef90</location>       <signaturesEvent/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Documentacin referente al titular del servicio</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid>09f424018087ef83</oid>       <roleId>ejgv_d_acta.0.r02d7BD8D0277726D890DFC16184E086E60B0E676244</roleId>       <roleNameEs>Reglamento para la defensa del cliente</roleNameEs>       <roleNameEu>Eu_Reglamento para la defensa del cliente</roleNameEu>       <sourceName>report (2).pdf</sourceName>       <documentType>DAD</documentType>       <extension>pdf</extension>       <format>E</format>       <location>09f424018087ef83</location>       <signaturesEvent/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Reglamento para la defensa del cliente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid>09f424018087ef93</oid>       <roleId>ejgv_d_escritura.0.ejgv_reg_0062</roleId>       <roleNameEs>Copia de escritura de los estatutos de la entidad mercantil</roleNameEs>       <roleNameEu>Merkataritza- erakundearen estatutuen kopia</roleNameEu>       <sourceName>report (1).pdf</sourceName>       <documentType>DAD</documentType>       <extension>pdf</extension>       <format>E</format>       <location>09f424018087ef93</location>       <signaturesEvent/>       <descriptorsEvent>         <descriptorEvent>           <name>title</name>           <value>Copia de escritura de los estatutos de la entidad mercantil</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_origen</name>           <value>CIUDADANIA</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_firmacontenida</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_serie</name>           <value>5744</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_procedimiento</name>           <value>00094</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_naturaleza</name>           <value>ELECTRONICO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_es_apoyo</name>           <value>FALSE</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_estado</name>           <value>Vigente</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_nom_titularoaport</name>           <value>ENTIDAD FICTICIO ACTIVO</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_num_titularoaport</name>           <value>J7102572J</value>         </descriptorEvent>         <descriptorEvent>           <name>ejgv_tipo_titularoaport</name>           <value>NIE</value>         </descriptorEvent>       </descriptorsEvent>     </documentEvent>     <documentEvent>       <oid>09f424018087ef84</oid>       <roleId>ejgv_d_solicitud.0.0</roleId>       <roleNameEs>Solicitud</roleNameEs>       <roleNameEu>Eskabide</roleNameEu>       <sourceName>Solicitud.html</sourceName>       <documentType>PRE</documentType>       <extension>html</extension>       <format>E</format>       <sourceBinary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sourceBinary>       <signaturesEvent>         <signatureEvent>           <signEvent>             <ejgvDocumentEvent>               <headerEvent>                 <type>xades</type>                 <version>2.0</version>                 <placement>enveloped</placement>                 <flags>0</flags>                 <format>ES-T</format>               </headerEvent>               <bodyEvent>                 <sign>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